/*
* hal_disp_vga_timing_tbl.h- Sigmastar
*
* Copyright (c) [2019~2020] SigmaStar Technology.
*
*
* This software is licensed under the terms of the GNU General Public
* License version 2, as published by the Free Software Foundation, and
* may be copied, distributed, and modified under those terms.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License version 2 for more details.
*
*/

//****************************************************
// Drive Chip           : CAMDRV_VGA
// Excel CodeGen Version: 1.05
// Excel SW      Version: 1.01
// Excel update date    : 2019/9/20 14:29
//****************************************************

#ifndef _HAL_DISP_VGA_TIMING_TBL_H_
#define _HAL_DISP_VGA_TIMING_TBL_H_

#ifdef __cplusplus
extern "C"
{
#endif

#include "hal_disp_common.h"

#define DRV_REG(reg)           ((reg>>16)&0xFF), ((reg>>8)&0xFF), (reg&0xFF)
#define REG_ADDR_SIZE          3
#define REG_MASK_SIZE          1
#define REG_DATA_SIZE          1
#define REG_TABLE_END          0xFFFFFF

#ifndef _PK_L_
#define _PK_L_(bank, addr)     ((u16)(bank << 8) | ((addr)*2)) 
#endif
#ifndef _PK_H_
#define _PK_H_(bank, addr)     ((u16)((bank|0x80) << 8) | ((addr)*2+1)) 
#endif

////////////////////////////////////////////////////////////////////////////////
#define INIT_HDMITX_ATOP_REG_NUM        15
#define INIT_HDMITX_ATOP_COMMON_REG_NUM        17
#define INIT_FPLL_CTRL_REG_NUM        7
#define INIT_FPLL_CTRL_COMMON_REG_NUM        5
#define INIT_IDAC_ATOP_REG_NUM        2
#define INIT_IDAC_ATOP_COMMON_REG_NUM        7
#define INIT_SCALER_TGEN_COMMON_REG_NUM        29
#define INIT_DAC_TGEN_REG_NUM        8
#define INIT_DAC_TGEN_COMMON_REG_NUM        4
#define INIT_SCALER_RST_COMMON_REG_NUM        20
////////////////////////////////////////////////////////////////////////////////
#define  REG_HDMITX_ATOP_TB_BASE     0x112600
#define  REG_HDMITX_DTOP_TB_BASE     0x112500
#define  REG_DAC_ATOP_TB_BASE     0x112700
#define  REG_DISP_TOP_TB_BASE     0x112800
#define  REG_SC_GP_CTRL_TB_BASE     0x113300
#define  REG_CLKGEN_TB_BASE     0x103800
#define  REG_DISP_TOP_OP2_TB_BASE     0x112900
#define  REG_CHIP_TOP_TB_BASE     0x101E00

////////////////////////////////////////////////////////////////////////////////
typedef enum
{
    HAL_DISP_VGA_ID_480_60P=0x0,
    HAL_DISP_VGA_ID_576_50P=0x1,
    HAL_DISP_VGA_ID_720_50P=0x2,
    HAL_DISP_VGA_ID_720_60P=0x3,
    HAL_DISP_VGA_ID_1080_24P=0x4,
    HAL_DISP_VGA_ID_1080_25P=0x5,
    HAL_DISP_VGA_ID_1080_30P=0x6,
    HAL_DISP_VGA_ID_1080_50P=0x7,
    HAL_DISP_VGA_ID_1080_60P=0x8,
    HAL_DISP_VGA_ID_3840x2160_30P=0x9,
    HAL_DISP_VGA_ID_1024x768_60P=0xA,
    HAL_DISP_VGA_ID_1280x800_60P=0xB,
    HAL_DISP_VGA_ID_1280x1024_60P=0xC,
    HAL_DISP_VGA_ID_1366x768_60P=0xD,
    HAL_DISP_VGA_ID_1440x900_60P=0xE,
    HAL_DISP_VGA_ID_1680x1050_60P=0xF,
    HAL_DISP_VGA_ID_1600x1200_60P=0x10,
    HAL_DISP_VGA_ID_NUM=0x11,
} E_HAL_DISP_VGA_ID_TYPE;

typedef enum
{
    HAL_DISP_VGA_TAB_INIT_HDMITX_ATOP,
    HAL_DISP_VGA_COMMON_TAB_INIT_HDMITX_ATOP,
    HAL_DISP_VGA_TAB_INIT_FPLL_CTRL,
    HAL_DISP_VGA_COMMON_TAB_INIT_FPLL_CTRL,
    HAL_DISP_VGA_TAB_INIT_IDAC_ATOP,
    HAL_DISP_VGA_COMMON_TAB_INIT_IDAC_ATOP,
    HAL_DISP_VGA_TAB_INIT_DAC_TGEN,
    HAL_DISP_VGA_COMMON_TAB_INIT_DAC_TGEN,
    HAL_DISP_VGA_TAB_NUM,
} E_HAL_DISP_VGA_TAB_TYPE;

typedef enum
{
    HAL_DISP_VGA_IP_NORMAL,
    HAL_DISP_VGA_IP_COMMON
} E_HAL_DISP_VGA_IP_TYPE;

typedef struct
{
    u8                 *pData;
    u16                 u16RegNum;
    E_HAL_DISP_VGA_IP_TYPE enIPType;
} HAL_DISP_VGA_INFO;

extern HAL_DISP_VGA_INFO stHAL_DISP_VGA_TIMING_TBL[HAL_DISP_VGA_TAB_NUM];

//-------------------------------------------------------------------------------------------------
// register define used for TCON table
//-------------------------------------------------------------------------------------------------

#define  REG_HDMITX_ATOP_TB_00_L       (REG_HDMITX_ATOP_TB_BASE + 0x00)
#define  REG_HDMITX_ATOP_TB_00_H       (REG_HDMITX_ATOP_TB_BASE + 0x01)
#define  REG_HDMITX_ATOP_TB_01_L       (REG_HDMITX_ATOP_TB_BASE + 0x02)
#define  REG_HDMITX_ATOP_TB_01_H       (REG_HDMITX_ATOP_TB_BASE + 0x03)
#define  REG_HDMITX_ATOP_TB_02_L       (REG_HDMITX_ATOP_TB_BASE + 0x04)
#define  REG_HDMITX_ATOP_TB_02_H       (REG_HDMITX_ATOP_TB_BASE + 0x05)
#define  REG_HDMITX_ATOP_TB_03_L       (REG_HDMITX_ATOP_TB_BASE + 0x06)
#define  REG_HDMITX_ATOP_TB_03_H       (REG_HDMITX_ATOP_TB_BASE + 0x07)
#define  REG_HDMITX_ATOP_TB_04_L       (REG_HDMITX_ATOP_TB_BASE + 0x08)
#define  REG_HDMITX_ATOP_TB_04_H       (REG_HDMITX_ATOP_TB_BASE + 0x09)
#define  REG_HDMITX_ATOP_TB_05_L       (REG_HDMITX_ATOP_TB_BASE + 0x0A)
#define  REG_HDMITX_ATOP_TB_05_H       (REG_HDMITX_ATOP_TB_BASE + 0x0B)
#define  REG_HDMITX_ATOP_TB_06_L       (REG_HDMITX_ATOP_TB_BASE + 0x0C)
#define  REG_HDMITX_ATOP_TB_06_H       (REG_HDMITX_ATOP_TB_BASE + 0x0D)
#define  REG_HDMITX_ATOP_TB_07_L       (REG_HDMITX_ATOP_TB_BASE + 0x0E)
#define  REG_HDMITX_ATOP_TB_07_H       (REG_HDMITX_ATOP_TB_BASE + 0x0F)
#define  REG_HDMITX_ATOP_TB_08_L       (REG_HDMITX_ATOP_TB_BASE + 0x10)
#define  REG_HDMITX_ATOP_TB_08_H       (REG_HDMITX_ATOP_TB_BASE + 0x11)
#define  REG_HDMITX_ATOP_TB_09_L       (REG_HDMITX_ATOP_TB_BASE + 0x12)
#define  REG_HDMITX_ATOP_TB_09_H       (REG_HDMITX_ATOP_TB_BASE + 0x13)
#define  REG_HDMITX_ATOP_TB_0A_L       (REG_HDMITX_ATOP_TB_BASE + 0x14)
#define  REG_HDMITX_ATOP_TB_0A_H       (REG_HDMITX_ATOP_TB_BASE + 0x15)
#define  REG_HDMITX_ATOP_TB_0B_L       (REG_HDMITX_ATOP_TB_BASE + 0x16)
#define  REG_HDMITX_ATOP_TB_0B_H       (REG_HDMITX_ATOP_TB_BASE + 0x17)
#define  REG_HDMITX_ATOP_TB_0C_L       (REG_HDMITX_ATOP_TB_BASE + 0x18)
#define  REG_HDMITX_ATOP_TB_0C_H       (REG_HDMITX_ATOP_TB_BASE + 0x19)
#define  REG_HDMITX_ATOP_TB_0D_L       (REG_HDMITX_ATOP_TB_BASE + 0x1A)
#define  REG_HDMITX_ATOP_TB_0D_H       (REG_HDMITX_ATOP_TB_BASE + 0x1B)
#define  REG_HDMITX_ATOP_TB_0E_L       (REG_HDMITX_ATOP_TB_BASE + 0x1C)
#define  REG_HDMITX_ATOP_TB_0E_H       (REG_HDMITX_ATOP_TB_BASE + 0x1D)
#define  REG_HDMITX_ATOP_TB_0F_L       (REG_HDMITX_ATOP_TB_BASE + 0x1E)
#define  REG_HDMITX_ATOP_TB_0F_H       (REG_HDMITX_ATOP_TB_BASE + 0x1F)
#define  REG_HDMITX_ATOP_TB_10_L       (REG_HDMITX_ATOP_TB_BASE + 0x20)
#define  REG_HDMITX_ATOP_TB_10_H       (REG_HDMITX_ATOP_TB_BASE + 0x21)
#define  REG_HDMITX_ATOP_TB_11_L       (REG_HDMITX_ATOP_TB_BASE + 0x22)
#define  REG_HDMITX_ATOP_TB_11_H       (REG_HDMITX_ATOP_TB_BASE + 0x23)
#define  REG_HDMITX_ATOP_TB_12_L       (REG_HDMITX_ATOP_TB_BASE + 0x24)
#define  REG_HDMITX_ATOP_TB_12_H       (REG_HDMITX_ATOP_TB_BASE + 0x25)
#define  REG_HDMITX_ATOP_TB_13_L       (REG_HDMITX_ATOP_TB_BASE + 0x26)
#define  REG_HDMITX_ATOP_TB_13_H       (REG_HDMITX_ATOP_TB_BASE + 0x27)
#define  REG_HDMITX_ATOP_TB_14_L       (REG_HDMITX_ATOP_TB_BASE + 0x28)
#define  REG_HDMITX_ATOP_TB_14_H       (REG_HDMITX_ATOP_TB_BASE + 0x29)
#define  REG_HDMITX_ATOP_TB_15_L       (REG_HDMITX_ATOP_TB_BASE + 0x2A)
#define  REG_HDMITX_ATOP_TB_15_H       (REG_HDMITX_ATOP_TB_BASE + 0x2B)
#define  REG_HDMITX_ATOP_TB_16_L       (REG_HDMITX_ATOP_TB_BASE + 0x2C)
#define  REG_HDMITX_ATOP_TB_16_H       (REG_HDMITX_ATOP_TB_BASE + 0x2D)
#define  REG_HDMITX_ATOP_TB_17_L       (REG_HDMITX_ATOP_TB_BASE + 0x2E)
#define  REG_HDMITX_ATOP_TB_17_H       (REG_HDMITX_ATOP_TB_BASE + 0x2F)
#define  REG_HDMITX_ATOP_TB_18_L       (REG_HDMITX_ATOP_TB_BASE + 0x30)
#define  REG_HDMITX_ATOP_TB_18_H       (REG_HDMITX_ATOP_TB_BASE + 0x31)
#define  REG_HDMITX_ATOP_TB_19_L       (REG_HDMITX_ATOP_TB_BASE + 0x32)
#define  REG_HDMITX_ATOP_TB_19_H       (REG_HDMITX_ATOP_TB_BASE + 0x33)
#define  REG_HDMITX_ATOP_TB_1A_L       (REG_HDMITX_ATOP_TB_BASE + 0x34)
#define  REG_HDMITX_ATOP_TB_1A_H       (REG_HDMITX_ATOP_TB_BASE + 0x35)
#define  REG_HDMITX_ATOP_TB_1B_L       (REG_HDMITX_ATOP_TB_BASE + 0x36)
#define  REG_HDMITX_ATOP_TB_1B_H       (REG_HDMITX_ATOP_TB_BASE + 0x37)
#define  REG_HDMITX_ATOP_TB_1C_L       (REG_HDMITX_ATOP_TB_BASE + 0x38)
#define  REG_HDMITX_ATOP_TB_1C_H       (REG_HDMITX_ATOP_TB_BASE + 0x39)
#define  REG_HDMITX_ATOP_TB_1D_L       (REG_HDMITX_ATOP_TB_BASE + 0x3A)
#define  REG_HDMITX_ATOP_TB_1D_H       (REG_HDMITX_ATOP_TB_BASE + 0x3B)
#define  REG_HDMITX_ATOP_TB_1E_L       (REG_HDMITX_ATOP_TB_BASE + 0x3C)
#define  REG_HDMITX_ATOP_TB_1E_H       (REG_HDMITX_ATOP_TB_BASE + 0x3D)
#define  REG_HDMITX_ATOP_TB_1F_L       (REG_HDMITX_ATOP_TB_BASE + 0x3E)
#define  REG_HDMITX_ATOP_TB_1F_H       (REG_HDMITX_ATOP_TB_BASE + 0x3F)
#define  REG_HDMITX_ATOP_TB_20_L       (REG_HDMITX_ATOP_TB_BASE + 0x40)
#define  REG_HDMITX_ATOP_TB_20_H       (REG_HDMITX_ATOP_TB_BASE + 0x41)
#define  REG_HDMITX_ATOP_TB_21_L       (REG_HDMITX_ATOP_TB_BASE + 0x42)
#define  REG_HDMITX_ATOP_TB_21_H       (REG_HDMITX_ATOP_TB_BASE + 0x43)
#define  REG_HDMITX_ATOP_TB_22_L       (REG_HDMITX_ATOP_TB_BASE + 0x44)
#define  REG_HDMITX_ATOP_TB_22_H       (REG_HDMITX_ATOP_TB_BASE + 0x45)
#define  REG_HDMITX_ATOP_TB_23_L       (REG_HDMITX_ATOP_TB_BASE + 0x46)
#define  REG_HDMITX_ATOP_TB_23_H       (REG_HDMITX_ATOP_TB_BASE + 0x47)
#define  REG_HDMITX_ATOP_TB_24_L       (REG_HDMITX_ATOP_TB_BASE + 0x48)
#define  REG_HDMITX_ATOP_TB_24_H       (REG_HDMITX_ATOP_TB_BASE + 0x49)
#define  REG_HDMITX_ATOP_TB_25_L       (REG_HDMITX_ATOP_TB_BASE + 0x4A)
#define  REG_HDMITX_ATOP_TB_25_H       (REG_HDMITX_ATOP_TB_BASE + 0x4B)
#define  REG_HDMITX_ATOP_TB_26_L       (REG_HDMITX_ATOP_TB_BASE + 0x4C)
#define  REG_HDMITX_ATOP_TB_26_H       (REG_HDMITX_ATOP_TB_BASE + 0x4D)
#define  REG_HDMITX_ATOP_TB_27_L       (REG_HDMITX_ATOP_TB_BASE + 0x4E)
#define  REG_HDMITX_ATOP_TB_27_H       (REG_HDMITX_ATOP_TB_BASE + 0x4F)
#define  REG_HDMITX_ATOP_TB_28_L       (REG_HDMITX_ATOP_TB_BASE + 0x50)
#define  REG_HDMITX_ATOP_TB_28_H       (REG_HDMITX_ATOP_TB_BASE + 0x51)
#define  REG_HDMITX_ATOP_TB_29_L       (REG_HDMITX_ATOP_TB_BASE + 0x52)
#define  REG_HDMITX_ATOP_TB_29_H       (REG_HDMITX_ATOP_TB_BASE + 0x53)
#define  REG_HDMITX_ATOP_TB_2A_L       (REG_HDMITX_ATOP_TB_BASE + 0x54)
#define  REG_HDMITX_ATOP_TB_2A_H       (REG_HDMITX_ATOP_TB_BASE + 0x55)
#define  REG_HDMITX_ATOP_TB_2B_L       (REG_HDMITX_ATOP_TB_BASE + 0x56)
#define  REG_HDMITX_ATOP_TB_2B_H       (REG_HDMITX_ATOP_TB_BASE + 0x57)
#define  REG_HDMITX_ATOP_TB_2C_L       (REG_HDMITX_ATOP_TB_BASE + 0x58)
#define  REG_HDMITX_ATOP_TB_2C_H       (REG_HDMITX_ATOP_TB_BASE + 0x59)
#define  REG_HDMITX_ATOP_TB_2D_L       (REG_HDMITX_ATOP_TB_BASE + 0x5A)
#define  REG_HDMITX_ATOP_TB_2D_H       (REG_HDMITX_ATOP_TB_BASE + 0x5B)
#define  REG_HDMITX_ATOP_TB_2E_L       (REG_HDMITX_ATOP_TB_BASE + 0x5C)
#define  REG_HDMITX_ATOP_TB_2E_H       (REG_HDMITX_ATOP_TB_BASE + 0x5D)
#define  REG_HDMITX_ATOP_TB_2F_L       (REG_HDMITX_ATOP_TB_BASE + 0x5E)
#define  REG_HDMITX_ATOP_TB_2F_H       (REG_HDMITX_ATOP_TB_BASE + 0x5F)
#define  REG_HDMITX_ATOP_TB_30_L       (REG_HDMITX_ATOP_TB_BASE + 0x60)
#define  REG_HDMITX_ATOP_TB_30_H       (REG_HDMITX_ATOP_TB_BASE + 0x61)
#define  REG_HDMITX_ATOP_TB_31_L       (REG_HDMITX_ATOP_TB_BASE + 0x62)
#define  REG_HDMITX_ATOP_TB_31_H       (REG_HDMITX_ATOP_TB_BASE + 0x63)
#define  REG_HDMITX_ATOP_TB_32_L       (REG_HDMITX_ATOP_TB_BASE + 0x64)
#define  REG_HDMITX_ATOP_TB_32_H       (REG_HDMITX_ATOP_TB_BASE + 0x65)
#define  REG_HDMITX_ATOP_TB_33_L       (REG_HDMITX_ATOP_TB_BASE + 0x66)
#define  REG_HDMITX_ATOP_TB_33_H       (REG_HDMITX_ATOP_TB_BASE + 0x67)
#define  REG_HDMITX_ATOP_TB_34_L       (REG_HDMITX_ATOP_TB_BASE + 0x68)
#define  REG_HDMITX_ATOP_TB_34_H       (REG_HDMITX_ATOP_TB_BASE + 0x69)
#define  REG_HDMITX_ATOP_TB_35_L       (REG_HDMITX_ATOP_TB_BASE + 0x6A)
#define  REG_HDMITX_ATOP_TB_35_H       (REG_HDMITX_ATOP_TB_BASE + 0x6B)
#define  REG_HDMITX_ATOP_TB_36_L       (REG_HDMITX_ATOP_TB_BASE + 0x6C)
#define  REG_HDMITX_ATOP_TB_36_H       (REG_HDMITX_ATOP_TB_BASE + 0x6D)
#define  REG_HDMITX_ATOP_TB_37_L       (REG_HDMITX_ATOP_TB_BASE + 0x6E)
#define  REG_HDMITX_ATOP_TB_37_H       (REG_HDMITX_ATOP_TB_BASE + 0x6F)
#define  REG_HDMITX_ATOP_TB_38_L       (REG_HDMITX_ATOP_TB_BASE + 0x70)
#define  REG_HDMITX_ATOP_TB_38_H       (REG_HDMITX_ATOP_TB_BASE + 0x71)
#define  REG_HDMITX_ATOP_TB_39_L       (REG_HDMITX_ATOP_TB_BASE + 0x72)
#define  REG_HDMITX_ATOP_TB_39_H       (REG_HDMITX_ATOP_TB_BASE + 0x73)
#define  REG_HDMITX_ATOP_TB_3A_L       (REG_HDMITX_ATOP_TB_BASE + 0x74)
#define  REG_HDMITX_ATOP_TB_3A_H       (REG_HDMITX_ATOP_TB_BASE + 0x75)
#define  REG_HDMITX_ATOP_TB_3B_L       (REG_HDMITX_ATOP_TB_BASE + 0x76)
#define  REG_HDMITX_ATOP_TB_3B_H       (REG_HDMITX_ATOP_TB_BASE + 0x77)
#define  REG_HDMITX_ATOP_TB_3C_L       (REG_HDMITX_ATOP_TB_BASE + 0x78)
#define  REG_HDMITX_ATOP_TB_3C_H       (REG_HDMITX_ATOP_TB_BASE + 0x79)
#define  REG_HDMITX_ATOP_TB_3D_L       (REG_HDMITX_ATOP_TB_BASE + 0x7A)
#define  REG_HDMITX_ATOP_TB_3D_H       (REG_HDMITX_ATOP_TB_BASE + 0x7B)
#define  REG_HDMITX_ATOP_TB_3E_L       (REG_HDMITX_ATOP_TB_BASE + 0x7C)
#define  REG_HDMITX_ATOP_TB_3E_H       (REG_HDMITX_ATOP_TB_BASE + 0x7D)
#define  REG_HDMITX_ATOP_TB_3F_L       (REG_HDMITX_ATOP_TB_BASE + 0x7E)
#define  REG_HDMITX_ATOP_TB_3F_H       (REG_HDMITX_ATOP_TB_BASE + 0x7F)
#define  REG_HDMITX_ATOP_TB_40_L       (REG_HDMITX_ATOP_TB_BASE + 0x80)
#define  REG_HDMITX_ATOP_TB_40_H       (REG_HDMITX_ATOP_TB_BASE + 0x81)
#define  REG_HDMITX_ATOP_TB_41_L       (REG_HDMITX_ATOP_TB_BASE + 0x82)
#define  REG_HDMITX_ATOP_TB_41_H       (REG_HDMITX_ATOP_TB_BASE + 0x83)
#define  REG_HDMITX_ATOP_TB_42_L       (REG_HDMITX_ATOP_TB_BASE + 0x84)
#define  REG_HDMITX_ATOP_TB_42_H       (REG_HDMITX_ATOP_TB_BASE + 0x85)
#define  REG_HDMITX_ATOP_TB_43_L       (REG_HDMITX_ATOP_TB_BASE + 0x86)
#define  REG_HDMITX_ATOP_TB_43_H       (REG_HDMITX_ATOP_TB_BASE + 0x87)
#define  REG_HDMITX_ATOP_TB_44_L       (REG_HDMITX_ATOP_TB_BASE + 0x88)
#define  REG_HDMITX_ATOP_TB_44_H       (REG_HDMITX_ATOP_TB_BASE + 0x89)
#define  REG_HDMITX_ATOP_TB_45_L       (REG_HDMITX_ATOP_TB_BASE + 0x8A)
#define  REG_HDMITX_ATOP_TB_45_H       (REG_HDMITX_ATOP_TB_BASE + 0x8B)
#define  REG_HDMITX_ATOP_TB_46_L       (REG_HDMITX_ATOP_TB_BASE + 0x8C)
#define  REG_HDMITX_ATOP_TB_46_H       (REG_HDMITX_ATOP_TB_BASE + 0x8D)
#define  REG_HDMITX_ATOP_TB_47_L       (REG_HDMITX_ATOP_TB_BASE + 0x8E)
#define  REG_HDMITX_ATOP_TB_47_H       (REG_HDMITX_ATOP_TB_BASE + 0x8F)
#define  REG_HDMITX_ATOP_TB_48_L       (REG_HDMITX_ATOP_TB_BASE + 0x90)
#define  REG_HDMITX_ATOP_TB_48_H       (REG_HDMITX_ATOP_TB_BASE + 0x91)
#define  REG_HDMITX_ATOP_TB_49_L       (REG_HDMITX_ATOP_TB_BASE + 0x92)
#define  REG_HDMITX_ATOP_TB_49_H       (REG_HDMITX_ATOP_TB_BASE + 0x93)
#define  REG_HDMITX_ATOP_TB_4A_L       (REG_HDMITX_ATOP_TB_BASE + 0x94)
#define  REG_HDMITX_ATOP_TB_4A_H       (REG_HDMITX_ATOP_TB_BASE + 0x95)
#define  REG_HDMITX_ATOP_TB_4B_L       (REG_HDMITX_ATOP_TB_BASE + 0x96)
#define  REG_HDMITX_ATOP_TB_4B_H       (REG_HDMITX_ATOP_TB_BASE + 0x97)
#define  REG_HDMITX_ATOP_TB_4C_L       (REG_HDMITX_ATOP_TB_BASE + 0x98)
#define  REG_HDMITX_ATOP_TB_4C_H       (REG_HDMITX_ATOP_TB_BASE + 0x99)
#define  REG_HDMITX_ATOP_TB_4D_L       (REG_HDMITX_ATOP_TB_BASE + 0x9A)
#define  REG_HDMITX_ATOP_TB_4D_H       (REG_HDMITX_ATOP_TB_BASE + 0x9B)
#define  REG_HDMITX_ATOP_TB_4E_L       (REG_HDMITX_ATOP_TB_BASE + 0x9C)
#define  REG_HDMITX_ATOP_TB_4E_H       (REG_HDMITX_ATOP_TB_BASE + 0x9D)
#define  REG_HDMITX_ATOP_TB_4F_L       (REG_HDMITX_ATOP_TB_BASE + 0x9E)
#define  REG_HDMITX_ATOP_TB_4F_H       (REG_HDMITX_ATOP_TB_BASE + 0x9F)
#define  REG_HDMITX_ATOP_TB_50_L       (REG_HDMITX_ATOP_TB_BASE + 0xA0)
#define  REG_HDMITX_ATOP_TB_50_H       (REG_HDMITX_ATOP_TB_BASE + 0xA1)
#define  REG_HDMITX_ATOP_TB_51_L       (REG_HDMITX_ATOP_TB_BASE + 0xA2)
#define  REG_HDMITX_ATOP_TB_51_H       (REG_HDMITX_ATOP_TB_BASE + 0xA3)
#define  REG_HDMITX_ATOP_TB_52_L       (REG_HDMITX_ATOP_TB_BASE + 0xA4)
#define  REG_HDMITX_ATOP_TB_52_H       (REG_HDMITX_ATOP_TB_BASE + 0xA5)
#define  REG_HDMITX_ATOP_TB_53_L       (REG_HDMITX_ATOP_TB_BASE + 0xA6)
#define  REG_HDMITX_ATOP_TB_53_H       (REG_HDMITX_ATOP_TB_BASE + 0xA7)
#define  REG_HDMITX_ATOP_TB_54_L       (REG_HDMITX_ATOP_TB_BASE + 0xA8)
#define  REG_HDMITX_ATOP_TB_54_H       (REG_HDMITX_ATOP_TB_BASE + 0xA9)
#define  REG_HDMITX_ATOP_TB_55_L       (REG_HDMITX_ATOP_TB_BASE + 0xAA)
#define  REG_HDMITX_ATOP_TB_55_H       (REG_HDMITX_ATOP_TB_BASE + 0xAB)
#define  REG_HDMITX_ATOP_TB_56_L       (REG_HDMITX_ATOP_TB_BASE + 0xAC)
#define  REG_HDMITX_ATOP_TB_56_H       (REG_HDMITX_ATOP_TB_BASE + 0xAD)
#define  REG_HDMITX_ATOP_TB_57_L       (REG_HDMITX_ATOP_TB_BASE + 0xAE)
#define  REG_HDMITX_ATOP_TB_57_H       (REG_HDMITX_ATOP_TB_BASE + 0xAF)
#define  REG_HDMITX_ATOP_TB_58_L       (REG_HDMITX_ATOP_TB_BASE + 0xB0)
#define  REG_HDMITX_ATOP_TB_58_H       (REG_HDMITX_ATOP_TB_BASE + 0xB1)
#define  REG_HDMITX_ATOP_TB_59_L       (REG_HDMITX_ATOP_TB_BASE + 0xB2)
#define  REG_HDMITX_ATOP_TB_59_H       (REG_HDMITX_ATOP_TB_BASE + 0xB3)
#define  REG_HDMITX_ATOP_TB_5A_L       (REG_HDMITX_ATOP_TB_BASE + 0xB4)
#define  REG_HDMITX_ATOP_TB_5A_H       (REG_HDMITX_ATOP_TB_BASE + 0xB5)
#define  REG_HDMITX_ATOP_TB_5B_L       (REG_HDMITX_ATOP_TB_BASE + 0xB6)
#define  REG_HDMITX_ATOP_TB_5B_H       (REG_HDMITX_ATOP_TB_BASE + 0xB7)
#define  REG_HDMITX_ATOP_TB_5C_L       (REG_HDMITX_ATOP_TB_BASE + 0xB8)
#define  REG_HDMITX_ATOP_TB_5C_H       (REG_HDMITX_ATOP_TB_BASE + 0xB9)
#define  REG_HDMITX_ATOP_TB_5D_L       (REG_HDMITX_ATOP_TB_BASE + 0xBA)
#define  REG_HDMITX_ATOP_TB_5D_H       (REG_HDMITX_ATOP_TB_BASE + 0xBB)
#define  REG_HDMITX_ATOP_TB_5E_L       (REG_HDMITX_ATOP_TB_BASE + 0xBC)
#define  REG_HDMITX_ATOP_TB_5E_H       (REG_HDMITX_ATOP_TB_BASE + 0xBD)
#define  REG_HDMITX_ATOP_TB_5F_L       (REG_HDMITX_ATOP_TB_BASE + 0xBE)
#define  REG_HDMITX_ATOP_TB_5F_H       (REG_HDMITX_ATOP_TB_BASE + 0xBF)
#define  REG_HDMITX_ATOP_TB_60_L       (REG_HDMITX_ATOP_TB_BASE + 0xC0)
#define  REG_HDMITX_ATOP_TB_60_H       (REG_HDMITX_ATOP_TB_BASE + 0xC1)
#define  REG_HDMITX_ATOP_TB_61_L       (REG_HDMITX_ATOP_TB_BASE + 0xC2)
#define  REG_HDMITX_ATOP_TB_61_H       (REG_HDMITX_ATOP_TB_BASE + 0xC3)
#define  REG_HDMITX_ATOP_TB_62_L       (REG_HDMITX_ATOP_TB_BASE + 0xC4)
#define  REG_HDMITX_ATOP_TB_62_H       (REG_HDMITX_ATOP_TB_BASE + 0xC5)
#define  REG_HDMITX_ATOP_TB_63_L       (REG_HDMITX_ATOP_TB_BASE + 0xC6)
#define  REG_HDMITX_ATOP_TB_63_H       (REG_HDMITX_ATOP_TB_BASE + 0xC7)
#define  REG_HDMITX_ATOP_TB_64_L       (REG_HDMITX_ATOP_TB_BASE + 0xC8)
#define  REG_HDMITX_ATOP_TB_64_H       (REG_HDMITX_ATOP_TB_BASE + 0xC9)
#define  REG_HDMITX_ATOP_TB_65_L       (REG_HDMITX_ATOP_TB_BASE + 0xCA)
#define  REG_HDMITX_ATOP_TB_65_H       (REG_HDMITX_ATOP_TB_BASE + 0xCB)
#define  REG_HDMITX_ATOP_TB_66_L       (REG_HDMITX_ATOP_TB_BASE + 0xCC)
#define  REG_HDMITX_ATOP_TB_66_H       (REG_HDMITX_ATOP_TB_BASE + 0xCD)
#define  REG_HDMITX_ATOP_TB_67_L       (REG_HDMITX_ATOP_TB_BASE + 0xCE)
#define  REG_HDMITX_ATOP_TB_67_H       (REG_HDMITX_ATOP_TB_BASE + 0xCF)
#define  REG_HDMITX_ATOP_TB_68_L       (REG_HDMITX_ATOP_TB_BASE + 0xD0)
#define  REG_HDMITX_ATOP_TB_68_H       (REG_HDMITX_ATOP_TB_BASE + 0xD1)
#define  REG_HDMITX_ATOP_TB_69_L       (REG_HDMITX_ATOP_TB_BASE + 0xD2)
#define  REG_HDMITX_ATOP_TB_69_H       (REG_HDMITX_ATOP_TB_BASE + 0xD3)
#define  REG_HDMITX_ATOP_TB_6A_L       (REG_HDMITX_ATOP_TB_BASE + 0xD4)
#define  REG_HDMITX_ATOP_TB_6A_H       (REG_HDMITX_ATOP_TB_BASE + 0xD5)
#define  REG_HDMITX_ATOP_TB_6B_L       (REG_HDMITX_ATOP_TB_BASE + 0xD6)
#define  REG_HDMITX_ATOP_TB_6B_H       (REG_HDMITX_ATOP_TB_BASE + 0xD7)
#define  REG_HDMITX_ATOP_TB_6C_L       (REG_HDMITX_ATOP_TB_BASE + 0xD8)
#define  REG_HDMITX_ATOP_TB_6C_H       (REG_HDMITX_ATOP_TB_BASE + 0xD9)
#define  REG_HDMITX_ATOP_TB_6D_L       (REG_HDMITX_ATOP_TB_BASE + 0xDA)
#define  REG_HDMITX_ATOP_TB_6D_H       (REG_HDMITX_ATOP_TB_BASE + 0xDB)
#define  REG_HDMITX_ATOP_TB_6E_L       (REG_HDMITX_ATOP_TB_BASE + 0xDC)
#define  REG_HDMITX_ATOP_TB_6E_H       (REG_HDMITX_ATOP_TB_BASE + 0xDD)
#define  REG_HDMITX_ATOP_TB_6F_L       (REG_HDMITX_ATOP_TB_BASE + 0xDE)
#define  REG_HDMITX_ATOP_TB_6F_H       (REG_HDMITX_ATOP_TB_BASE + 0xDF)
#define  REG_HDMITX_ATOP_TB_70_L       (REG_HDMITX_ATOP_TB_BASE + 0xE0)
#define  REG_HDMITX_ATOP_TB_70_H       (REG_HDMITX_ATOP_TB_BASE + 0xE1)
#define  REG_HDMITX_ATOP_TB_71_L       (REG_HDMITX_ATOP_TB_BASE + 0xE2)
#define  REG_HDMITX_ATOP_TB_71_H       (REG_HDMITX_ATOP_TB_BASE + 0xE3)
#define  REG_HDMITX_ATOP_TB_72_L       (REG_HDMITX_ATOP_TB_BASE + 0xE4)
#define  REG_HDMITX_ATOP_TB_72_H       (REG_HDMITX_ATOP_TB_BASE + 0xE5)
#define  REG_HDMITX_ATOP_TB_73_L       (REG_HDMITX_ATOP_TB_BASE + 0xE6)
#define  REG_HDMITX_ATOP_TB_73_H       (REG_HDMITX_ATOP_TB_BASE + 0xE7)
#define  REG_HDMITX_ATOP_TB_74_L       (REG_HDMITX_ATOP_TB_BASE + 0xE8)
#define  REG_HDMITX_ATOP_TB_74_H       (REG_HDMITX_ATOP_TB_BASE + 0xE9)
#define  REG_HDMITX_ATOP_TB_75_L       (REG_HDMITX_ATOP_TB_BASE + 0xEA)
#define  REG_HDMITX_ATOP_TB_75_H       (REG_HDMITX_ATOP_TB_BASE + 0xEB)
#define  REG_HDMITX_ATOP_TB_76_L       (REG_HDMITX_ATOP_TB_BASE + 0xEC)
#define  REG_HDMITX_ATOP_TB_76_H       (REG_HDMITX_ATOP_TB_BASE + 0xED)
#define  REG_HDMITX_ATOP_TB_77_L       (REG_HDMITX_ATOP_TB_BASE + 0xEE)
#define  REG_HDMITX_ATOP_TB_77_H       (REG_HDMITX_ATOP_TB_BASE + 0xEF)
#define  REG_HDMITX_ATOP_TB_78_L       (REG_HDMITX_ATOP_TB_BASE + 0xF0)
#define  REG_HDMITX_ATOP_TB_78_H       (REG_HDMITX_ATOP_TB_BASE + 0xF1)
#define  REG_HDMITX_ATOP_TB_79_L       (REG_HDMITX_ATOP_TB_BASE + 0xF2)
#define  REG_HDMITX_ATOP_TB_79_H       (REG_HDMITX_ATOP_TB_BASE + 0xF3)
#define  REG_HDMITX_ATOP_TB_7A_L       (REG_HDMITX_ATOP_TB_BASE + 0xF4)
#define  REG_HDMITX_ATOP_TB_7A_H       (REG_HDMITX_ATOP_TB_BASE + 0xF5)
#define  REG_HDMITX_ATOP_TB_7B_L       (REG_HDMITX_ATOP_TB_BASE + 0xF6)
#define  REG_HDMITX_ATOP_TB_7B_H       (REG_HDMITX_ATOP_TB_BASE + 0xF7)
#define  REG_HDMITX_ATOP_TB_7C_L       (REG_HDMITX_ATOP_TB_BASE + 0xF8)
#define  REG_HDMITX_ATOP_TB_7C_H       (REG_HDMITX_ATOP_TB_BASE + 0xF9)
#define  REG_HDMITX_ATOP_TB_7D_L       (REG_HDMITX_ATOP_TB_BASE + 0xFA)
#define  REG_HDMITX_ATOP_TB_7D_H       (REG_HDMITX_ATOP_TB_BASE + 0xFB)
#define  REG_HDMITX_ATOP_TB_7E_L       (REG_HDMITX_ATOP_TB_BASE + 0xFC)
#define  REG_HDMITX_ATOP_TB_7E_H       (REG_HDMITX_ATOP_TB_BASE + 0xFD)
#define  REG_HDMITX_ATOP_TB_7F_L       (REG_HDMITX_ATOP_TB_BASE + 0xFE)
#define  REG_HDMITX_ATOP_TB_7F_H       (REG_HDMITX_ATOP_TB_BASE + 0xFF)

#define  REG_HDMITX_DTOP_TB_00_L       (REG_HDMITX_DTOP_TB_BASE + 0x00)
#define  REG_HDMITX_DTOP_TB_00_H       (REG_HDMITX_DTOP_TB_BASE + 0x01)
#define  REG_HDMITX_DTOP_TB_01_L       (REG_HDMITX_DTOP_TB_BASE + 0x02)
#define  REG_HDMITX_DTOP_TB_01_H       (REG_HDMITX_DTOP_TB_BASE + 0x03)
#define  REG_HDMITX_DTOP_TB_02_L       (REG_HDMITX_DTOP_TB_BASE + 0x04)
#define  REG_HDMITX_DTOP_TB_02_H       (REG_HDMITX_DTOP_TB_BASE + 0x05)
#define  REG_HDMITX_DTOP_TB_03_L       (REG_HDMITX_DTOP_TB_BASE + 0x06)
#define  REG_HDMITX_DTOP_TB_03_H       (REG_HDMITX_DTOP_TB_BASE + 0x07)
#define  REG_HDMITX_DTOP_TB_04_L       (REG_HDMITX_DTOP_TB_BASE + 0x08)
#define  REG_HDMITX_DTOP_TB_04_H       (REG_HDMITX_DTOP_TB_BASE + 0x09)
#define  REG_HDMITX_DTOP_TB_05_L       (REG_HDMITX_DTOP_TB_BASE + 0x0A)
#define  REG_HDMITX_DTOP_TB_05_H       (REG_HDMITX_DTOP_TB_BASE + 0x0B)
#define  REG_HDMITX_DTOP_TB_06_L       (REG_HDMITX_DTOP_TB_BASE + 0x0C)
#define  REG_HDMITX_DTOP_TB_06_H       (REG_HDMITX_DTOP_TB_BASE + 0x0D)
#define  REG_HDMITX_DTOP_TB_07_L       (REG_HDMITX_DTOP_TB_BASE + 0x0E)
#define  REG_HDMITX_DTOP_TB_07_H       (REG_HDMITX_DTOP_TB_BASE + 0x0F)
#define  REG_HDMITX_DTOP_TB_08_L       (REG_HDMITX_DTOP_TB_BASE + 0x10)
#define  REG_HDMITX_DTOP_TB_08_H       (REG_HDMITX_DTOP_TB_BASE + 0x11)
#define  REG_HDMITX_DTOP_TB_09_L       (REG_HDMITX_DTOP_TB_BASE + 0x12)
#define  REG_HDMITX_DTOP_TB_09_H       (REG_HDMITX_DTOP_TB_BASE + 0x13)
#define  REG_HDMITX_DTOP_TB_0A_L       (REG_HDMITX_DTOP_TB_BASE + 0x14)
#define  REG_HDMITX_DTOP_TB_0A_H       (REG_HDMITX_DTOP_TB_BASE + 0x15)
#define  REG_HDMITX_DTOP_TB_0B_L       (REG_HDMITX_DTOP_TB_BASE + 0x16)
#define  REG_HDMITX_DTOP_TB_0B_H       (REG_HDMITX_DTOP_TB_BASE + 0x17)
#define  REG_HDMITX_DTOP_TB_0C_L       (REG_HDMITX_DTOP_TB_BASE + 0x18)
#define  REG_HDMITX_DTOP_TB_0C_H       (REG_HDMITX_DTOP_TB_BASE + 0x19)
#define  REG_HDMITX_DTOP_TB_0D_L       (REG_HDMITX_DTOP_TB_BASE + 0x1A)
#define  REG_HDMITX_DTOP_TB_0D_H       (REG_HDMITX_DTOP_TB_BASE + 0x1B)
#define  REG_HDMITX_DTOP_TB_0E_L       (REG_HDMITX_DTOP_TB_BASE + 0x1C)
#define  REG_HDMITX_DTOP_TB_0E_H       (REG_HDMITX_DTOP_TB_BASE + 0x1D)
#define  REG_HDMITX_DTOP_TB_0F_L       (REG_HDMITX_DTOP_TB_BASE + 0x1E)
#define  REG_HDMITX_DTOP_TB_0F_H       (REG_HDMITX_DTOP_TB_BASE + 0x1F)
#define  REG_HDMITX_DTOP_TB_10_L       (REG_HDMITX_DTOP_TB_BASE + 0x20)
#define  REG_HDMITX_DTOP_TB_10_H       (REG_HDMITX_DTOP_TB_BASE + 0x21)
#define  REG_HDMITX_DTOP_TB_11_L       (REG_HDMITX_DTOP_TB_BASE + 0x22)
#define  REG_HDMITX_DTOP_TB_11_H       (REG_HDMITX_DTOP_TB_BASE + 0x23)
#define  REG_HDMITX_DTOP_TB_12_L       (REG_HDMITX_DTOP_TB_BASE + 0x24)
#define  REG_HDMITX_DTOP_TB_12_H       (REG_HDMITX_DTOP_TB_BASE + 0x25)
#define  REG_HDMITX_DTOP_TB_13_L       (REG_HDMITX_DTOP_TB_BASE + 0x26)
#define  REG_HDMITX_DTOP_TB_13_H       (REG_HDMITX_DTOP_TB_BASE + 0x27)
#define  REG_HDMITX_DTOP_TB_14_L       (REG_HDMITX_DTOP_TB_BASE + 0x28)
#define  REG_HDMITX_DTOP_TB_14_H       (REG_HDMITX_DTOP_TB_BASE + 0x29)
#define  REG_HDMITX_DTOP_TB_15_L       (REG_HDMITX_DTOP_TB_BASE + 0x2A)
#define  REG_HDMITX_DTOP_TB_15_H       (REG_HDMITX_DTOP_TB_BASE + 0x2B)
#define  REG_HDMITX_DTOP_TB_16_L       (REG_HDMITX_DTOP_TB_BASE + 0x2C)
#define  REG_HDMITX_DTOP_TB_16_H       (REG_HDMITX_DTOP_TB_BASE + 0x2D)
#define  REG_HDMITX_DTOP_TB_17_L       (REG_HDMITX_DTOP_TB_BASE + 0x2E)
#define  REG_HDMITX_DTOP_TB_17_H       (REG_HDMITX_DTOP_TB_BASE + 0x2F)
#define  REG_HDMITX_DTOP_TB_18_L       (REG_HDMITX_DTOP_TB_BASE + 0x30)
#define  REG_HDMITX_DTOP_TB_18_H       (REG_HDMITX_DTOP_TB_BASE + 0x31)
#define  REG_HDMITX_DTOP_TB_19_L       (REG_HDMITX_DTOP_TB_BASE + 0x32)
#define  REG_HDMITX_DTOP_TB_19_H       (REG_HDMITX_DTOP_TB_BASE + 0x33)
#define  REG_HDMITX_DTOP_TB_1A_L       (REG_HDMITX_DTOP_TB_BASE + 0x34)
#define  REG_HDMITX_DTOP_TB_1A_H       (REG_HDMITX_DTOP_TB_BASE + 0x35)
#define  REG_HDMITX_DTOP_TB_1B_L       (REG_HDMITX_DTOP_TB_BASE + 0x36)
#define  REG_HDMITX_DTOP_TB_1B_H       (REG_HDMITX_DTOP_TB_BASE + 0x37)
#define  REG_HDMITX_DTOP_TB_1C_L       (REG_HDMITX_DTOP_TB_BASE + 0x38)
#define  REG_HDMITX_DTOP_TB_1C_H       (REG_HDMITX_DTOP_TB_BASE + 0x39)
#define  REG_HDMITX_DTOP_TB_1D_L       (REG_HDMITX_DTOP_TB_BASE + 0x3A)
#define  REG_HDMITX_DTOP_TB_1D_H       (REG_HDMITX_DTOP_TB_BASE + 0x3B)
#define  REG_HDMITX_DTOP_TB_1E_L       (REG_HDMITX_DTOP_TB_BASE + 0x3C)
#define  REG_HDMITX_DTOP_TB_1E_H       (REG_HDMITX_DTOP_TB_BASE + 0x3D)
#define  REG_HDMITX_DTOP_TB_1F_L       (REG_HDMITX_DTOP_TB_BASE + 0x3E)
#define  REG_HDMITX_DTOP_TB_1F_H       (REG_HDMITX_DTOP_TB_BASE + 0x3F)
#define  REG_HDMITX_DTOP_TB_20_L       (REG_HDMITX_DTOP_TB_BASE + 0x40)
#define  REG_HDMITX_DTOP_TB_20_H       (REG_HDMITX_DTOP_TB_BASE + 0x41)
#define  REG_HDMITX_DTOP_TB_21_L       (REG_HDMITX_DTOP_TB_BASE + 0x42)
#define  REG_HDMITX_DTOP_TB_21_H       (REG_HDMITX_DTOP_TB_BASE + 0x43)
#define  REG_HDMITX_DTOP_TB_22_L       (REG_HDMITX_DTOP_TB_BASE + 0x44)
#define  REG_HDMITX_DTOP_TB_22_H       (REG_HDMITX_DTOP_TB_BASE + 0x45)
#define  REG_HDMITX_DTOP_TB_23_L       (REG_HDMITX_DTOP_TB_BASE + 0x46)
#define  REG_HDMITX_DTOP_TB_23_H       (REG_HDMITX_DTOP_TB_BASE + 0x47)
#define  REG_HDMITX_DTOP_TB_24_L       (REG_HDMITX_DTOP_TB_BASE + 0x48)
#define  REG_HDMITX_DTOP_TB_24_H       (REG_HDMITX_DTOP_TB_BASE + 0x49)
#define  REG_HDMITX_DTOP_TB_25_L       (REG_HDMITX_DTOP_TB_BASE + 0x4A)
#define  REG_HDMITX_DTOP_TB_25_H       (REG_HDMITX_DTOP_TB_BASE + 0x4B)
#define  REG_HDMITX_DTOP_TB_26_L       (REG_HDMITX_DTOP_TB_BASE + 0x4C)
#define  REG_HDMITX_DTOP_TB_26_H       (REG_HDMITX_DTOP_TB_BASE + 0x4D)
#define  REG_HDMITX_DTOP_TB_27_L       (REG_HDMITX_DTOP_TB_BASE + 0x4E)
#define  REG_HDMITX_DTOP_TB_27_H       (REG_HDMITX_DTOP_TB_BASE + 0x4F)
#define  REG_HDMITX_DTOP_TB_28_L       (REG_HDMITX_DTOP_TB_BASE + 0x50)
#define  REG_HDMITX_DTOP_TB_28_H       (REG_HDMITX_DTOP_TB_BASE + 0x51)
#define  REG_HDMITX_DTOP_TB_29_L       (REG_HDMITX_DTOP_TB_BASE + 0x52)
#define  REG_HDMITX_DTOP_TB_29_H       (REG_HDMITX_DTOP_TB_BASE + 0x53)
#define  REG_HDMITX_DTOP_TB_2A_L       (REG_HDMITX_DTOP_TB_BASE + 0x54)
#define  REG_HDMITX_DTOP_TB_2A_H       (REG_HDMITX_DTOP_TB_BASE + 0x55)
#define  REG_HDMITX_DTOP_TB_2B_L       (REG_HDMITX_DTOP_TB_BASE + 0x56)
#define  REG_HDMITX_DTOP_TB_2B_H       (REG_HDMITX_DTOP_TB_BASE + 0x57)
#define  REG_HDMITX_DTOP_TB_2C_L       (REG_HDMITX_DTOP_TB_BASE + 0x58)
#define  REG_HDMITX_DTOP_TB_2C_H       (REG_HDMITX_DTOP_TB_BASE + 0x59)
#define  REG_HDMITX_DTOP_TB_2D_L       (REG_HDMITX_DTOP_TB_BASE + 0x5A)
#define  REG_HDMITX_DTOP_TB_2D_H       (REG_HDMITX_DTOP_TB_BASE + 0x5B)
#define  REG_HDMITX_DTOP_TB_2E_L       (REG_HDMITX_DTOP_TB_BASE + 0x5C)
#define  REG_HDMITX_DTOP_TB_2E_H       (REG_HDMITX_DTOP_TB_BASE + 0x5D)
#define  REG_HDMITX_DTOP_TB_2F_L       (REG_HDMITX_DTOP_TB_BASE + 0x5E)
#define  REG_HDMITX_DTOP_TB_2F_H       (REG_HDMITX_DTOP_TB_BASE + 0x5F)
#define  REG_HDMITX_DTOP_TB_30_L       (REG_HDMITX_DTOP_TB_BASE + 0x60)
#define  REG_HDMITX_DTOP_TB_30_H       (REG_HDMITX_DTOP_TB_BASE + 0x61)
#define  REG_HDMITX_DTOP_TB_31_L       (REG_HDMITX_DTOP_TB_BASE + 0x62)
#define  REG_HDMITX_DTOP_TB_31_H       (REG_HDMITX_DTOP_TB_BASE + 0x63)
#define  REG_HDMITX_DTOP_TB_32_L       (REG_HDMITX_DTOP_TB_BASE + 0x64)
#define  REG_HDMITX_DTOP_TB_32_H       (REG_HDMITX_DTOP_TB_BASE + 0x65)
#define  REG_HDMITX_DTOP_TB_33_L       (REG_HDMITX_DTOP_TB_BASE + 0x66)
#define  REG_HDMITX_DTOP_TB_33_H       (REG_HDMITX_DTOP_TB_BASE + 0x67)
#define  REG_HDMITX_DTOP_TB_34_L       (REG_HDMITX_DTOP_TB_BASE + 0x68)
#define  REG_HDMITX_DTOP_TB_34_H       (REG_HDMITX_DTOP_TB_BASE + 0x69)
#define  REG_HDMITX_DTOP_TB_35_L       (REG_HDMITX_DTOP_TB_BASE + 0x6A)
#define  REG_HDMITX_DTOP_TB_35_H       (REG_HDMITX_DTOP_TB_BASE + 0x6B)
#define  REG_HDMITX_DTOP_TB_36_L       (REG_HDMITX_DTOP_TB_BASE + 0x6C)
#define  REG_HDMITX_DTOP_TB_36_H       (REG_HDMITX_DTOP_TB_BASE + 0x6D)
#define  REG_HDMITX_DTOP_TB_37_L       (REG_HDMITX_DTOP_TB_BASE + 0x6E)
#define  REG_HDMITX_DTOP_TB_37_H       (REG_HDMITX_DTOP_TB_BASE + 0x6F)
#define  REG_HDMITX_DTOP_TB_38_L       (REG_HDMITX_DTOP_TB_BASE + 0x70)
#define  REG_HDMITX_DTOP_TB_38_H       (REG_HDMITX_DTOP_TB_BASE + 0x71)
#define  REG_HDMITX_DTOP_TB_39_L       (REG_HDMITX_DTOP_TB_BASE + 0x72)
#define  REG_HDMITX_DTOP_TB_39_H       (REG_HDMITX_DTOP_TB_BASE + 0x73)
#define  REG_HDMITX_DTOP_TB_3A_L       (REG_HDMITX_DTOP_TB_BASE + 0x74)
#define  REG_HDMITX_DTOP_TB_3A_H       (REG_HDMITX_DTOP_TB_BASE + 0x75)
#define  REG_HDMITX_DTOP_TB_3B_L       (REG_HDMITX_DTOP_TB_BASE + 0x76)
#define  REG_HDMITX_DTOP_TB_3B_H       (REG_HDMITX_DTOP_TB_BASE + 0x77)
#define  REG_HDMITX_DTOP_TB_3C_L       (REG_HDMITX_DTOP_TB_BASE + 0x78)
#define  REG_HDMITX_DTOP_TB_3C_H       (REG_HDMITX_DTOP_TB_BASE + 0x79)
#define  REG_HDMITX_DTOP_TB_3D_L       (REG_HDMITX_DTOP_TB_BASE + 0x7A)
#define  REG_HDMITX_DTOP_TB_3D_H       (REG_HDMITX_DTOP_TB_BASE + 0x7B)
#define  REG_HDMITX_DTOP_TB_3E_L       (REG_HDMITX_DTOP_TB_BASE + 0x7C)
#define  REG_HDMITX_DTOP_TB_3E_H       (REG_HDMITX_DTOP_TB_BASE + 0x7D)
#define  REG_HDMITX_DTOP_TB_3F_L       (REG_HDMITX_DTOP_TB_BASE + 0x7E)
#define  REG_HDMITX_DTOP_TB_3F_H       (REG_HDMITX_DTOP_TB_BASE + 0x7F)
#define  REG_HDMITX_DTOP_TB_40_L       (REG_HDMITX_DTOP_TB_BASE + 0x80)
#define  REG_HDMITX_DTOP_TB_40_H       (REG_HDMITX_DTOP_TB_BASE + 0x81)
#define  REG_HDMITX_DTOP_TB_41_L       (REG_HDMITX_DTOP_TB_BASE + 0x82)
#define  REG_HDMITX_DTOP_TB_41_H       (REG_HDMITX_DTOP_TB_BASE + 0x83)
#define  REG_HDMITX_DTOP_TB_42_L       (REG_HDMITX_DTOP_TB_BASE + 0x84)
#define  REG_HDMITX_DTOP_TB_42_H       (REG_HDMITX_DTOP_TB_BASE + 0x85)
#define  REG_HDMITX_DTOP_TB_43_L       (REG_HDMITX_DTOP_TB_BASE + 0x86)
#define  REG_HDMITX_DTOP_TB_43_H       (REG_HDMITX_DTOP_TB_BASE + 0x87)
#define  REG_HDMITX_DTOP_TB_44_L       (REG_HDMITX_DTOP_TB_BASE + 0x88)
#define  REG_HDMITX_DTOP_TB_44_H       (REG_HDMITX_DTOP_TB_BASE + 0x89)
#define  REG_HDMITX_DTOP_TB_45_L       (REG_HDMITX_DTOP_TB_BASE + 0x8A)
#define  REG_HDMITX_DTOP_TB_45_H       (REG_HDMITX_DTOP_TB_BASE + 0x8B)
#define  REG_HDMITX_DTOP_TB_46_L       (REG_HDMITX_DTOP_TB_BASE + 0x8C)
#define  REG_HDMITX_DTOP_TB_46_H       (REG_HDMITX_DTOP_TB_BASE + 0x8D)
#define  REG_HDMITX_DTOP_TB_47_L       (REG_HDMITX_DTOP_TB_BASE + 0x8E)
#define  REG_HDMITX_DTOP_TB_47_H       (REG_HDMITX_DTOP_TB_BASE + 0x8F)
#define  REG_HDMITX_DTOP_TB_48_L       (REG_HDMITX_DTOP_TB_BASE + 0x90)
#define  REG_HDMITX_DTOP_TB_48_H       (REG_HDMITX_DTOP_TB_BASE + 0x91)
#define  REG_HDMITX_DTOP_TB_49_L       (REG_HDMITX_DTOP_TB_BASE + 0x92)
#define  REG_HDMITX_DTOP_TB_49_H       (REG_HDMITX_DTOP_TB_BASE + 0x93)
#define  REG_HDMITX_DTOP_TB_4A_L       (REG_HDMITX_DTOP_TB_BASE + 0x94)
#define  REG_HDMITX_DTOP_TB_4A_H       (REG_HDMITX_DTOP_TB_BASE + 0x95)
#define  REG_HDMITX_DTOP_TB_4B_L       (REG_HDMITX_DTOP_TB_BASE + 0x96)
#define  REG_HDMITX_DTOP_TB_4B_H       (REG_HDMITX_DTOP_TB_BASE + 0x97)
#define  REG_HDMITX_DTOP_TB_4C_L       (REG_HDMITX_DTOP_TB_BASE + 0x98)
#define  REG_HDMITX_DTOP_TB_4C_H       (REG_HDMITX_DTOP_TB_BASE + 0x99)
#define  REG_HDMITX_DTOP_TB_4D_L       (REG_HDMITX_DTOP_TB_BASE + 0x9A)
#define  REG_HDMITX_DTOP_TB_4D_H       (REG_HDMITX_DTOP_TB_BASE + 0x9B)
#define  REG_HDMITX_DTOP_TB_4E_L       (REG_HDMITX_DTOP_TB_BASE + 0x9C)
#define  REG_HDMITX_DTOP_TB_4E_H       (REG_HDMITX_DTOP_TB_BASE + 0x9D)
#define  REG_HDMITX_DTOP_TB_4F_L       (REG_HDMITX_DTOP_TB_BASE + 0x9E)
#define  REG_HDMITX_DTOP_TB_4F_H       (REG_HDMITX_DTOP_TB_BASE + 0x9F)
#define  REG_HDMITX_DTOP_TB_50_L       (REG_HDMITX_DTOP_TB_BASE + 0xA0)
#define  REG_HDMITX_DTOP_TB_50_H       (REG_HDMITX_DTOP_TB_BASE + 0xA1)
#define  REG_HDMITX_DTOP_TB_51_L       (REG_HDMITX_DTOP_TB_BASE + 0xA2)
#define  REG_HDMITX_DTOP_TB_51_H       (REG_HDMITX_DTOP_TB_BASE + 0xA3)
#define  REG_HDMITX_DTOP_TB_52_L       (REG_HDMITX_DTOP_TB_BASE + 0xA4)
#define  REG_HDMITX_DTOP_TB_52_H       (REG_HDMITX_DTOP_TB_BASE + 0xA5)
#define  REG_HDMITX_DTOP_TB_53_L       (REG_HDMITX_DTOP_TB_BASE + 0xA6)
#define  REG_HDMITX_DTOP_TB_53_H       (REG_HDMITX_DTOP_TB_BASE + 0xA7)
#define  REG_HDMITX_DTOP_TB_54_L       (REG_HDMITX_DTOP_TB_BASE + 0xA8)
#define  REG_HDMITX_DTOP_TB_54_H       (REG_HDMITX_DTOP_TB_BASE + 0xA9)
#define  REG_HDMITX_DTOP_TB_55_L       (REG_HDMITX_DTOP_TB_BASE + 0xAA)
#define  REG_HDMITX_DTOP_TB_55_H       (REG_HDMITX_DTOP_TB_BASE + 0xAB)
#define  REG_HDMITX_DTOP_TB_56_L       (REG_HDMITX_DTOP_TB_BASE + 0xAC)
#define  REG_HDMITX_DTOP_TB_56_H       (REG_HDMITX_DTOP_TB_BASE + 0xAD)
#define  REG_HDMITX_DTOP_TB_57_L       (REG_HDMITX_DTOP_TB_BASE + 0xAE)
#define  REG_HDMITX_DTOP_TB_57_H       (REG_HDMITX_DTOP_TB_BASE + 0xAF)
#define  REG_HDMITX_DTOP_TB_58_L       (REG_HDMITX_DTOP_TB_BASE + 0xB0)
#define  REG_HDMITX_DTOP_TB_58_H       (REG_HDMITX_DTOP_TB_BASE + 0xB1)
#define  REG_HDMITX_DTOP_TB_59_L       (REG_HDMITX_DTOP_TB_BASE + 0xB2)
#define  REG_HDMITX_DTOP_TB_59_H       (REG_HDMITX_DTOP_TB_BASE + 0xB3)
#define  REG_HDMITX_DTOP_TB_5A_L       (REG_HDMITX_DTOP_TB_BASE + 0xB4)
#define  REG_HDMITX_DTOP_TB_5A_H       (REG_HDMITX_DTOP_TB_BASE + 0xB5)
#define  REG_HDMITX_DTOP_TB_5B_L       (REG_HDMITX_DTOP_TB_BASE + 0xB6)
#define  REG_HDMITX_DTOP_TB_5B_H       (REG_HDMITX_DTOP_TB_BASE + 0xB7)
#define  REG_HDMITX_DTOP_TB_5C_L       (REG_HDMITX_DTOP_TB_BASE + 0xB8)
#define  REG_HDMITX_DTOP_TB_5C_H       (REG_HDMITX_DTOP_TB_BASE + 0xB9)
#define  REG_HDMITX_DTOP_TB_5D_L       (REG_HDMITX_DTOP_TB_BASE + 0xBA)
#define  REG_HDMITX_DTOP_TB_5D_H       (REG_HDMITX_DTOP_TB_BASE + 0xBB)
#define  REG_HDMITX_DTOP_TB_5E_L       (REG_HDMITX_DTOP_TB_BASE + 0xBC)
#define  REG_HDMITX_DTOP_TB_5E_H       (REG_HDMITX_DTOP_TB_BASE + 0xBD)
#define  REG_HDMITX_DTOP_TB_5F_L       (REG_HDMITX_DTOP_TB_BASE + 0xBE)
#define  REG_HDMITX_DTOP_TB_5F_H       (REG_HDMITX_DTOP_TB_BASE + 0xBF)
#define  REG_HDMITX_DTOP_TB_60_L       (REG_HDMITX_DTOP_TB_BASE + 0xC0)
#define  REG_HDMITX_DTOP_TB_60_H       (REG_HDMITX_DTOP_TB_BASE + 0xC1)
#define  REG_HDMITX_DTOP_TB_61_L       (REG_HDMITX_DTOP_TB_BASE + 0xC2)
#define  REG_HDMITX_DTOP_TB_61_H       (REG_HDMITX_DTOP_TB_BASE + 0xC3)
#define  REG_HDMITX_DTOP_TB_62_L       (REG_HDMITX_DTOP_TB_BASE + 0xC4)
#define  REG_HDMITX_DTOP_TB_62_H       (REG_HDMITX_DTOP_TB_BASE + 0xC5)
#define  REG_HDMITX_DTOP_TB_63_L       (REG_HDMITX_DTOP_TB_BASE + 0xC6)
#define  REG_HDMITX_DTOP_TB_63_H       (REG_HDMITX_DTOP_TB_BASE + 0xC7)
#define  REG_HDMITX_DTOP_TB_64_L       (REG_HDMITX_DTOP_TB_BASE + 0xC8)
#define  REG_HDMITX_DTOP_TB_64_H       (REG_HDMITX_DTOP_TB_BASE + 0xC9)
#define  REG_HDMITX_DTOP_TB_65_L       (REG_HDMITX_DTOP_TB_BASE + 0xCA)
#define  REG_HDMITX_DTOP_TB_65_H       (REG_HDMITX_DTOP_TB_BASE + 0xCB)
#define  REG_HDMITX_DTOP_TB_66_L       (REG_HDMITX_DTOP_TB_BASE + 0xCC)
#define  REG_HDMITX_DTOP_TB_66_H       (REG_HDMITX_DTOP_TB_BASE + 0xCD)
#define  REG_HDMITX_DTOP_TB_67_L       (REG_HDMITX_DTOP_TB_BASE + 0xCE)
#define  REG_HDMITX_DTOP_TB_67_H       (REG_HDMITX_DTOP_TB_BASE + 0xCF)
#define  REG_HDMITX_DTOP_TB_68_L       (REG_HDMITX_DTOP_TB_BASE + 0xD0)
#define  REG_HDMITX_DTOP_TB_68_H       (REG_HDMITX_DTOP_TB_BASE + 0xD1)
#define  REG_HDMITX_DTOP_TB_69_L       (REG_HDMITX_DTOP_TB_BASE + 0xD2)
#define  REG_HDMITX_DTOP_TB_69_H       (REG_HDMITX_DTOP_TB_BASE + 0xD3)
#define  REG_HDMITX_DTOP_TB_6A_L       (REG_HDMITX_DTOP_TB_BASE + 0xD4)
#define  REG_HDMITX_DTOP_TB_6A_H       (REG_HDMITX_DTOP_TB_BASE + 0xD5)
#define  REG_HDMITX_DTOP_TB_6B_L       (REG_HDMITX_DTOP_TB_BASE + 0xD6)
#define  REG_HDMITX_DTOP_TB_6B_H       (REG_HDMITX_DTOP_TB_BASE + 0xD7)
#define  REG_HDMITX_DTOP_TB_6C_L       (REG_HDMITX_DTOP_TB_BASE + 0xD8)
#define  REG_HDMITX_DTOP_TB_6C_H       (REG_HDMITX_DTOP_TB_BASE + 0xD9)
#define  REG_HDMITX_DTOP_TB_6D_L       (REG_HDMITX_DTOP_TB_BASE + 0xDA)
#define  REG_HDMITX_DTOP_TB_6D_H       (REG_HDMITX_DTOP_TB_BASE + 0xDB)
#define  REG_HDMITX_DTOP_TB_6E_L       (REG_HDMITX_DTOP_TB_BASE + 0xDC)
#define  REG_HDMITX_DTOP_TB_6E_H       (REG_HDMITX_DTOP_TB_BASE + 0xDD)
#define  REG_HDMITX_DTOP_TB_6F_L       (REG_HDMITX_DTOP_TB_BASE + 0xDE)
#define  REG_HDMITX_DTOP_TB_6F_H       (REG_HDMITX_DTOP_TB_BASE + 0xDF)
#define  REG_HDMITX_DTOP_TB_70_L       (REG_HDMITX_DTOP_TB_BASE + 0xE0)
#define  REG_HDMITX_DTOP_TB_70_H       (REG_HDMITX_DTOP_TB_BASE + 0xE1)
#define  REG_HDMITX_DTOP_TB_71_L       (REG_HDMITX_DTOP_TB_BASE + 0xE2)
#define  REG_HDMITX_DTOP_TB_71_H       (REG_HDMITX_DTOP_TB_BASE + 0xE3)
#define  REG_HDMITX_DTOP_TB_72_L       (REG_HDMITX_DTOP_TB_BASE + 0xE4)
#define  REG_HDMITX_DTOP_TB_72_H       (REG_HDMITX_DTOP_TB_BASE + 0xE5)
#define  REG_HDMITX_DTOP_TB_73_L       (REG_HDMITX_DTOP_TB_BASE + 0xE6)
#define  REG_HDMITX_DTOP_TB_73_H       (REG_HDMITX_DTOP_TB_BASE + 0xE7)
#define  REG_HDMITX_DTOP_TB_74_L       (REG_HDMITX_DTOP_TB_BASE + 0xE8)
#define  REG_HDMITX_DTOP_TB_74_H       (REG_HDMITX_DTOP_TB_BASE + 0xE9)
#define  REG_HDMITX_DTOP_TB_75_L       (REG_HDMITX_DTOP_TB_BASE + 0xEA)
#define  REG_HDMITX_DTOP_TB_75_H       (REG_HDMITX_DTOP_TB_BASE + 0xEB)
#define  REG_HDMITX_DTOP_TB_76_L       (REG_HDMITX_DTOP_TB_BASE + 0xEC)
#define  REG_HDMITX_DTOP_TB_76_H       (REG_HDMITX_DTOP_TB_BASE + 0xED)
#define  REG_HDMITX_DTOP_TB_77_L       (REG_HDMITX_DTOP_TB_BASE + 0xEE)
#define  REG_HDMITX_DTOP_TB_77_H       (REG_HDMITX_DTOP_TB_BASE + 0xEF)
#define  REG_HDMITX_DTOP_TB_78_L       (REG_HDMITX_DTOP_TB_BASE + 0xF0)
#define  REG_HDMITX_DTOP_TB_78_H       (REG_HDMITX_DTOP_TB_BASE + 0xF1)
#define  REG_HDMITX_DTOP_TB_79_L       (REG_HDMITX_DTOP_TB_BASE + 0xF2)
#define  REG_HDMITX_DTOP_TB_79_H       (REG_HDMITX_DTOP_TB_BASE + 0xF3)
#define  REG_HDMITX_DTOP_TB_7A_L       (REG_HDMITX_DTOP_TB_BASE + 0xF4)
#define  REG_HDMITX_DTOP_TB_7A_H       (REG_HDMITX_DTOP_TB_BASE + 0xF5)
#define  REG_HDMITX_DTOP_TB_7B_L       (REG_HDMITX_DTOP_TB_BASE + 0xF6)
#define  REG_HDMITX_DTOP_TB_7B_H       (REG_HDMITX_DTOP_TB_BASE + 0xF7)
#define  REG_HDMITX_DTOP_TB_7C_L       (REG_HDMITX_DTOP_TB_BASE + 0xF8)
#define  REG_HDMITX_DTOP_TB_7C_H       (REG_HDMITX_DTOP_TB_BASE + 0xF9)
#define  REG_HDMITX_DTOP_TB_7D_L       (REG_HDMITX_DTOP_TB_BASE + 0xFA)
#define  REG_HDMITX_DTOP_TB_7D_H       (REG_HDMITX_DTOP_TB_BASE + 0xFB)
#define  REG_HDMITX_DTOP_TB_7E_L       (REG_HDMITX_DTOP_TB_BASE + 0xFC)
#define  REG_HDMITX_DTOP_TB_7E_H       (REG_HDMITX_DTOP_TB_BASE + 0xFD)
#define  REG_HDMITX_DTOP_TB_7F_L       (REG_HDMITX_DTOP_TB_BASE + 0xFE)
#define  REG_HDMITX_DTOP_TB_7F_H       (REG_HDMITX_DTOP_TB_BASE + 0xFF)

#define  REG_DAC_ATOP_TB_00_L       (REG_DAC_ATOP_TB_BASE + 0x00)
#define  REG_DAC_ATOP_TB_00_H       (REG_DAC_ATOP_TB_BASE + 0x01)
#define  REG_DAC_ATOP_TB_01_L       (REG_DAC_ATOP_TB_BASE + 0x02)
#define  REG_DAC_ATOP_TB_01_H       (REG_DAC_ATOP_TB_BASE + 0x03)
#define  REG_DAC_ATOP_TB_02_L       (REG_DAC_ATOP_TB_BASE + 0x04)
#define  REG_DAC_ATOP_TB_02_H       (REG_DAC_ATOP_TB_BASE + 0x05)
#define  REG_DAC_ATOP_TB_03_L       (REG_DAC_ATOP_TB_BASE + 0x06)
#define  REG_DAC_ATOP_TB_03_H       (REG_DAC_ATOP_TB_BASE + 0x07)
#define  REG_DAC_ATOP_TB_04_L       (REG_DAC_ATOP_TB_BASE + 0x08)
#define  REG_DAC_ATOP_TB_04_H       (REG_DAC_ATOP_TB_BASE + 0x09)
#define  REG_DAC_ATOP_TB_05_L       (REG_DAC_ATOP_TB_BASE + 0x0A)
#define  REG_DAC_ATOP_TB_05_H       (REG_DAC_ATOP_TB_BASE + 0x0B)
#define  REG_DAC_ATOP_TB_06_L       (REG_DAC_ATOP_TB_BASE + 0x0C)
#define  REG_DAC_ATOP_TB_06_H       (REG_DAC_ATOP_TB_BASE + 0x0D)
#define  REG_DAC_ATOP_TB_07_L       (REG_DAC_ATOP_TB_BASE + 0x0E)
#define  REG_DAC_ATOP_TB_07_H       (REG_DAC_ATOP_TB_BASE + 0x0F)
#define  REG_DAC_ATOP_TB_08_L       (REG_DAC_ATOP_TB_BASE + 0x10)
#define  REG_DAC_ATOP_TB_08_H       (REG_DAC_ATOP_TB_BASE + 0x11)
#define  REG_DAC_ATOP_TB_09_L       (REG_DAC_ATOP_TB_BASE + 0x12)
#define  REG_DAC_ATOP_TB_09_H       (REG_DAC_ATOP_TB_BASE + 0x13)
#define  REG_DAC_ATOP_TB_0A_L       (REG_DAC_ATOP_TB_BASE + 0x14)
#define  REG_DAC_ATOP_TB_0A_H       (REG_DAC_ATOP_TB_BASE + 0x15)
#define  REG_DAC_ATOP_TB_0B_L       (REG_DAC_ATOP_TB_BASE + 0x16)
#define  REG_DAC_ATOP_TB_0B_H       (REG_DAC_ATOP_TB_BASE + 0x17)
#define  REG_DAC_ATOP_TB_0C_L       (REG_DAC_ATOP_TB_BASE + 0x18)
#define  REG_DAC_ATOP_TB_0C_H       (REG_DAC_ATOP_TB_BASE + 0x19)
#define  REG_DAC_ATOP_TB_0D_L       (REG_DAC_ATOP_TB_BASE + 0x1A)
#define  REG_DAC_ATOP_TB_0D_H       (REG_DAC_ATOP_TB_BASE + 0x1B)
#define  REG_DAC_ATOP_TB_0E_L       (REG_DAC_ATOP_TB_BASE + 0x1C)
#define  REG_DAC_ATOP_TB_0E_H       (REG_DAC_ATOP_TB_BASE + 0x1D)
#define  REG_DAC_ATOP_TB_0F_L       (REG_DAC_ATOP_TB_BASE + 0x1E)
#define  REG_DAC_ATOP_TB_0F_H       (REG_DAC_ATOP_TB_BASE + 0x1F)
#define  REG_DAC_ATOP_TB_10_L       (REG_DAC_ATOP_TB_BASE + 0x20)
#define  REG_DAC_ATOP_TB_10_H       (REG_DAC_ATOP_TB_BASE + 0x21)
#define  REG_DAC_ATOP_TB_11_L       (REG_DAC_ATOP_TB_BASE + 0x22)
#define  REG_DAC_ATOP_TB_11_H       (REG_DAC_ATOP_TB_BASE + 0x23)
#define  REG_DAC_ATOP_TB_12_L       (REG_DAC_ATOP_TB_BASE + 0x24)
#define  REG_DAC_ATOP_TB_12_H       (REG_DAC_ATOP_TB_BASE + 0x25)
#define  REG_DAC_ATOP_TB_13_L       (REG_DAC_ATOP_TB_BASE + 0x26)
#define  REG_DAC_ATOP_TB_13_H       (REG_DAC_ATOP_TB_BASE + 0x27)
#define  REG_DAC_ATOP_TB_14_L       (REG_DAC_ATOP_TB_BASE + 0x28)
#define  REG_DAC_ATOP_TB_14_H       (REG_DAC_ATOP_TB_BASE + 0x29)
#define  REG_DAC_ATOP_TB_15_L       (REG_DAC_ATOP_TB_BASE + 0x2A)
#define  REG_DAC_ATOP_TB_15_H       (REG_DAC_ATOP_TB_BASE + 0x2B)
#define  REG_DAC_ATOP_TB_16_L       (REG_DAC_ATOP_TB_BASE + 0x2C)
#define  REG_DAC_ATOP_TB_16_H       (REG_DAC_ATOP_TB_BASE + 0x2D)
#define  REG_DAC_ATOP_TB_17_L       (REG_DAC_ATOP_TB_BASE + 0x2E)
#define  REG_DAC_ATOP_TB_17_H       (REG_DAC_ATOP_TB_BASE + 0x2F)
#define  REG_DAC_ATOP_TB_18_L       (REG_DAC_ATOP_TB_BASE + 0x30)
#define  REG_DAC_ATOP_TB_18_H       (REG_DAC_ATOP_TB_BASE + 0x31)
#define  REG_DAC_ATOP_TB_19_L       (REG_DAC_ATOP_TB_BASE + 0x32)
#define  REG_DAC_ATOP_TB_19_H       (REG_DAC_ATOP_TB_BASE + 0x33)
#define  REG_DAC_ATOP_TB_1A_L       (REG_DAC_ATOP_TB_BASE + 0x34)
#define  REG_DAC_ATOP_TB_1A_H       (REG_DAC_ATOP_TB_BASE + 0x35)
#define  REG_DAC_ATOP_TB_1B_L       (REG_DAC_ATOP_TB_BASE + 0x36)
#define  REG_DAC_ATOP_TB_1B_H       (REG_DAC_ATOP_TB_BASE + 0x37)
#define  REG_DAC_ATOP_TB_1C_L       (REG_DAC_ATOP_TB_BASE + 0x38)
#define  REG_DAC_ATOP_TB_1C_H       (REG_DAC_ATOP_TB_BASE + 0x39)
#define  REG_DAC_ATOP_TB_1D_L       (REG_DAC_ATOP_TB_BASE + 0x3A)
#define  REG_DAC_ATOP_TB_1D_H       (REG_DAC_ATOP_TB_BASE + 0x3B)
#define  REG_DAC_ATOP_TB_1E_L       (REG_DAC_ATOP_TB_BASE + 0x3C)
#define  REG_DAC_ATOP_TB_1E_H       (REG_DAC_ATOP_TB_BASE + 0x3D)
#define  REG_DAC_ATOP_TB_1F_L       (REG_DAC_ATOP_TB_BASE + 0x3E)
#define  REG_DAC_ATOP_TB_1F_H       (REG_DAC_ATOP_TB_BASE + 0x3F)
#define  REG_DAC_ATOP_TB_20_L       (REG_DAC_ATOP_TB_BASE + 0x40)
#define  REG_DAC_ATOP_TB_20_H       (REG_DAC_ATOP_TB_BASE + 0x41)
#define  REG_DAC_ATOP_TB_21_L       (REG_DAC_ATOP_TB_BASE + 0x42)
#define  REG_DAC_ATOP_TB_21_H       (REG_DAC_ATOP_TB_BASE + 0x43)
#define  REG_DAC_ATOP_TB_22_L       (REG_DAC_ATOP_TB_BASE + 0x44)
#define  REG_DAC_ATOP_TB_22_H       (REG_DAC_ATOP_TB_BASE + 0x45)
#define  REG_DAC_ATOP_TB_23_L       (REG_DAC_ATOP_TB_BASE + 0x46)
#define  REG_DAC_ATOP_TB_23_H       (REG_DAC_ATOP_TB_BASE + 0x47)
#define  REG_DAC_ATOP_TB_24_L       (REG_DAC_ATOP_TB_BASE + 0x48)
#define  REG_DAC_ATOP_TB_24_H       (REG_DAC_ATOP_TB_BASE + 0x49)
#define  REG_DAC_ATOP_TB_25_L       (REG_DAC_ATOP_TB_BASE + 0x4A)
#define  REG_DAC_ATOP_TB_25_H       (REG_DAC_ATOP_TB_BASE + 0x4B)
#define  REG_DAC_ATOP_TB_26_L       (REG_DAC_ATOP_TB_BASE + 0x4C)
#define  REG_DAC_ATOP_TB_26_H       (REG_DAC_ATOP_TB_BASE + 0x4D)
#define  REG_DAC_ATOP_TB_27_L       (REG_DAC_ATOP_TB_BASE + 0x4E)
#define  REG_DAC_ATOP_TB_27_H       (REG_DAC_ATOP_TB_BASE + 0x4F)
#define  REG_DAC_ATOP_TB_28_L       (REG_DAC_ATOP_TB_BASE + 0x50)
#define  REG_DAC_ATOP_TB_28_H       (REG_DAC_ATOP_TB_BASE + 0x51)
#define  REG_DAC_ATOP_TB_29_L       (REG_DAC_ATOP_TB_BASE + 0x52)
#define  REG_DAC_ATOP_TB_29_H       (REG_DAC_ATOP_TB_BASE + 0x53)
#define  REG_DAC_ATOP_TB_2A_L       (REG_DAC_ATOP_TB_BASE + 0x54)
#define  REG_DAC_ATOP_TB_2A_H       (REG_DAC_ATOP_TB_BASE + 0x55)
#define  REG_DAC_ATOP_TB_2B_L       (REG_DAC_ATOP_TB_BASE + 0x56)
#define  REG_DAC_ATOP_TB_2B_H       (REG_DAC_ATOP_TB_BASE + 0x57)
#define  REG_DAC_ATOP_TB_2C_L       (REG_DAC_ATOP_TB_BASE + 0x58)
#define  REG_DAC_ATOP_TB_2C_H       (REG_DAC_ATOP_TB_BASE + 0x59)
#define  REG_DAC_ATOP_TB_2D_L       (REG_DAC_ATOP_TB_BASE + 0x5A)
#define  REG_DAC_ATOP_TB_2D_H       (REG_DAC_ATOP_TB_BASE + 0x5B)
#define  REG_DAC_ATOP_TB_2E_L       (REG_DAC_ATOP_TB_BASE + 0x5C)
#define  REG_DAC_ATOP_TB_2E_H       (REG_DAC_ATOP_TB_BASE + 0x5D)
#define  REG_DAC_ATOP_TB_2F_L       (REG_DAC_ATOP_TB_BASE + 0x5E)
#define  REG_DAC_ATOP_TB_2F_H       (REG_DAC_ATOP_TB_BASE + 0x5F)
#define  REG_DAC_ATOP_TB_30_L       (REG_DAC_ATOP_TB_BASE + 0x60)
#define  REG_DAC_ATOP_TB_30_H       (REG_DAC_ATOP_TB_BASE + 0x61)
#define  REG_DAC_ATOP_TB_31_L       (REG_DAC_ATOP_TB_BASE + 0x62)
#define  REG_DAC_ATOP_TB_31_H       (REG_DAC_ATOP_TB_BASE + 0x63)
#define  REG_DAC_ATOP_TB_32_L       (REG_DAC_ATOP_TB_BASE + 0x64)
#define  REG_DAC_ATOP_TB_32_H       (REG_DAC_ATOP_TB_BASE + 0x65)
#define  REG_DAC_ATOP_TB_33_L       (REG_DAC_ATOP_TB_BASE + 0x66)
#define  REG_DAC_ATOP_TB_33_H       (REG_DAC_ATOP_TB_BASE + 0x67)
#define  REG_DAC_ATOP_TB_34_L       (REG_DAC_ATOP_TB_BASE + 0x68)
#define  REG_DAC_ATOP_TB_34_H       (REG_DAC_ATOP_TB_BASE + 0x69)
#define  REG_DAC_ATOP_TB_35_L       (REG_DAC_ATOP_TB_BASE + 0x6A)
#define  REG_DAC_ATOP_TB_35_H       (REG_DAC_ATOP_TB_BASE + 0x6B)
#define  REG_DAC_ATOP_TB_36_L       (REG_DAC_ATOP_TB_BASE + 0x6C)
#define  REG_DAC_ATOP_TB_36_H       (REG_DAC_ATOP_TB_BASE + 0x6D)
#define  REG_DAC_ATOP_TB_37_L       (REG_DAC_ATOP_TB_BASE + 0x6E)
#define  REG_DAC_ATOP_TB_37_H       (REG_DAC_ATOP_TB_BASE + 0x6F)
#define  REG_DAC_ATOP_TB_38_L       (REG_DAC_ATOP_TB_BASE + 0x70)
#define  REG_DAC_ATOP_TB_38_H       (REG_DAC_ATOP_TB_BASE + 0x71)
#define  REG_DAC_ATOP_TB_39_L       (REG_DAC_ATOP_TB_BASE + 0x72)
#define  REG_DAC_ATOP_TB_39_H       (REG_DAC_ATOP_TB_BASE + 0x73)
#define  REG_DAC_ATOP_TB_3A_L       (REG_DAC_ATOP_TB_BASE + 0x74)
#define  REG_DAC_ATOP_TB_3A_H       (REG_DAC_ATOP_TB_BASE + 0x75)
#define  REG_DAC_ATOP_TB_3B_L       (REG_DAC_ATOP_TB_BASE + 0x76)
#define  REG_DAC_ATOP_TB_3B_H       (REG_DAC_ATOP_TB_BASE + 0x77)
#define  REG_DAC_ATOP_TB_3C_L       (REG_DAC_ATOP_TB_BASE + 0x78)
#define  REG_DAC_ATOP_TB_3C_H       (REG_DAC_ATOP_TB_BASE + 0x79)
#define  REG_DAC_ATOP_TB_3D_L       (REG_DAC_ATOP_TB_BASE + 0x7A)
#define  REG_DAC_ATOP_TB_3D_H       (REG_DAC_ATOP_TB_BASE + 0x7B)
#define  REG_DAC_ATOP_TB_3E_L       (REG_DAC_ATOP_TB_BASE + 0x7C)
#define  REG_DAC_ATOP_TB_3E_H       (REG_DAC_ATOP_TB_BASE + 0x7D)
#define  REG_DAC_ATOP_TB_3F_L       (REG_DAC_ATOP_TB_BASE + 0x7E)
#define  REG_DAC_ATOP_TB_3F_H       (REG_DAC_ATOP_TB_BASE + 0x7F)
#define  REG_DAC_ATOP_TB_40_L       (REG_DAC_ATOP_TB_BASE + 0x80)
#define  REG_DAC_ATOP_TB_40_H       (REG_DAC_ATOP_TB_BASE + 0x81)
#define  REG_DAC_ATOP_TB_41_L       (REG_DAC_ATOP_TB_BASE + 0x82)
#define  REG_DAC_ATOP_TB_41_H       (REG_DAC_ATOP_TB_BASE + 0x83)
#define  REG_DAC_ATOP_TB_42_L       (REG_DAC_ATOP_TB_BASE + 0x84)
#define  REG_DAC_ATOP_TB_42_H       (REG_DAC_ATOP_TB_BASE + 0x85)
#define  REG_DAC_ATOP_TB_43_L       (REG_DAC_ATOP_TB_BASE + 0x86)
#define  REG_DAC_ATOP_TB_43_H       (REG_DAC_ATOP_TB_BASE + 0x87)
#define  REG_DAC_ATOP_TB_44_L       (REG_DAC_ATOP_TB_BASE + 0x88)
#define  REG_DAC_ATOP_TB_44_H       (REG_DAC_ATOP_TB_BASE + 0x89)
#define  REG_DAC_ATOP_TB_45_L       (REG_DAC_ATOP_TB_BASE + 0x8A)
#define  REG_DAC_ATOP_TB_45_H       (REG_DAC_ATOP_TB_BASE + 0x8B)
#define  REG_DAC_ATOP_TB_46_L       (REG_DAC_ATOP_TB_BASE + 0x8C)
#define  REG_DAC_ATOP_TB_46_H       (REG_DAC_ATOP_TB_BASE + 0x8D)
#define  REG_DAC_ATOP_TB_47_L       (REG_DAC_ATOP_TB_BASE + 0x8E)
#define  REG_DAC_ATOP_TB_47_H       (REG_DAC_ATOP_TB_BASE + 0x8F)
#define  REG_DAC_ATOP_TB_48_L       (REG_DAC_ATOP_TB_BASE + 0x90)
#define  REG_DAC_ATOP_TB_48_H       (REG_DAC_ATOP_TB_BASE + 0x91)
#define  REG_DAC_ATOP_TB_49_L       (REG_DAC_ATOP_TB_BASE + 0x92)
#define  REG_DAC_ATOP_TB_49_H       (REG_DAC_ATOP_TB_BASE + 0x93)
#define  REG_DAC_ATOP_TB_4A_L       (REG_DAC_ATOP_TB_BASE + 0x94)
#define  REG_DAC_ATOP_TB_4A_H       (REG_DAC_ATOP_TB_BASE + 0x95)
#define  REG_DAC_ATOP_TB_4B_L       (REG_DAC_ATOP_TB_BASE + 0x96)
#define  REG_DAC_ATOP_TB_4B_H       (REG_DAC_ATOP_TB_BASE + 0x97)
#define  REG_DAC_ATOP_TB_4C_L       (REG_DAC_ATOP_TB_BASE + 0x98)
#define  REG_DAC_ATOP_TB_4C_H       (REG_DAC_ATOP_TB_BASE + 0x99)
#define  REG_DAC_ATOP_TB_4D_L       (REG_DAC_ATOP_TB_BASE + 0x9A)
#define  REG_DAC_ATOP_TB_4D_H       (REG_DAC_ATOP_TB_BASE + 0x9B)
#define  REG_DAC_ATOP_TB_4E_L       (REG_DAC_ATOP_TB_BASE + 0x9C)
#define  REG_DAC_ATOP_TB_4E_H       (REG_DAC_ATOP_TB_BASE + 0x9D)
#define  REG_DAC_ATOP_TB_4F_L       (REG_DAC_ATOP_TB_BASE + 0x9E)
#define  REG_DAC_ATOP_TB_4F_H       (REG_DAC_ATOP_TB_BASE + 0x9F)
#define  REG_DAC_ATOP_TB_50_L       (REG_DAC_ATOP_TB_BASE + 0xA0)
#define  REG_DAC_ATOP_TB_50_H       (REG_DAC_ATOP_TB_BASE + 0xA1)
#define  REG_DAC_ATOP_TB_51_L       (REG_DAC_ATOP_TB_BASE + 0xA2)
#define  REG_DAC_ATOP_TB_51_H       (REG_DAC_ATOP_TB_BASE + 0xA3)
#define  REG_DAC_ATOP_TB_52_L       (REG_DAC_ATOP_TB_BASE + 0xA4)
#define  REG_DAC_ATOP_TB_52_H       (REG_DAC_ATOP_TB_BASE + 0xA5)
#define  REG_DAC_ATOP_TB_53_L       (REG_DAC_ATOP_TB_BASE + 0xA6)
#define  REG_DAC_ATOP_TB_53_H       (REG_DAC_ATOP_TB_BASE + 0xA7)
#define  REG_DAC_ATOP_TB_54_L       (REG_DAC_ATOP_TB_BASE + 0xA8)
#define  REG_DAC_ATOP_TB_54_H       (REG_DAC_ATOP_TB_BASE + 0xA9)
#define  REG_DAC_ATOP_TB_55_L       (REG_DAC_ATOP_TB_BASE + 0xAA)
#define  REG_DAC_ATOP_TB_55_H       (REG_DAC_ATOP_TB_BASE + 0xAB)
#define  REG_DAC_ATOP_TB_56_L       (REG_DAC_ATOP_TB_BASE + 0xAC)
#define  REG_DAC_ATOP_TB_56_H       (REG_DAC_ATOP_TB_BASE + 0xAD)
#define  REG_DAC_ATOP_TB_57_L       (REG_DAC_ATOP_TB_BASE + 0xAE)
#define  REG_DAC_ATOP_TB_57_H       (REG_DAC_ATOP_TB_BASE + 0xAF)
#define  REG_DAC_ATOP_TB_58_L       (REG_DAC_ATOP_TB_BASE + 0xB0)
#define  REG_DAC_ATOP_TB_58_H       (REG_DAC_ATOP_TB_BASE + 0xB1)
#define  REG_DAC_ATOP_TB_59_L       (REG_DAC_ATOP_TB_BASE + 0xB2)
#define  REG_DAC_ATOP_TB_59_H       (REG_DAC_ATOP_TB_BASE + 0xB3)
#define  REG_DAC_ATOP_TB_5A_L       (REG_DAC_ATOP_TB_BASE + 0xB4)
#define  REG_DAC_ATOP_TB_5A_H       (REG_DAC_ATOP_TB_BASE + 0xB5)
#define  REG_DAC_ATOP_TB_5B_L       (REG_DAC_ATOP_TB_BASE + 0xB6)
#define  REG_DAC_ATOP_TB_5B_H       (REG_DAC_ATOP_TB_BASE + 0xB7)
#define  REG_DAC_ATOP_TB_5C_L       (REG_DAC_ATOP_TB_BASE + 0xB8)
#define  REG_DAC_ATOP_TB_5C_H       (REG_DAC_ATOP_TB_BASE + 0xB9)
#define  REG_DAC_ATOP_TB_5D_L       (REG_DAC_ATOP_TB_BASE + 0xBA)
#define  REG_DAC_ATOP_TB_5D_H       (REG_DAC_ATOP_TB_BASE + 0xBB)
#define  REG_DAC_ATOP_TB_5E_L       (REG_DAC_ATOP_TB_BASE + 0xBC)
#define  REG_DAC_ATOP_TB_5E_H       (REG_DAC_ATOP_TB_BASE + 0xBD)
#define  REG_DAC_ATOP_TB_5F_L       (REG_DAC_ATOP_TB_BASE + 0xBE)
#define  REG_DAC_ATOP_TB_5F_H       (REG_DAC_ATOP_TB_BASE + 0xBF)
#define  REG_DAC_ATOP_TB_60_L       (REG_DAC_ATOP_TB_BASE + 0xC0)
#define  REG_DAC_ATOP_TB_60_H       (REG_DAC_ATOP_TB_BASE + 0xC1)
#define  REG_DAC_ATOP_TB_61_L       (REG_DAC_ATOP_TB_BASE + 0xC2)
#define  REG_DAC_ATOP_TB_61_H       (REG_DAC_ATOP_TB_BASE + 0xC3)
#define  REG_DAC_ATOP_TB_62_L       (REG_DAC_ATOP_TB_BASE + 0xC4)
#define  REG_DAC_ATOP_TB_62_H       (REG_DAC_ATOP_TB_BASE + 0xC5)
#define  REG_DAC_ATOP_TB_63_L       (REG_DAC_ATOP_TB_BASE + 0xC6)
#define  REG_DAC_ATOP_TB_63_H       (REG_DAC_ATOP_TB_BASE + 0xC7)
#define  REG_DAC_ATOP_TB_64_L       (REG_DAC_ATOP_TB_BASE + 0xC8)
#define  REG_DAC_ATOP_TB_64_H       (REG_DAC_ATOP_TB_BASE + 0xC9)
#define  REG_DAC_ATOP_TB_65_L       (REG_DAC_ATOP_TB_BASE + 0xCA)
#define  REG_DAC_ATOP_TB_65_H       (REG_DAC_ATOP_TB_BASE + 0xCB)
#define  REG_DAC_ATOP_TB_66_L       (REG_DAC_ATOP_TB_BASE + 0xCC)
#define  REG_DAC_ATOP_TB_66_H       (REG_DAC_ATOP_TB_BASE + 0xCD)
#define  REG_DAC_ATOP_TB_67_L       (REG_DAC_ATOP_TB_BASE + 0xCE)
#define  REG_DAC_ATOP_TB_67_H       (REG_DAC_ATOP_TB_BASE + 0xCF)
#define  REG_DAC_ATOP_TB_68_L       (REG_DAC_ATOP_TB_BASE + 0xD0)
#define  REG_DAC_ATOP_TB_68_H       (REG_DAC_ATOP_TB_BASE + 0xD1)
#define  REG_DAC_ATOP_TB_69_L       (REG_DAC_ATOP_TB_BASE + 0xD2)
#define  REG_DAC_ATOP_TB_69_H       (REG_DAC_ATOP_TB_BASE + 0xD3)
#define  REG_DAC_ATOP_TB_6A_L       (REG_DAC_ATOP_TB_BASE + 0xD4)
#define  REG_DAC_ATOP_TB_6A_H       (REG_DAC_ATOP_TB_BASE + 0xD5)
#define  REG_DAC_ATOP_TB_6B_L       (REG_DAC_ATOP_TB_BASE + 0xD6)
#define  REG_DAC_ATOP_TB_6B_H       (REG_DAC_ATOP_TB_BASE + 0xD7)
#define  REG_DAC_ATOP_TB_6C_L       (REG_DAC_ATOP_TB_BASE + 0xD8)
#define  REG_DAC_ATOP_TB_6C_H       (REG_DAC_ATOP_TB_BASE + 0xD9)
#define  REG_DAC_ATOP_TB_6D_L       (REG_DAC_ATOP_TB_BASE + 0xDA)
#define  REG_DAC_ATOP_TB_6D_H       (REG_DAC_ATOP_TB_BASE + 0xDB)
#define  REG_DAC_ATOP_TB_6E_L       (REG_DAC_ATOP_TB_BASE + 0xDC)
#define  REG_DAC_ATOP_TB_6E_H       (REG_DAC_ATOP_TB_BASE + 0xDD)
#define  REG_DAC_ATOP_TB_6F_L       (REG_DAC_ATOP_TB_BASE + 0xDE)
#define  REG_DAC_ATOP_TB_6F_H       (REG_DAC_ATOP_TB_BASE + 0xDF)
#define  REG_DAC_ATOP_TB_70_L       (REG_DAC_ATOP_TB_BASE + 0xE0)
#define  REG_DAC_ATOP_TB_70_H       (REG_DAC_ATOP_TB_BASE + 0xE1)
#define  REG_DAC_ATOP_TB_71_L       (REG_DAC_ATOP_TB_BASE + 0xE2)
#define  REG_DAC_ATOP_TB_71_H       (REG_DAC_ATOP_TB_BASE + 0xE3)
#define  REG_DAC_ATOP_TB_72_L       (REG_DAC_ATOP_TB_BASE + 0xE4)
#define  REG_DAC_ATOP_TB_72_H       (REG_DAC_ATOP_TB_BASE + 0xE5)
#define  REG_DAC_ATOP_TB_73_L       (REG_DAC_ATOP_TB_BASE + 0xE6)
#define  REG_DAC_ATOP_TB_73_H       (REG_DAC_ATOP_TB_BASE + 0xE7)
#define  REG_DAC_ATOP_TB_74_L       (REG_DAC_ATOP_TB_BASE + 0xE8)
#define  REG_DAC_ATOP_TB_74_H       (REG_DAC_ATOP_TB_BASE + 0xE9)
#define  REG_DAC_ATOP_TB_75_L       (REG_DAC_ATOP_TB_BASE + 0xEA)
#define  REG_DAC_ATOP_TB_75_H       (REG_DAC_ATOP_TB_BASE + 0xEB)
#define  REG_DAC_ATOP_TB_76_L       (REG_DAC_ATOP_TB_BASE + 0xEC)
#define  REG_DAC_ATOP_TB_76_H       (REG_DAC_ATOP_TB_BASE + 0xED)
#define  REG_DAC_ATOP_TB_77_L       (REG_DAC_ATOP_TB_BASE + 0xEE)
#define  REG_DAC_ATOP_TB_77_H       (REG_DAC_ATOP_TB_BASE + 0xEF)
#define  REG_DAC_ATOP_TB_78_L       (REG_DAC_ATOP_TB_BASE + 0xF0)
#define  REG_DAC_ATOP_TB_78_H       (REG_DAC_ATOP_TB_BASE + 0xF1)
#define  REG_DAC_ATOP_TB_79_L       (REG_DAC_ATOP_TB_BASE + 0xF2)
#define  REG_DAC_ATOP_TB_79_H       (REG_DAC_ATOP_TB_BASE + 0xF3)
#define  REG_DAC_ATOP_TB_7A_L       (REG_DAC_ATOP_TB_BASE + 0xF4)
#define  REG_DAC_ATOP_TB_7A_H       (REG_DAC_ATOP_TB_BASE + 0xF5)
#define  REG_DAC_ATOP_TB_7B_L       (REG_DAC_ATOP_TB_BASE + 0xF6)
#define  REG_DAC_ATOP_TB_7B_H       (REG_DAC_ATOP_TB_BASE + 0xF7)
#define  REG_DAC_ATOP_TB_7C_L       (REG_DAC_ATOP_TB_BASE + 0xF8)
#define  REG_DAC_ATOP_TB_7C_H       (REG_DAC_ATOP_TB_BASE + 0xF9)
#define  REG_DAC_ATOP_TB_7D_L       (REG_DAC_ATOP_TB_BASE + 0xFA)
#define  REG_DAC_ATOP_TB_7D_H       (REG_DAC_ATOP_TB_BASE + 0xFB)
#define  REG_DAC_ATOP_TB_7E_L       (REG_DAC_ATOP_TB_BASE + 0xFC)
#define  REG_DAC_ATOP_TB_7E_H       (REG_DAC_ATOP_TB_BASE + 0xFD)
#define  REG_DAC_ATOP_TB_7F_L       (REG_DAC_ATOP_TB_BASE + 0xFE)
#define  REG_DAC_ATOP_TB_7F_H       (REG_DAC_ATOP_TB_BASE + 0xFF)

#define  REG_DISP_TOP_TB_00_L       (REG_DISP_TOP_TB_BASE + 0x00)
#define  REG_DISP_TOP_TB_00_H       (REG_DISP_TOP_TB_BASE + 0x01)
#define  REG_DISP_TOP_TB_01_L       (REG_DISP_TOP_TB_BASE + 0x02)
#define  REG_DISP_TOP_TB_01_H       (REG_DISP_TOP_TB_BASE + 0x03)
#define  REG_DISP_TOP_TB_02_L       (REG_DISP_TOP_TB_BASE + 0x04)
#define  REG_DISP_TOP_TB_02_H       (REG_DISP_TOP_TB_BASE + 0x05)
#define  REG_DISP_TOP_TB_03_L       (REG_DISP_TOP_TB_BASE + 0x06)
#define  REG_DISP_TOP_TB_03_H       (REG_DISP_TOP_TB_BASE + 0x07)
#define  REG_DISP_TOP_TB_04_L       (REG_DISP_TOP_TB_BASE + 0x08)
#define  REG_DISP_TOP_TB_04_H       (REG_DISP_TOP_TB_BASE + 0x09)
#define  REG_DISP_TOP_TB_05_L       (REG_DISP_TOP_TB_BASE + 0x0A)
#define  REG_DISP_TOP_TB_05_H       (REG_DISP_TOP_TB_BASE + 0x0B)
#define  REG_DISP_TOP_TB_06_L       (REG_DISP_TOP_TB_BASE + 0x0C)
#define  REG_DISP_TOP_TB_06_H       (REG_DISP_TOP_TB_BASE + 0x0D)
#define  REG_DISP_TOP_TB_07_L       (REG_DISP_TOP_TB_BASE + 0x0E)
#define  REG_DISP_TOP_TB_07_H       (REG_DISP_TOP_TB_BASE + 0x0F)
#define  REG_DISP_TOP_TB_08_L       (REG_DISP_TOP_TB_BASE + 0x10)
#define  REG_DISP_TOP_TB_08_H       (REG_DISP_TOP_TB_BASE + 0x11)
#define  REG_DISP_TOP_TB_09_L       (REG_DISP_TOP_TB_BASE + 0x12)
#define  REG_DISP_TOP_TB_09_H       (REG_DISP_TOP_TB_BASE + 0x13)
#define  REG_DISP_TOP_TB_0A_L       (REG_DISP_TOP_TB_BASE + 0x14)
#define  REG_DISP_TOP_TB_0A_H       (REG_DISP_TOP_TB_BASE + 0x15)
#define  REG_DISP_TOP_TB_0B_L       (REG_DISP_TOP_TB_BASE + 0x16)
#define  REG_DISP_TOP_TB_0B_H       (REG_DISP_TOP_TB_BASE + 0x17)
#define  REG_DISP_TOP_TB_0C_L       (REG_DISP_TOP_TB_BASE + 0x18)
#define  REG_DISP_TOP_TB_0C_H       (REG_DISP_TOP_TB_BASE + 0x19)
#define  REG_DISP_TOP_TB_0D_L       (REG_DISP_TOP_TB_BASE + 0x1A)
#define  REG_DISP_TOP_TB_0D_H       (REG_DISP_TOP_TB_BASE + 0x1B)
#define  REG_DISP_TOP_TB_0E_L       (REG_DISP_TOP_TB_BASE + 0x1C)
#define  REG_DISP_TOP_TB_0E_H       (REG_DISP_TOP_TB_BASE + 0x1D)
#define  REG_DISP_TOP_TB_0F_L       (REG_DISP_TOP_TB_BASE + 0x1E)
#define  REG_DISP_TOP_TB_0F_H       (REG_DISP_TOP_TB_BASE + 0x1F)
#define  REG_DISP_TOP_TB_10_L       (REG_DISP_TOP_TB_BASE + 0x20)
#define  REG_DISP_TOP_TB_10_H       (REG_DISP_TOP_TB_BASE + 0x21)
#define  REG_DISP_TOP_TB_11_L       (REG_DISP_TOP_TB_BASE + 0x22)
#define  REG_DISP_TOP_TB_11_H       (REG_DISP_TOP_TB_BASE + 0x23)
#define  REG_DISP_TOP_TB_12_L       (REG_DISP_TOP_TB_BASE + 0x24)
#define  REG_DISP_TOP_TB_12_H       (REG_DISP_TOP_TB_BASE + 0x25)
#define  REG_DISP_TOP_TB_13_L       (REG_DISP_TOP_TB_BASE + 0x26)
#define  REG_DISP_TOP_TB_13_H       (REG_DISP_TOP_TB_BASE + 0x27)
#define  REG_DISP_TOP_TB_14_L       (REG_DISP_TOP_TB_BASE + 0x28)
#define  REG_DISP_TOP_TB_14_H       (REG_DISP_TOP_TB_BASE + 0x29)
#define  REG_DISP_TOP_TB_15_L       (REG_DISP_TOP_TB_BASE + 0x2A)
#define  REG_DISP_TOP_TB_15_H       (REG_DISP_TOP_TB_BASE + 0x2B)
#define  REG_DISP_TOP_TB_16_L       (REG_DISP_TOP_TB_BASE + 0x2C)
#define  REG_DISP_TOP_TB_16_H       (REG_DISP_TOP_TB_BASE + 0x2D)
#define  REG_DISP_TOP_TB_17_L       (REG_DISP_TOP_TB_BASE + 0x2E)
#define  REG_DISP_TOP_TB_17_H       (REG_DISP_TOP_TB_BASE + 0x2F)
#define  REG_DISP_TOP_TB_18_L       (REG_DISP_TOP_TB_BASE + 0x30)
#define  REG_DISP_TOP_TB_18_H       (REG_DISP_TOP_TB_BASE + 0x31)
#define  REG_DISP_TOP_TB_19_L       (REG_DISP_TOP_TB_BASE + 0x32)
#define  REG_DISP_TOP_TB_19_H       (REG_DISP_TOP_TB_BASE + 0x33)
#define  REG_DISP_TOP_TB_1A_L       (REG_DISP_TOP_TB_BASE + 0x34)
#define  REG_DISP_TOP_TB_1A_H       (REG_DISP_TOP_TB_BASE + 0x35)
#define  REG_DISP_TOP_TB_1B_L       (REG_DISP_TOP_TB_BASE + 0x36)
#define  REG_DISP_TOP_TB_1B_H       (REG_DISP_TOP_TB_BASE + 0x37)
#define  REG_DISP_TOP_TB_1C_L       (REG_DISP_TOP_TB_BASE + 0x38)
#define  REG_DISP_TOP_TB_1C_H       (REG_DISP_TOP_TB_BASE + 0x39)
#define  REG_DISP_TOP_TB_1D_L       (REG_DISP_TOP_TB_BASE + 0x3A)
#define  REG_DISP_TOP_TB_1D_H       (REG_DISP_TOP_TB_BASE + 0x3B)
#define  REG_DISP_TOP_TB_1E_L       (REG_DISP_TOP_TB_BASE + 0x3C)
#define  REG_DISP_TOP_TB_1E_H       (REG_DISP_TOP_TB_BASE + 0x3D)
#define  REG_DISP_TOP_TB_1F_L       (REG_DISP_TOP_TB_BASE + 0x3E)
#define  REG_DISP_TOP_TB_1F_H       (REG_DISP_TOP_TB_BASE + 0x3F)
#define  REG_DISP_TOP_TB_20_L       (REG_DISP_TOP_TB_BASE + 0x40)
#define  REG_DISP_TOP_TB_20_H       (REG_DISP_TOP_TB_BASE + 0x41)
#define  REG_DISP_TOP_TB_21_L       (REG_DISP_TOP_TB_BASE + 0x42)
#define  REG_DISP_TOP_TB_21_H       (REG_DISP_TOP_TB_BASE + 0x43)
#define  REG_DISP_TOP_TB_22_L       (REG_DISP_TOP_TB_BASE + 0x44)
#define  REG_DISP_TOP_TB_22_H       (REG_DISP_TOP_TB_BASE + 0x45)
#define  REG_DISP_TOP_TB_23_L       (REG_DISP_TOP_TB_BASE + 0x46)
#define  REG_DISP_TOP_TB_23_H       (REG_DISP_TOP_TB_BASE + 0x47)
#define  REG_DISP_TOP_TB_24_L       (REG_DISP_TOP_TB_BASE + 0x48)
#define  REG_DISP_TOP_TB_24_H       (REG_DISP_TOP_TB_BASE + 0x49)
#define  REG_DISP_TOP_TB_25_L       (REG_DISP_TOP_TB_BASE + 0x4A)
#define  REG_DISP_TOP_TB_25_H       (REG_DISP_TOP_TB_BASE + 0x4B)
#define  REG_DISP_TOP_TB_26_L       (REG_DISP_TOP_TB_BASE + 0x4C)
#define  REG_DISP_TOP_TB_26_H       (REG_DISP_TOP_TB_BASE + 0x4D)
#define  REG_DISP_TOP_TB_27_L       (REG_DISP_TOP_TB_BASE + 0x4E)
#define  REG_DISP_TOP_TB_27_H       (REG_DISP_TOP_TB_BASE + 0x4F)
#define  REG_DISP_TOP_TB_28_L       (REG_DISP_TOP_TB_BASE + 0x50)
#define  REG_DISP_TOP_TB_28_H       (REG_DISP_TOP_TB_BASE + 0x51)
#define  REG_DISP_TOP_TB_29_L       (REG_DISP_TOP_TB_BASE + 0x52)
#define  REG_DISP_TOP_TB_29_H       (REG_DISP_TOP_TB_BASE + 0x53)
#define  REG_DISP_TOP_TB_2A_L       (REG_DISP_TOP_TB_BASE + 0x54)
#define  REG_DISP_TOP_TB_2A_H       (REG_DISP_TOP_TB_BASE + 0x55)
#define  REG_DISP_TOP_TB_2B_L       (REG_DISP_TOP_TB_BASE + 0x56)
#define  REG_DISP_TOP_TB_2B_H       (REG_DISP_TOP_TB_BASE + 0x57)
#define  REG_DISP_TOP_TB_2C_L       (REG_DISP_TOP_TB_BASE + 0x58)
#define  REG_DISP_TOP_TB_2C_H       (REG_DISP_TOP_TB_BASE + 0x59)
#define  REG_DISP_TOP_TB_2D_L       (REG_DISP_TOP_TB_BASE + 0x5A)
#define  REG_DISP_TOP_TB_2D_H       (REG_DISP_TOP_TB_BASE + 0x5B)
#define  REG_DISP_TOP_TB_2E_L       (REG_DISP_TOP_TB_BASE + 0x5C)
#define  REG_DISP_TOP_TB_2E_H       (REG_DISP_TOP_TB_BASE + 0x5D)
#define  REG_DISP_TOP_TB_2F_L       (REG_DISP_TOP_TB_BASE + 0x5E)
#define  REG_DISP_TOP_TB_2F_H       (REG_DISP_TOP_TB_BASE + 0x5F)
#define  REG_DISP_TOP_TB_30_L       (REG_DISP_TOP_TB_BASE + 0x60)
#define  REG_DISP_TOP_TB_30_H       (REG_DISP_TOP_TB_BASE + 0x61)
#define  REG_DISP_TOP_TB_31_L       (REG_DISP_TOP_TB_BASE + 0x62)
#define  REG_DISP_TOP_TB_31_H       (REG_DISP_TOP_TB_BASE + 0x63)
#define  REG_DISP_TOP_TB_32_L       (REG_DISP_TOP_TB_BASE + 0x64)
#define  REG_DISP_TOP_TB_32_H       (REG_DISP_TOP_TB_BASE + 0x65)
#define  REG_DISP_TOP_TB_33_L       (REG_DISP_TOP_TB_BASE + 0x66)
#define  REG_DISP_TOP_TB_33_H       (REG_DISP_TOP_TB_BASE + 0x67)
#define  REG_DISP_TOP_TB_34_L       (REG_DISP_TOP_TB_BASE + 0x68)
#define  REG_DISP_TOP_TB_34_H       (REG_DISP_TOP_TB_BASE + 0x69)
#define  REG_DISP_TOP_TB_35_L       (REG_DISP_TOP_TB_BASE + 0x6A)
#define  REG_DISP_TOP_TB_35_H       (REG_DISP_TOP_TB_BASE + 0x6B)
#define  REG_DISP_TOP_TB_36_L       (REG_DISP_TOP_TB_BASE + 0x6C)
#define  REG_DISP_TOP_TB_36_H       (REG_DISP_TOP_TB_BASE + 0x6D)
#define  REG_DISP_TOP_TB_37_L       (REG_DISP_TOP_TB_BASE + 0x6E)
#define  REG_DISP_TOP_TB_37_H       (REG_DISP_TOP_TB_BASE + 0x6F)
#define  REG_DISP_TOP_TB_38_L       (REG_DISP_TOP_TB_BASE + 0x70)
#define  REG_DISP_TOP_TB_38_H       (REG_DISP_TOP_TB_BASE + 0x71)
#define  REG_DISP_TOP_TB_39_L       (REG_DISP_TOP_TB_BASE + 0x72)
#define  REG_DISP_TOP_TB_39_H       (REG_DISP_TOP_TB_BASE + 0x73)
#define  REG_DISP_TOP_TB_3A_L       (REG_DISP_TOP_TB_BASE + 0x74)
#define  REG_DISP_TOP_TB_3A_H       (REG_DISP_TOP_TB_BASE + 0x75)
#define  REG_DISP_TOP_TB_3B_L       (REG_DISP_TOP_TB_BASE + 0x76)
#define  REG_DISP_TOP_TB_3B_H       (REG_DISP_TOP_TB_BASE + 0x77)
#define  REG_DISP_TOP_TB_3C_L       (REG_DISP_TOP_TB_BASE + 0x78)
#define  REG_DISP_TOP_TB_3C_H       (REG_DISP_TOP_TB_BASE + 0x79)
#define  REG_DISP_TOP_TB_3D_L       (REG_DISP_TOP_TB_BASE + 0x7A)
#define  REG_DISP_TOP_TB_3D_H       (REG_DISP_TOP_TB_BASE + 0x7B)
#define  REG_DISP_TOP_TB_3E_L       (REG_DISP_TOP_TB_BASE + 0x7C)
#define  REG_DISP_TOP_TB_3E_H       (REG_DISP_TOP_TB_BASE + 0x7D)
#define  REG_DISP_TOP_TB_3F_L       (REG_DISP_TOP_TB_BASE + 0x7E)
#define  REG_DISP_TOP_TB_3F_H       (REG_DISP_TOP_TB_BASE + 0x7F)
#define  REG_DISP_TOP_TB_40_L       (REG_DISP_TOP_TB_BASE + 0x80)
#define  REG_DISP_TOP_TB_40_H       (REG_DISP_TOP_TB_BASE + 0x81)
#define  REG_DISP_TOP_TB_41_L       (REG_DISP_TOP_TB_BASE + 0x82)
#define  REG_DISP_TOP_TB_41_H       (REG_DISP_TOP_TB_BASE + 0x83)
#define  REG_DISP_TOP_TB_42_L       (REG_DISP_TOP_TB_BASE + 0x84)
#define  REG_DISP_TOP_TB_42_H       (REG_DISP_TOP_TB_BASE + 0x85)
#define  REG_DISP_TOP_TB_43_L       (REG_DISP_TOP_TB_BASE + 0x86)
#define  REG_DISP_TOP_TB_43_H       (REG_DISP_TOP_TB_BASE + 0x87)
#define  REG_DISP_TOP_TB_44_L       (REG_DISP_TOP_TB_BASE + 0x88)
#define  REG_DISP_TOP_TB_44_H       (REG_DISP_TOP_TB_BASE + 0x89)
#define  REG_DISP_TOP_TB_45_L       (REG_DISP_TOP_TB_BASE + 0x8A)
#define  REG_DISP_TOP_TB_45_H       (REG_DISP_TOP_TB_BASE + 0x8B)
#define  REG_DISP_TOP_TB_46_L       (REG_DISP_TOP_TB_BASE + 0x8C)
#define  REG_DISP_TOP_TB_46_H       (REG_DISP_TOP_TB_BASE + 0x8D)
#define  REG_DISP_TOP_TB_47_L       (REG_DISP_TOP_TB_BASE + 0x8E)
#define  REG_DISP_TOP_TB_47_H       (REG_DISP_TOP_TB_BASE + 0x8F)
#define  REG_DISP_TOP_TB_48_L       (REG_DISP_TOP_TB_BASE + 0x90)
#define  REG_DISP_TOP_TB_48_H       (REG_DISP_TOP_TB_BASE + 0x91)
#define  REG_DISP_TOP_TB_49_L       (REG_DISP_TOP_TB_BASE + 0x92)
#define  REG_DISP_TOP_TB_49_H       (REG_DISP_TOP_TB_BASE + 0x93)
#define  REG_DISP_TOP_TB_4A_L       (REG_DISP_TOP_TB_BASE + 0x94)
#define  REG_DISP_TOP_TB_4A_H       (REG_DISP_TOP_TB_BASE + 0x95)
#define  REG_DISP_TOP_TB_4B_L       (REG_DISP_TOP_TB_BASE + 0x96)
#define  REG_DISP_TOP_TB_4B_H       (REG_DISP_TOP_TB_BASE + 0x97)
#define  REG_DISP_TOP_TB_4C_L       (REG_DISP_TOP_TB_BASE + 0x98)
#define  REG_DISP_TOP_TB_4C_H       (REG_DISP_TOP_TB_BASE + 0x99)
#define  REG_DISP_TOP_TB_4D_L       (REG_DISP_TOP_TB_BASE + 0x9A)
#define  REG_DISP_TOP_TB_4D_H       (REG_DISP_TOP_TB_BASE + 0x9B)
#define  REG_DISP_TOP_TB_4E_L       (REG_DISP_TOP_TB_BASE + 0x9C)
#define  REG_DISP_TOP_TB_4E_H       (REG_DISP_TOP_TB_BASE + 0x9D)
#define  REG_DISP_TOP_TB_4F_L       (REG_DISP_TOP_TB_BASE + 0x9E)
#define  REG_DISP_TOP_TB_4F_H       (REG_DISP_TOP_TB_BASE + 0x9F)
#define  REG_DISP_TOP_TB_50_L       (REG_DISP_TOP_TB_BASE + 0xA0)
#define  REG_DISP_TOP_TB_50_H       (REG_DISP_TOP_TB_BASE + 0xA1)
#define  REG_DISP_TOP_TB_51_L       (REG_DISP_TOP_TB_BASE + 0xA2)
#define  REG_DISP_TOP_TB_51_H       (REG_DISP_TOP_TB_BASE + 0xA3)
#define  REG_DISP_TOP_TB_52_L       (REG_DISP_TOP_TB_BASE + 0xA4)
#define  REG_DISP_TOP_TB_52_H       (REG_DISP_TOP_TB_BASE + 0xA5)
#define  REG_DISP_TOP_TB_53_L       (REG_DISP_TOP_TB_BASE + 0xA6)
#define  REG_DISP_TOP_TB_53_H       (REG_DISP_TOP_TB_BASE + 0xA7)
#define  REG_DISP_TOP_TB_54_L       (REG_DISP_TOP_TB_BASE + 0xA8)
#define  REG_DISP_TOP_TB_54_H       (REG_DISP_TOP_TB_BASE + 0xA9)
#define  REG_DISP_TOP_TB_55_L       (REG_DISP_TOP_TB_BASE + 0xAA)
#define  REG_DISP_TOP_TB_55_H       (REG_DISP_TOP_TB_BASE + 0xAB)
#define  REG_DISP_TOP_TB_56_L       (REG_DISP_TOP_TB_BASE + 0xAC)
#define  REG_DISP_TOP_TB_56_H       (REG_DISP_TOP_TB_BASE + 0xAD)
#define  REG_DISP_TOP_TB_57_L       (REG_DISP_TOP_TB_BASE + 0xAE)
#define  REG_DISP_TOP_TB_57_H       (REG_DISP_TOP_TB_BASE + 0xAF)
#define  REG_DISP_TOP_TB_58_L       (REG_DISP_TOP_TB_BASE + 0xB0)
#define  REG_DISP_TOP_TB_58_H       (REG_DISP_TOP_TB_BASE + 0xB1)
#define  REG_DISP_TOP_TB_59_L       (REG_DISP_TOP_TB_BASE + 0xB2)
#define  REG_DISP_TOP_TB_59_H       (REG_DISP_TOP_TB_BASE + 0xB3)
#define  REG_DISP_TOP_TB_5A_L       (REG_DISP_TOP_TB_BASE + 0xB4)
#define  REG_DISP_TOP_TB_5A_H       (REG_DISP_TOP_TB_BASE + 0xB5)
#define  REG_DISP_TOP_TB_5B_L       (REG_DISP_TOP_TB_BASE + 0xB6)
#define  REG_DISP_TOP_TB_5B_H       (REG_DISP_TOP_TB_BASE + 0xB7)
#define  REG_DISP_TOP_TB_5C_L       (REG_DISP_TOP_TB_BASE + 0xB8)
#define  REG_DISP_TOP_TB_5C_H       (REG_DISP_TOP_TB_BASE + 0xB9)
#define  REG_DISP_TOP_TB_5D_L       (REG_DISP_TOP_TB_BASE + 0xBA)
#define  REG_DISP_TOP_TB_5D_H       (REG_DISP_TOP_TB_BASE + 0xBB)
#define  REG_DISP_TOP_TB_5E_L       (REG_DISP_TOP_TB_BASE + 0xBC)
#define  REG_DISP_TOP_TB_5E_H       (REG_DISP_TOP_TB_BASE + 0xBD)
#define  REG_DISP_TOP_TB_5F_L       (REG_DISP_TOP_TB_BASE + 0xBE)
#define  REG_DISP_TOP_TB_5F_H       (REG_DISP_TOP_TB_BASE + 0xBF)
#define  REG_DISP_TOP_TB_60_L       (REG_DISP_TOP_TB_BASE + 0xC0)
#define  REG_DISP_TOP_TB_60_H       (REG_DISP_TOP_TB_BASE + 0xC1)
#define  REG_DISP_TOP_TB_61_L       (REG_DISP_TOP_TB_BASE + 0xC2)
#define  REG_DISP_TOP_TB_61_H       (REG_DISP_TOP_TB_BASE + 0xC3)
#define  REG_DISP_TOP_TB_62_L       (REG_DISP_TOP_TB_BASE + 0xC4)
#define  REG_DISP_TOP_TB_62_H       (REG_DISP_TOP_TB_BASE + 0xC5)
#define  REG_DISP_TOP_TB_63_L       (REG_DISP_TOP_TB_BASE + 0xC6)
#define  REG_DISP_TOP_TB_63_H       (REG_DISP_TOP_TB_BASE + 0xC7)
#define  REG_DISP_TOP_TB_64_L       (REG_DISP_TOP_TB_BASE + 0xC8)
#define  REG_DISP_TOP_TB_64_H       (REG_DISP_TOP_TB_BASE + 0xC9)
#define  REG_DISP_TOP_TB_65_L       (REG_DISP_TOP_TB_BASE + 0xCA)
#define  REG_DISP_TOP_TB_65_H       (REG_DISP_TOP_TB_BASE + 0xCB)
#define  REG_DISP_TOP_TB_66_L       (REG_DISP_TOP_TB_BASE + 0xCC)
#define  REG_DISP_TOP_TB_66_H       (REG_DISP_TOP_TB_BASE + 0xCD)
#define  REG_DISP_TOP_TB_67_L       (REG_DISP_TOP_TB_BASE + 0xCE)
#define  REG_DISP_TOP_TB_67_H       (REG_DISP_TOP_TB_BASE + 0xCF)
#define  REG_DISP_TOP_TB_68_L       (REG_DISP_TOP_TB_BASE + 0xD0)
#define  REG_DISP_TOP_TB_68_H       (REG_DISP_TOP_TB_BASE + 0xD1)
#define  REG_DISP_TOP_TB_69_L       (REG_DISP_TOP_TB_BASE + 0xD2)
#define  REG_DISP_TOP_TB_69_H       (REG_DISP_TOP_TB_BASE + 0xD3)
#define  REG_DISP_TOP_TB_6A_L       (REG_DISP_TOP_TB_BASE + 0xD4)
#define  REG_DISP_TOP_TB_6A_H       (REG_DISP_TOP_TB_BASE + 0xD5)
#define  REG_DISP_TOP_TB_6B_L       (REG_DISP_TOP_TB_BASE + 0xD6)
#define  REG_DISP_TOP_TB_6B_H       (REG_DISP_TOP_TB_BASE + 0xD7)
#define  REG_DISP_TOP_TB_6C_L       (REG_DISP_TOP_TB_BASE + 0xD8)
#define  REG_DISP_TOP_TB_6C_H       (REG_DISP_TOP_TB_BASE + 0xD9)
#define  REG_DISP_TOP_TB_6D_L       (REG_DISP_TOP_TB_BASE + 0xDA)
#define  REG_DISP_TOP_TB_6D_H       (REG_DISP_TOP_TB_BASE + 0xDB)
#define  REG_DISP_TOP_TB_6E_L       (REG_DISP_TOP_TB_BASE + 0xDC)
#define  REG_DISP_TOP_TB_6E_H       (REG_DISP_TOP_TB_BASE + 0xDD)
#define  REG_DISP_TOP_TB_6F_L       (REG_DISP_TOP_TB_BASE + 0xDE)
#define  REG_DISP_TOP_TB_6F_H       (REG_DISP_TOP_TB_BASE + 0xDF)
#define  REG_DISP_TOP_TB_70_L       (REG_DISP_TOP_TB_BASE + 0xE0)
#define  REG_DISP_TOP_TB_70_H       (REG_DISP_TOP_TB_BASE + 0xE1)
#define  REG_DISP_TOP_TB_71_L       (REG_DISP_TOP_TB_BASE + 0xE2)
#define  REG_DISP_TOP_TB_71_H       (REG_DISP_TOP_TB_BASE + 0xE3)
#define  REG_DISP_TOP_TB_72_L       (REG_DISP_TOP_TB_BASE + 0xE4)
#define  REG_DISP_TOP_TB_72_H       (REG_DISP_TOP_TB_BASE + 0xE5)
#define  REG_DISP_TOP_TB_73_L       (REG_DISP_TOP_TB_BASE + 0xE6)
#define  REG_DISP_TOP_TB_73_H       (REG_DISP_TOP_TB_BASE + 0xE7)
#define  REG_DISP_TOP_TB_74_L       (REG_DISP_TOP_TB_BASE + 0xE8)
#define  REG_DISP_TOP_TB_74_H       (REG_DISP_TOP_TB_BASE + 0xE9)
#define  REG_DISP_TOP_TB_75_L       (REG_DISP_TOP_TB_BASE + 0xEA)
#define  REG_DISP_TOP_TB_75_H       (REG_DISP_TOP_TB_BASE + 0xEB)
#define  REG_DISP_TOP_TB_76_L       (REG_DISP_TOP_TB_BASE + 0xEC)
#define  REG_DISP_TOP_TB_76_H       (REG_DISP_TOP_TB_BASE + 0xED)
#define  REG_DISP_TOP_TB_77_L       (REG_DISP_TOP_TB_BASE + 0xEE)
#define  REG_DISP_TOP_TB_77_H       (REG_DISP_TOP_TB_BASE + 0xEF)
#define  REG_DISP_TOP_TB_78_L       (REG_DISP_TOP_TB_BASE + 0xF0)
#define  REG_DISP_TOP_TB_78_H       (REG_DISP_TOP_TB_BASE + 0xF1)
#define  REG_DISP_TOP_TB_79_L       (REG_DISP_TOP_TB_BASE + 0xF2)
#define  REG_DISP_TOP_TB_79_H       (REG_DISP_TOP_TB_BASE + 0xF3)
#define  REG_DISP_TOP_TB_7A_L       (REG_DISP_TOP_TB_BASE + 0xF4)
#define  REG_DISP_TOP_TB_7A_H       (REG_DISP_TOP_TB_BASE + 0xF5)
#define  REG_DISP_TOP_TB_7B_L       (REG_DISP_TOP_TB_BASE + 0xF6)
#define  REG_DISP_TOP_TB_7B_H       (REG_DISP_TOP_TB_BASE + 0xF7)
#define  REG_DISP_TOP_TB_7C_L       (REG_DISP_TOP_TB_BASE + 0xF8)
#define  REG_DISP_TOP_TB_7C_H       (REG_DISP_TOP_TB_BASE + 0xF9)
#define  REG_DISP_TOP_TB_7D_L       (REG_DISP_TOP_TB_BASE + 0xFA)
#define  REG_DISP_TOP_TB_7D_H       (REG_DISP_TOP_TB_BASE + 0xFB)
#define  REG_DISP_TOP_TB_7E_L       (REG_DISP_TOP_TB_BASE + 0xFC)
#define  REG_DISP_TOP_TB_7E_H       (REG_DISP_TOP_TB_BASE + 0xFD)
#define  REG_DISP_TOP_TB_7F_L       (REG_DISP_TOP_TB_BASE + 0xFE)
#define  REG_DISP_TOP_TB_7F_H       (REG_DISP_TOP_TB_BASE + 0xFF)

#define  REG_SC_GP_CTRL_TB_00_L       (REG_SC_GP_CTRL_TB_BASE + 0x00)
#define  REG_SC_GP_CTRL_TB_00_H       (REG_SC_GP_CTRL_TB_BASE + 0x01)
#define  REG_SC_GP_CTRL_TB_01_L       (REG_SC_GP_CTRL_TB_BASE + 0x02)
#define  REG_SC_GP_CTRL_TB_01_H       (REG_SC_GP_CTRL_TB_BASE + 0x03)
#define  REG_SC_GP_CTRL_TB_02_L       (REG_SC_GP_CTRL_TB_BASE + 0x04)
#define  REG_SC_GP_CTRL_TB_02_H       (REG_SC_GP_CTRL_TB_BASE + 0x05)
#define  REG_SC_GP_CTRL_TB_03_L       (REG_SC_GP_CTRL_TB_BASE + 0x06)
#define  REG_SC_GP_CTRL_TB_03_H       (REG_SC_GP_CTRL_TB_BASE + 0x07)
#define  REG_SC_GP_CTRL_TB_04_L       (REG_SC_GP_CTRL_TB_BASE + 0x08)
#define  REG_SC_GP_CTRL_TB_04_H       (REG_SC_GP_CTRL_TB_BASE + 0x09)
#define  REG_SC_GP_CTRL_TB_05_L       (REG_SC_GP_CTRL_TB_BASE + 0x0A)
#define  REG_SC_GP_CTRL_TB_05_H       (REG_SC_GP_CTRL_TB_BASE + 0x0B)
#define  REG_SC_GP_CTRL_TB_06_L       (REG_SC_GP_CTRL_TB_BASE + 0x0C)
#define  REG_SC_GP_CTRL_TB_06_H       (REG_SC_GP_CTRL_TB_BASE + 0x0D)
#define  REG_SC_GP_CTRL_TB_07_L       (REG_SC_GP_CTRL_TB_BASE + 0x0E)
#define  REG_SC_GP_CTRL_TB_07_H       (REG_SC_GP_CTRL_TB_BASE + 0x0F)
#define  REG_SC_GP_CTRL_TB_08_L       (REG_SC_GP_CTRL_TB_BASE + 0x10)
#define  REG_SC_GP_CTRL_TB_08_H       (REG_SC_GP_CTRL_TB_BASE + 0x11)
#define  REG_SC_GP_CTRL_TB_09_L       (REG_SC_GP_CTRL_TB_BASE + 0x12)
#define  REG_SC_GP_CTRL_TB_09_H       (REG_SC_GP_CTRL_TB_BASE + 0x13)
#define  REG_SC_GP_CTRL_TB_0A_L       (REG_SC_GP_CTRL_TB_BASE + 0x14)
#define  REG_SC_GP_CTRL_TB_0A_H       (REG_SC_GP_CTRL_TB_BASE + 0x15)
#define  REG_SC_GP_CTRL_TB_0B_L       (REG_SC_GP_CTRL_TB_BASE + 0x16)
#define  REG_SC_GP_CTRL_TB_0B_H       (REG_SC_GP_CTRL_TB_BASE + 0x17)
#define  REG_SC_GP_CTRL_TB_0C_L       (REG_SC_GP_CTRL_TB_BASE + 0x18)
#define  REG_SC_GP_CTRL_TB_0C_H       (REG_SC_GP_CTRL_TB_BASE + 0x19)
#define  REG_SC_GP_CTRL_TB_0D_L       (REG_SC_GP_CTRL_TB_BASE + 0x1A)
#define  REG_SC_GP_CTRL_TB_0D_H       (REG_SC_GP_CTRL_TB_BASE + 0x1B)
#define  REG_SC_GP_CTRL_TB_0E_L       (REG_SC_GP_CTRL_TB_BASE + 0x1C)
#define  REG_SC_GP_CTRL_TB_0E_H       (REG_SC_GP_CTRL_TB_BASE + 0x1D)
#define  REG_SC_GP_CTRL_TB_0F_L       (REG_SC_GP_CTRL_TB_BASE + 0x1E)
#define  REG_SC_GP_CTRL_TB_0F_H       (REG_SC_GP_CTRL_TB_BASE + 0x1F)
#define  REG_SC_GP_CTRL_TB_10_L       (REG_SC_GP_CTRL_TB_BASE + 0x20)
#define  REG_SC_GP_CTRL_TB_10_H       (REG_SC_GP_CTRL_TB_BASE + 0x21)
#define  REG_SC_GP_CTRL_TB_11_L       (REG_SC_GP_CTRL_TB_BASE + 0x22)
#define  REG_SC_GP_CTRL_TB_11_H       (REG_SC_GP_CTRL_TB_BASE + 0x23)
#define  REG_SC_GP_CTRL_TB_12_L       (REG_SC_GP_CTRL_TB_BASE + 0x24)
#define  REG_SC_GP_CTRL_TB_12_H       (REG_SC_GP_CTRL_TB_BASE + 0x25)
#define  REG_SC_GP_CTRL_TB_13_L       (REG_SC_GP_CTRL_TB_BASE + 0x26)
#define  REG_SC_GP_CTRL_TB_13_H       (REG_SC_GP_CTRL_TB_BASE + 0x27)
#define  REG_SC_GP_CTRL_TB_14_L       (REG_SC_GP_CTRL_TB_BASE + 0x28)
#define  REG_SC_GP_CTRL_TB_14_H       (REG_SC_GP_CTRL_TB_BASE + 0x29)
#define  REG_SC_GP_CTRL_TB_15_L       (REG_SC_GP_CTRL_TB_BASE + 0x2A)
#define  REG_SC_GP_CTRL_TB_15_H       (REG_SC_GP_CTRL_TB_BASE + 0x2B)
#define  REG_SC_GP_CTRL_TB_16_L       (REG_SC_GP_CTRL_TB_BASE + 0x2C)
#define  REG_SC_GP_CTRL_TB_16_H       (REG_SC_GP_CTRL_TB_BASE + 0x2D)
#define  REG_SC_GP_CTRL_TB_17_L       (REG_SC_GP_CTRL_TB_BASE + 0x2E)
#define  REG_SC_GP_CTRL_TB_17_H       (REG_SC_GP_CTRL_TB_BASE + 0x2F)
#define  REG_SC_GP_CTRL_TB_18_L       (REG_SC_GP_CTRL_TB_BASE + 0x30)
#define  REG_SC_GP_CTRL_TB_18_H       (REG_SC_GP_CTRL_TB_BASE + 0x31)
#define  REG_SC_GP_CTRL_TB_19_L       (REG_SC_GP_CTRL_TB_BASE + 0x32)
#define  REG_SC_GP_CTRL_TB_19_H       (REG_SC_GP_CTRL_TB_BASE + 0x33)
#define  REG_SC_GP_CTRL_TB_1A_L       (REG_SC_GP_CTRL_TB_BASE + 0x34)
#define  REG_SC_GP_CTRL_TB_1A_H       (REG_SC_GP_CTRL_TB_BASE + 0x35)
#define  REG_SC_GP_CTRL_TB_1B_L       (REG_SC_GP_CTRL_TB_BASE + 0x36)
#define  REG_SC_GP_CTRL_TB_1B_H       (REG_SC_GP_CTRL_TB_BASE + 0x37)
#define  REG_SC_GP_CTRL_TB_1C_L       (REG_SC_GP_CTRL_TB_BASE + 0x38)
#define  REG_SC_GP_CTRL_TB_1C_H       (REG_SC_GP_CTRL_TB_BASE + 0x39)
#define  REG_SC_GP_CTRL_TB_1D_L       (REG_SC_GP_CTRL_TB_BASE + 0x3A)
#define  REG_SC_GP_CTRL_TB_1D_H       (REG_SC_GP_CTRL_TB_BASE + 0x3B)
#define  REG_SC_GP_CTRL_TB_1E_L       (REG_SC_GP_CTRL_TB_BASE + 0x3C)
#define  REG_SC_GP_CTRL_TB_1E_H       (REG_SC_GP_CTRL_TB_BASE + 0x3D)
#define  REG_SC_GP_CTRL_TB_1F_L       (REG_SC_GP_CTRL_TB_BASE + 0x3E)
#define  REG_SC_GP_CTRL_TB_1F_H       (REG_SC_GP_CTRL_TB_BASE + 0x3F)
#define  REG_SC_GP_CTRL_TB_20_L       (REG_SC_GP_CTRL_TB_BASE + 0x40)
#define  REG_SC_GP_CTRL_TB_20_H       (REG_SC_GP_CTRL_TB_BASE + 0x41)
#define  REG_SC_GP_CTRL_TB_21_L       (REG_SC_GP_CTRL_TB_BASE + 0x42)
#define  REG_SC_GP_CTRL_TB_21_H       (REG_SC_GP_CTRL_TB_BASE + 0x43)
#define  REG_SC_GP_CTRL_TB_22_L       (REG_SC_GP_CTRL_TB_BASE + 0x44)
#define  REG_SC_GP_CTRL_TB_22_H       (REG_SC_GP_CTRL_TB_BASE + 0x45)
#define  REG_SC_GP_CTRL_TB_23_L       (REG_SC_GP_CTRL_TB_BASE + 0x46)
#define  REG_SC_GP_CTRL_TB_23_H       (REG_SC_GP_CTRL_TB_BASE + 0x47)
#define  REG_SC_GP_CTRL_TB_24_L       (REG_SC_GP_CTRL_TB_BASE + 0x48)
#define  REG_SC_GP_CTRL_TB_24_H       (REG_SC_GP_CTRL_TB_BASE + 0x49)
#define  REG_SC_GP_CTRL_TB_25_L       (REG_SC_GP_CTRL_TB_BASE + 0x4A)
#define  REG_SC_GP_CTRL_TB_25_H       (REG_SC_GP_CTRL_TB_BASE + 0x4B)
#define  REG_SC_GP_CTRL_TB_26_L       (REG_SC_GP_CTRL_TB_BASE + 0x4C)
#define  REG_SC_GP_CTRL_TB_26_H       (REG_SC_GP_CTRL_TB_BASE + 0x4D)
#define  REG_SC_GP_CTRL_TB_27_L       (REG_SC_GP_CTRL_TB_BASE + 0x4E)
#define  REG_SC_GP_CTRL_TB_27_H       (REG_SC_GP_CTRL_TB_BASE + 0x4F)
#define  REG_SC_GP_CTRL_TB_28_L       (REG_SC_GP_CTRL_TB_BASE + 0x50)
#define  REG_SC_GP_CTRL_TB_28_H       (REG_SC_GP_CTRL_TB_BASE + 0x51)
#define  REG_SC_GP_CTRL_TB_29_L       (REG_SC_GP_CTRL_TB_BASE + 0x52)
#define  REG_SC_GP_CTRL_TB_29_H       (REG_SC_GP_CTRL_TB_BASE + 0x53)
#define  REG_SC_GP_CTRL_TB_2A_L       (REG_SC_GP_CTRL_TB_BASE + 0x54)
#define  REG_SC_GP_CTRL_TB_2A_H       (REG_SC_GP_CTRL_TB_BASE + 0x55)
#define  REG_SC_GP_CTRL_TB_2B_L       (REG_SC_GP_CTRL_TB_BASE + 0x56)
#define  REG_SC_GP_CTRL_TB_2B_H       (REG_SC_GP_CTRL_TB_BASE + 0x57)
#define  REG_SC_GP_CTRL_TB_2C_L       (REG_SC_GP_CTRL_TB_BASE + 0x58)
#define  REG_SC_GP_CTRL_TB_2C_H       (REG_SC_GP_CTRL_TB_BASE + 0x59)
#define  REG_SC_GP_CTRL_TB_2D_L       (REG_SC_GP_CTRL_TB_BASE + 0x5A)
#define  REG_SC_GP_CTRL_TB_2D_H       (REG_SC_GP_CTRL_TB_BASE + 0x5B)
#define  REG_SC_GP_CTRL_TB_2E_L       (REG_SC_GP_CTRL_TB_BASE + 0x5C)
#define  REG_SC_GP_CTRL_TB_2E_H       (REG_SC_GP_CTRL_TB_BASE + 0x5D)
#define  REG_SC_GP_CTRL_TB_2F_L       (REG_SC_GP_CTRL_TB_BASE + 0x5E)
#define  REG_SC_GP_CTRL_TB_2F_H       (REG_SC_GP_CTRL_TB_BASE + 0x5F)
#define  REG_SC_GP_CTRL_TB_30_L       (REG_SC_GP_CTRL_TB_BASE + 0x60)
#define  REG_SC_GP_CTRL_TB_30_H       (REG_SC_GP_CTRL_TB_BASE + 0x61)
#define  REG_SC_GP_CTRL_TB_31_L       (REG_SC_GP_CTRL_TB_BASE + 0x62)
#define  REG_SC_GP_CTRL_TB_31_H       (REG_SC_GP_CTRL_TB_BASE + 0x63)
#define  REG_SC_GP_CTRL_TB_32_L       (REG_SC_GP_CTRL_TB_BASE + 0x64)
#define  REG_SC_GP_CTRL_TB_32_H       (REG_SC_GP_CTRL_TB_BASE + 0x65)
#define  REG_SC_GP_CTRL_TB_33_L       (REG_SC_GP_CTRL_TB_BASE + 0x66)
#define  REG_SC_GP_CTRL_TB_33_H       (REG_SC_GP_CTRL_TB_BASE + 0x67)
#define  REG_SC_GP_CTRL_TB_34_L       (REG_SC_GP_CTRL_TB_BASE + 0x68)
#define  REG_SC_GP_CTRL_TB_34_H       (REG_SC_GP_CTRL_TB_BASE + 0x69)
#define  REG_SC_GP_CTRL_TB_35_L       (REG_SC_GP_CTRL_TB_BASE + 0x6A)
#define  REG_SC_GP_CTRL_TB_35_H       (REG_SC_GP_CTRL_TB_BASE + 0x6B)
#define  REG_SC_GP_CTRL_TB_36_L       (REG_SC_GP_CTRL_TB_BASE + 0x6C)
#define  REG_SC_GP_CTRL_TB_36_H       (REG_SC_GP_CTRL_TB_BASE + 0x6D)
#define  REG_SC_GP_CTRL_TB_37_L       (REG_SC_GP_CTRL_TB_BASE + 0x6E)
#define  REG_SC_GP_CTRL_TB_37_H       (REG_SC_GP_CTRL_TB_BASE + 0x6F)
#define  REG_SC_GP_CTRL_TB_38_L       (REG_SC_GP_CTRL_TB_BASE + 0x70)
#define  REG_SC_GP_CTRL_TB_38_H       (REG_SC_GP_CTRL_TB_BASE + 0x71)
#define  REG_SC_GP_CTRL_TB_39_L       (REG_SC_GP_CTRL_TB_BASE + 0x72)
#define  REG_SC_GP_CTRL_TB_39_H       (REG_SC_GP_CTRL_TB_BASE + 0x73)
#define  REG_SC_GP_CTRL_TB_3A_L       (REG_SC_GP_CTRL_TB_BASE + 0x74)
#define  REG_SC_GP_CTRL_TB_3A_H       (REG_SC_GP_CTRL_TB_BASE + 0x75)
#define  REG_SC_GP_CTRL_TB_3B_L       (REG_SC_GP_CTRL_TB_BASE + 0x76)
#define  REG_SC_GP_CTRL_TB_3B_H       (REG_SC_GP_CTRL_TB_BASE + 0x77)
#define  REG_SC_GP_CTRL_TB_3C_L       (REG_SC_GP_CTRL_TB_BASE + 0x78)
#define  REG_SC_GP_CTRL_TB_3C_H       (REG_SC_GP_CTRL_TB_BASE + 0x79)
#define  REG_SC_GP_CTRL_TB_3D_L       (REG_SC_GP_CTRL_TB_BASE + 0x7A)
#define  REG_SC_GP_CTRL_TB_3D_H       (REG_SC_GP_CTRL_TB_BASE + 0x7B)
#define  REG_SC_GP_CTRL_TB_3E_L       (REG_SC_GP_CTRL_TB_BASE + 0x7C)
#define  REG_SC_GP_CTRL_TB_3E_H       (REG_SC_GP_CTRL_TB_BASE + 0x7D)
#define  REG_SC_GP_CTRL_TB_3F_L       (REG_SC_GP_CTRL_TB_BASE + 0x7E)
#define  REG_SC_GP_CTRL_TB_3F_H       (REG_SC_GP_CTRL_TB_BASE + 0x7F)
#define  REG_SC_GP_CTRL_TB_40_L       (REG_SC_GP_CTRL_TB_BASE + 0x80)
#define  REG_SC_GP_CTRL_TB_40_H       (REG_SC_GP_CTRL_TB_BASE + 0x81)
#define  REG_SC_GP_CTRL_TB_41_L       (REG_SC_GP_CTRL_TB_BASE + 0x82)
#define  REG_SC_GP_CTRL_TB_41_H       (REG_SC_GP_CTRL_TB_BASE + 0x83)
#define  REG_SC_GP_CTRL_TB_42_L       (REG_SC_GP_CTRL_TB_BASE + 0x84)
#define  REG_SC_GP_CTRL_TB_42_H       (REG_SC_GP_CTRL_TB_BASE + 0x85)
#define  REG_SC_GP_CTRL_TB_43_L       (REG_SC_GP_CTRL_TB_BASE + 0x86)
#define  REG_SC_GP_CTRL_TB_43_H       (REG_SC_GP_CTRL_TB_BASE + 0x87)
#define  REG_SC_GP_CTRL_TB_44_L       (REG_SC_GP_CTRL_TB_BASE + 0x88)
#define  REG_SC_GP_CTRL_TB_44_H       (REG_SC_GP_CTRL_TB_BASE + 0x89)
#define  REG_SC_GP_CTRL_TB_45_L       (REG_SC_GP_CTRL_TB_BASE + 0x8A)
#define  REG_SC_GP_CTRL_TB_45_H       (REG_SC_GP_CTRL_TB_BASE + 0x8B)
#define  REG_SC_GP_CTRL_TB_46_L       (REG_SC_GP_CTRL_TB_BASE + 0x8C)
#define  REG_SC_GP_CTRL_TB_46_H       (REG_SC_GP_CTRL_TB_BASE + 0x8D)
#define  REG_SC_GP_CTRL_TB_47_L       (REG_SC_GP_CTRL_TB_BASE + 0x8E)
#define  REG_SC_GP_CTRL_TB_47_H       (REG_SC_GP_CTRL_TB_BASE + 0x8F)
#define  REG_SC_GP_CTRL_TB_48_L       (REG_SC_GP_CTRL_TB_BASE + 0x90)
#define  REG_SC_GP_CTRL_TB_48_H       (REG_SC_GP_CTRL_TB_BASE + 0x91)
#define  REG_SC_GP_CTRL_TB_49_L       (REG_SC_GP_CTRL_TB_BASE + 0x92)
#define  REG_SC_GP_CTRL_TB_49_H       (REG_SC_GP_CTRL_TB_BASE + 0x93)
#define  REG_SC_GP_CTRL_TB_4A_L       (REG_SC_GP_CTRL_TB_BASE + 0x94)
#define  REG_SC_GP_CTRL_TB_4A_H       (REG_SC_GP_CTRL_TB_BASE + 0x95)
#define  REG_SC_GP_CTRL_TB_4B_L       (REG_SC_GP_CTRL_TB_BASE + 0x96)
#define  REG_SC_GP_CTRL_TB_4B_H       (REG_SC_GP_CTRL_TB_BASE + 0x97)
#define  REG_SC_GP_CTRL_TB_4C_L       (REG_SC_GP_CTRL_TB_BASE + 0x98)
#define  REG_SC_GP_CTRL_TB_4C_H       (REG_SC_GP_CTRL_TB_BASE + 0x99)
#define  REG_SC_GP_CTRL_TB_4D_L       (REG_SC_GP_CTRL_TB_BASE + 0x9A)
#define  REG_SC_GP_CTRL_TB_4D_H       (REG_SC_GP_CTRL_TB_BASE + 0x9B)
#define  REG_SC_GP_CTRL_TB_4E_L       (REG_SC_GP_CTRL_TB_BASE + 0x9C)
#define  REG_SC_GP_CTRL_TB_4E_H       (REG_SC_GP_CTRL_TB_BASE + 0x9D)
#define  REG_SC_GP_CTRL_TB_4F_L       (REG_SC_GP_CTRL_TB_BASE + 0x9E)
#define  REG_SC_GP_CTRL_TB_4F_H       (REG_SC_GP_CTRL_TB_BASE + 0x9F)
#define  REG_SC_GP_CTRL_TB_50_L       (REG_SC_GP_CTRL_TB_BASE + 0xA0)
#define  REG_SC_GP_CTRL_TB_50_H       (REG_SC_GP_CTRL_TB_BASE + 0xA1)
#define  REG_SC_GP_CTRL_TB_51_L       (REG_SC_GP_CTRL_TB_BASE + 0xA2)
#define  REG_SC_GP_CTRL_TB_51_H       (REG_SC_GP_CTRL_TB_BASE + 0xA3)
#define  REG_SC_GP_CTRL_TB_52_L       (REG_SC_GP_CTRL_TB_BASE + 0xA4)
#define  REG_SC_GP_CTRL_TB_52_H       (REG_SC_GP_CTRL_TB_BASE + 0xA5)
#define  REG_SC_GP_CTRL_TB_53_L       (REG_SC_GP_CTRL_TB_BASE + 0xA6)
#define  REG_SC_GP_CTRL_TB_53_H       (REG_SC_GP_CTRL_TB_BASE + 0xA7)
#define  REG_SC_GP_CTRL_TB_54_L       (REG_SC_GP_CTRL_TB_BASE + 0xA8)
#define  REG_SC_GP_CTRL_TB_54_H       (REG_SC_GP_CTRL_TB_BASE + 0xA9)
#define  REG_SC_GP_CTRL_TB_55_L       (REG_SC_GP_CTRL_TB_BASE + 0xAA)
#define  REG_SC_GP_CTRL_TB_55_H       (REG_SC_GP_CTRL_TB_BASE + 0xAB)
#define  REG_SC_GP_CTRL_TB_56_L       (REG_SC_GP_CTRL_TB_BASE + 0xAC)
#define  REG_SC_GP_CTRL_TB_56_H       (REG_SC_GP_CTRL_TB_BASE + 0xAD)
#define  REG_SC_GP_CTRL_TB_57_L       (REG_SC_GP_CTRL_TB_BASE + 0xAE)
#define  REG_SC_GP_CTRL_TB_57_H       (REG_SC_GP_CTRL_TB_BASE + 0xAF)
#define  REG_SC_GP_CTRL_TB_58_L       (REG_SC_GP_CTRL_TB_BASE + 0xB0)
#define  REG_SC_GP_CTRL_TB_58_H       (REG_SC_GP_CTRL_TB_BASE + 0xB1)
#define  REG_SC_GP_CTRL_TB_59_L       (REG_SC_GP_CTRL_TB_BASE + 0xB2)
#define  REG_SC_GP_CTRL_TB_59_H       (REG_SC_GP_CTRL_TB_BASE + 0xB3)
#define  REG_SC_GP_CTRL_TB_5A_L       (REG_SC_GP_CTRL_TB_BASE + 0xB4)
#define  REG_SC_GP_CTRL_TB_5A_H       (REG_SC_GP_CTRL_TB_BASE + 0xB5)
#define  REG_SC_GP_CTRL_TB_5B_L       (REG_SC_GP_CTRL_TB_BASE + 0xB6)
#define  REG_SC_GP_CTRL_TB_5B_H       (REG_SC_GP_CTRL_TB_BASE + 0xB7)
#define  REG_SC_GP_CTRL_TB_5C_L       (REG_SC_GP_CTRL_TB_BASE + 0xB8)
#define  REG_SC_GP_CTRL_TB_5C_H       (REG_SC_GP_CTRL_TB_BASE + 0xB9)
#define  REG_SC_GP_CTRL_TB_5D_L       (REG_SC_GP_CTRL_TB_BASE + 0xBA)
#define  REG_SC_GP_CTRL_TB_5D_H       (REG_SC_GP_CTRL_TB_BASE + 0xBB)
#define  REG_SC_GP_CTRL_TB_5E_L       (REG_SC_GP_CTRL_TB_BASE + 0xBC)
#define  REG_SC_GP_CTRL_TB_5E_H       (REG_SC_GP_CTRL_TB_BASE + 0xBD)
#define  REG_SC_GP_CTRL_TB_5F_L       (REG_SC_GP_CTRL_TB_BASE + 0xBE)
#define  REG_SC_GP_CTRL_TB_5F_H       (REG_SC_GP_CTRL_TB_BASE + 0xBF)
#define  REG_SC_GP_CTRL_TB_60_L       (REG_SC_GP_CTRL_TB_BASE + 0xC0)
#define  REG_SC_GP_CTRL_TB_60_H       (REG_SC_GP_CTRL_TB_BASE + 0xC1)
#define  REG_SC_GP_CTRL_TB_61_L       (REG_SC_GP_CTRL_TB_BASE + 0xC2)
#define  REG_SC_GP_CTRL_TB_61_H       (REG_SC_GP_CTRL_TB_BASE + 0xC3)
#define  REG_SC_GP_CTRL_TB_62_L       (REG_SC_GP_CTRL_TB_BASE + 0xC4)
#define  REG_SC_GP_CTRL_TB_62_H       (REG_SC_GP_CTRL_TB_BASE + 0xC5)
#define  REG_SC_GP_CTRL_TB_63_L       (REG_SC_GP_CTRL_TB_BASE + 0xC6)
#define  REG_SC_GP_CTRL_TB_63_H       (REG_SC_GP_CTRL_TB_BASE + 0xC7)
#define  REG_SC_GP_CTRL_TB_64_L       (REG_SC_GP_CTRL_TB_BASE + 0xC8)
#define  REG_SC_GP_CTRL_TB_64_H       (REG_SC_GP_CTRL_TB_BASE + 0xC9)
#define  REG_SC_GP_CTRL_TB_65_L       (REG_SC_GP_CTRL_TB_BASE + 0xCA)
#define  REG_SC_GP_CTRL_TB_65_H       (REG_SC_GP_CTRL_TB_BASE + 0xCB)
#define  REG_SC_GP_CTRL_TB_66_L       (REG_SC_GP_CTRL_TB_BASE + 0xCC)
#define  REG_SC_GP_CTRL_TB_66_H       (REG_SC_GP_CTRL_TB_BASE + 0xCD)
#define  REG_SC_GP_CTRL_TB_67_L       (REG_SC_GP_CTRL_TB_BASE + 0xCE)
#define  REG_SC_GP_CTRL_TB_67_H       (REG_SC_GP_CTRL_TB_BASE + 0xCF)
#define  REG_SC_GP_CTRL_TB_68_L       (REG_SC_GP_CTRL_TB_BASE + 0xD0)
#define  REG_SC_GP_CTRL_TB_68_H       (REG_SC_GP_CTRL_TB_BASE + 0xD1)
#define  REG_SC_GP_CTRL_TB_69_L       (REG_SC_GP_CTRL_TB_BASE + 0xD2)
#define  REG_SC_GP_CTRL_TB_69_H       (REG_SC_GP_CTRL_TB_BASE + 0xD3)
#define  REG_SC_GP_CTRL_TB_6A_L       (REG_SC_GP_CTRL_TB_BASE + 0xD4)
#define  REG_SC_GP_CTRL_TB_6A_H       (REG_SC_GP_CTRL_TB_BASE + 0xD5)
#define  REG_SC_GP_CTRL_TB_6B_L       (REG_SC_GP_CTRL_TB_BASE + 0xD6)
#define  REG_SC_GP_CTRL_TB_6B_H       (REG_SC_GP_CTRL_TB_BASE + 0xD7)
#define  REG_SC_GP_CTRL_TB_6C_L       (REG_SC_GP_CTRL_TB_BASE + 0xD8)
#define  REG_SC_GP_CTRL_TB_6C_H       (REG_SC_GP_CTRL_TB_BASE + 0xD9)
#define  REG_SC_GP_CTRL_TB_6D_L       (REG_SC_GP_CTRL_TB_BASE + 0xDA)
#define  REG_SC_GP_CTRL_TB_6D_H       (REG_SC_GP_CTRL_TB_BASE + 0xDB)
#define  REG_SC_GP_CTRL_TB_6E_L       (REG_SC_GP_CTRL_TB_BASE + 0xDC)
#define  REG_SC_GP_CTRL_TB_6E_H       (REG_SC_GP_CTRL_TB_BASE + 0xDD)
#define  REG_SC_GP_CTRL_TB_6F_L       (REG_SC_GP_CTRL_TB_BASE + 0xDE)
#define  REG_SC_GP_CTRL_TB_6F_H       (REG_SC_GP_CTRL_TB_BASE + 0xDF)
#define  REG_SC_GP_CTRL_TB_70_L       (REG_SC_GP_CTRL_TB_BASE + 0xE0)
#define  REG_SC_GP_CTRL_TB_70_H       (REG_SC_GP_CTRL_TB_BASE + 0xE1)
#define  REG_SC_GP_CTRL_TB_71_L       (REG_SC_GP_CTRL_TB_BASE + 0xE2)
#define  REG_SC_GP_CTRL_TB_71_H       (REG_SC_GP_CTRL_TB_BASE + 0xE3)
#define  REG_SC_GP_CTRL_TB_72_L       (REG_SC_GP_CTRL_TB_BASE + 0xE4)
#define  REG_SC_GP_CTRL_TB_72_H       (REG_SC_GP_CTRL_TB_BASE + 0xE5)
#define  REG_SC_GP_CTRL_TB_73_L       (REG_SC_GP_CTRL_TB_BASE + 0xE6)
#define  REG_SC_GP_CTRL_TB_73_H       (REG_SC_GP_CTRL_TB_BASE + 0xE7)
#define  REG_SC_GP_CTRL_TB_74_L       (REG_SC_GP_CTRL_TB_BASE + 0xE8)
#define  REG_SC_GP_CTRL_TB_74_H       (REG_SC_GP_CTRL_TB_BASE + 0xE9)
#define  REG_SC_GP_CTRL_TB_75_L       (REG_SC_GP_CTRL_TB_BASE + 0xEA)
#define  REG_SC_GP_CTRL_TB_75_H       (REG_SC_GP_CTRL_TB_BASE + 0xEB)
#define  REG_SC_GP_CTRL_TB_76_L       (REG_SC_GP_CTRL_TB_BASE + 0xEC)
#define  REG_SC_GP_CTRL_TB_76_H       (REG_SC_GP_CTRL_TB_BASE + 0xED)
#define  REG_SC_GP_CTRL_TB_77_L       (REG_SC_GP_CTRL_TB_BASE + 0xEE)
#define  REG_SC_GP_CTRL_TB_77_H       (REG_SC_GP_CTRL_TB_BASE + 0xEF)
#define  REG_SC_GP_CTRL_TB_78_L       (REG_SC_GP_CTRL_TB_BASE + 0xF0)
#define  REG_SC_GP_CTRL_TB_78_H       (REG_SC_GP_CTRL_TB_BASE + 0xF1)
#define  REG_SC_GP_CTRL_TB_79_L       (REG_SC_GP_CTRL_TB_BASE + 0xF2)
#define  REG_SC_GP_CTRL_TB_79_H       (REG_SC_GP_CTRL_TB_BASE + 0xF3)
#define  REG_SC_GP_CTRL_TB_7A_L       (REG_SC_GP_CTRL_TB_BASE + 0xF4)
#define  REG_SC_GP_CTRL_TB_7A_H       (REG_SC_GP_CTRL_TB_BASE + 0xF5)
#define  REG_SC_GP_CTRL_TB_7B_L       (REG_SC_GP_CTRL_TB_BASE + 0xF6)
#define  REG_SC_GP_CTRL_TB_7B_H       (REG_SC_GP_CTRL_TB_BASE + 0xF7)
#define  REG_SC_GP_CTRL_TB_7C_L       (REG_SC_GP_CTRL_TB_BASE + 0xF8)
#define  REG_SC_GP_CTRL_TB_7C_H       (REG_SC_GP_CTRL_TB_BASE + 0xF9)
#define  REG_SC_GP_CTRL_TB_7D_L       (REG_SC_GP_CTRL_TB_BASE + 0xFA)
#define  REG_SC_GP_CTRL_TB_7D_H       (REG_SC_GP_CTRL_TB_BASE + 0xFB)
#define  REG_SC_GP_CTRL_TB_7E_L       (REG_SC_GP_CTRL_TB_BASE + 0xFC)
#define  REG_SC_GP_CTRL_TB_7E_H       (REG_SC_GP_CTRL_TB_BASE + 0xFD)
#define  REG_SC_GP_CTRL_TB_7F_L       (REG_SC_GP_CTRL_TB_BASE + 0xFE)
#define  REG_SC_GP_CTRL_TB_7F_H       (REG_SC_GP_CTRL_TB_BASE + 0xFF)

#define  REG_CLKGEN_TB_00_L       (REG_CLKGEN_TB_BASE + 0x00)
#define  REG_CLKGEN_TB_00_H       (REG_CLKGEN_TB_BASE + 0x01)
#define  REG_CLKGEN_TB_01_L       (REG_CLKGEN_TB_BASE + 0x02)
#define  REG_CLKGEN_TB_01_H       (REG_CLKGEN_TB_BASE + 0x03)
#define  REG_CLKGEN_TB_02_L       (REG_CLKGEN_TB_BASE + 0x04)
#define  REG_CLKGEN_TB_02_H       (REG_CLKGEN_TB_BASE + 0x05)
#define  REG_CLKGEN_TB_03_L       (REG_CLKGEN_TB_BASE + 0x06)
#define  REG_CLKGEN_TB_03_H       (REG_CLKGEN_TB_BASE + 0x07)
#define  REG_CLKGEN_TB_04_L       (REG_CLKGEN_TB_BASE + 0x08)
#define  REG_CLKGEN_TB_04_H       (REG_CLKGEN_TB_BASE + 0x09)
#define  REG_CLKGEN_TB_05_L       (REG_CLKGEN_TB_BASE + 0x0A)
#define  REG_CLKGEN_TB_05_H       (REG_CLKGEN_TB_BASE + 0x0B)
#define  REG_CLKGEN_TB_06_L       (REG_CLKGEN_TB_BASE + 0x0C)
#define  REG_CLKGEN_TB_06_H       (REG_CLKGEN_TB_BASE + 0x0D)
#define  REG_CLKGEN_TB_07_L       (REG_CLKGEN_TB_BASE + 0x0E)
#define  REG_CLKGEN_TB_07_H       (REG_CLKGEN_TB_BASE + 0x0F)
#define  REG_CLKGEN_TB_08_L       (REG_CLKGEN_TB_BASE + 0x10)
#define  REG_CLKGEN_TB_08_H       (REG_CLKGEN_TB_BASE + 0x11)
#define  REG_CLKGEN_TB_09_L       (REG_CLKGEN_TB_BASE + 0x12)
#define  REG_CLKGEN_TB_09_H       (REG_CLKGEN_TB_BASE + 0x13)
#define  REG_CLKGEN_TB_0A_L       (REG_CLKGEN_TB_BASE + 0x14)
#define  REG_CLKGEN_TB_0A_H       (REG_CLKGEN_TB_BASE + 0x15)
#define  REG_CLKGEN_TB_0B_L       (REG_CLKGEN_TB_BASE + 0x16)
#define  REG_CLKGEN_TB_0B_H       (REG_CLKGEN_TB_BASE + 0x17)
#define  REG_CLKGEN_TB_0C_L       (REG_CLKGEN_TB_BASE + 0x18)
#define  REG_CLKGEN_TB_0C_H       (REG_CLKGEN_TB_BASE + 0x19)
#define  REG_CLKGEN_TB_0D_L       (REG_CLKGEN_TB_BASE + 0x1A)
#define  REG_CLKGEN_TB_0D_H       (REG_CLKGEN_TB_BASE + 0x1B)
#define  REG_CLKGEN_TB_0E_L       (REG_CLKGEN_TB_BASE + 0x1C)
#define  REG_CLKGEN_TB_0E_H       (REG_CLKGEN_TB_BASE + 0x1D)
#define  REG_CLKGEN_TB_0F_L       (REG_CLKGEN_TB_BASE + 0x1E)
#define  REG_CLKGEN_TB_0F_H       (REG_CLKGEN_TB_BASE + 0x1F)
#define  REG_CLKGEN_TB_10_L       (REG_CLKGEN_TB_BASE + 0x20)
#define  REG_CLKGEN_TB_10_H       (REG_CLKGEN_TB_BASE + 0x21)
#define  REG_CLKGEN_TB_11_L       (REG_CLKGEN_TB_BASE + 0x22)
#define  REG_CLKGEN_TB_11_H       (REG_CLKGEN_TB_BASE + 0x23)
#define  REG_CLKGEN_TB_12_L       (REG_CLKGEN_TB_BASE + 0x24)
#define  REG_CLKGEN_TB_12_H       (REG_CLKGEN_TB_BASE + 0x25)
#define  REG_CLKGEN_TB_13_L       (REG_CLKGEN_TB_BASE + 0x26)
#define  REG_CLKGEN_TB_13_H       (REG_CLKGEN_TB_BASE + 0x27)
#define  REG_CLKGEN_TB_14_L       (REG_CLKGEN_TB_BASE + 0x28)
#define  REG_CLKGEN_TB_14_H       (REG_CLKGEN_TB_BASE + 0x29)
#define  REG_CLKGEN_TB_15_L       (REG_CLKGEN_TB_BASE + 0x2A)
#define  REG_CLKGEN_TB_15_H       (REG_CLKGEN_TB_BASE + 0x2B)
#define  REG_CLKGEN_TB_16_L       (REG_CLKGEN_TB_BASE + 0x2C)
#define  REG_CLKGEN_TB_16_H       (REG_CLKGEN_TB_BASE + 0x2D)
#define  REG_CLKGEN_TB_17_L       (REG_CLKGEN_TB_BASE + 0x2E)
#define  REG_CLKGEN_TB_17_H       (REG_CLKGEN_TB_BASE + 0x2F)
#define  REG_CLKGEN_TB_18_L       (REG_CLKGEN_TB_BASE + 0x30)
#define  REG_CLKGEN_TB_18_H       (REG_CLKGEN_TB_BASE + 0x31)
#define  REG_CLKGEN_TB_19_L       (REG_CLKGEN_TB_BASE + 0x32)
#define  REG_CLKGEN_TB_19_H       (REG_CLKGEN_TB_BASE + 0x33)
#define  REG_CLKGEN_TB_1A_L       (REG_CLKGEN_TB_BASE + 0x34)
#define  REG_CLKGEN_TB_1A_H       (REG_CLKGEN_TB_BASE + 0x35)
#define  REG_CLKGEN_TB_1B_L       (REG_CLKGEN_TB_BASE + 0x36)
#define  REG_CLKGEN_TB_1B_H       (REG_CLKGEN_TB_BASE + 0x37)
#define  REG_CLKGEN_TB_1C_L       (REG_CLKGEN_TB_BASE + 0x38)
#define  REG_CLKGEN_TB_1C_H       (REG_CLKGEN_TB_BASE + 0x39)
#define  REG_CLKGEN_TB_1D_L       (REG_CLKGEN_TB_BASE + 0x3A)
#define  REG_CLKGEN_TB_1D_H       (REG_CLKGEN_TB_BASE + 0x3B)
#define  REG_CLKGEN_TB_1E_L       (REG_CLKGEN_TB_BASE + 0x3C)
#define  REG_CLKGEN_TB_1E_H       (REG_CLKGEN_TB_BASE + 0x3D)
#define  REG_CLKGEN_TB_1F_L       (REG_CLKGEN_TB_BASE + 0x3E)
#define  REG_CLKGEN_TB_1F_H       (REG_CLKGEN_TB_BASE + 0x3F)
#define  REG_CLKGEN_TB_20_L       (REG_CLKGEN_TB_BASE + 0x40)
#define  REG_CLKGEN_TB_20_H       (REG_CLKGEN_TB_BASE + 0x41)
#define  REG_CLKGEN_TB_21_L       (REG_CLKGEN_TB_BASE + 0x42)
#define  REG_CLKGEN_TB_21_H       (REG_CLKGEN_TB_BASE + 0x43)
#define  REG_CLKGEN_TB_22_L       (REG_CLKGEN_TB_BASE + 0x44)
#define  REG_CLKGEN_TB_22_H       (REG_CLKGEN_TB_BASE + 0x45)
#define  REG_CLKGEN_TB_23_L       (REG_CLKGEN_TB_BASE + 0x46)
#define  REG_CLKGEN_TB_23_H       (REG_CLKGEN_TB_BASE + 0x47)
#define  REG_CLKGEN_TB_24_L       (REG_CLKGEN_TB_BASE + 0x48)
#define  REG_CLKGEN_TB_24_H       (REG_CLKGEN_TB_BASE + 0x49)
#define  REG_CLKGEN_TB_25_L       (REG_CLKGEN_TB_BASE + 0x4A)
#define  REG_CLKGEN_TB_25_H       (REG_CLKGEN_TB_BASE + 0x4B)
#define  REG_CLKGEN_TB_26_L       (REG_CLKGEN_TB_BASE + 0x4C)
#define  REG_CLKGEN_TB_26_H       (REG_CLKGEN_TB_BASE + 0x4D)
#define  REG_CLKGEN_TB_27_L       (REG_CLKGEN_TB_BASE + 0x4E)
#define  REG_CLKGEN_TB_27_H       (REG_CLKGEN_TB_BASE + 0x4F)
#define  REG_CLKGEN_TB_28_L       (REG_CLKGEN_TB_BASE + 0x50)
#define  REG_CLKGEN_TB_28_H       (REG_CLKGEN_TB_BASE + 0x51)
#define  REG_CLKGEN_TB_29_L       (REG_CLKGEN_TB_BASE + 0x52)
#define  REG_CLKGEN_TB_29_H       (REG_CLKGEN_TB_BASE + 0x53)
#define  REG_CLKGEN_TB_2A_L       (REG_CLKGEN_TB_BASE + 0x54)
#define  REG_CLKGEN_TB_2A_H       (REG_CLKGEN_TB_BASE + 0x55)
#define  REG_CLKGEN_TB_2B_L       (REG_CLKGEN_TB_BASE + 0x56)
#define  REG_CLKGEN_TB_2B_H       (REG_CLKGEN_TB_BASE + 0x57)
#define  REG_CLKGEN_TB_2C_L       (REG_CLKGEN_TB_BASE + 0x58)
#define  REG_CLKGEN_TB_2C_H       (REG_CLKGEN_TB_BASE + 0x59)
#define  REG_CLKGEN_TB_2D_L       (REG_CLKGEN_TB_BASE + 0x5A)
#define  REG_CLKGEN_TB_2D_H       (REG_CLKGEN_TB_BASE + 0x5B)
#define  REG_CLKGEN_TB_2E_L       (REG_CLKGEN_TB_BASE + 0x5C)
#define  REG_CLKGEN_TB_2E_H       (REG_CLKGEN_TB_BASE + 0x5D)
#define  REG_CLKGEN_TB_2F_L       (REG_CLKGEN_TB_BASE + 0x5E)
#define  REG_CLKGEN_TB_2F_H       (REG_CLKGEN_TB_BASE + 0x5F)
#define  REG_CLKGEN_TB_30_L       (REG_CLKGEN_TB_BASE + 0x60)
#define  REG_CLKGEN_TB_30_H       (REG_CLKGEN_TB_BASE + 0x61)
#define  REG_CLKGEN_TB_31_L       (REG_CLKGEN_TB_BASE + 0x62)
#define  REG_CLKGEN_TB_31_H       (REG_CLKGEN_TB_BASE + 0x63)
#define  REG_CLKGEN_TB_32_L       (REG_CLKGEN_TB_BASE + 0x64)
#define  REG_CLKGEN_TB_32_H       (REG_CLKGEN_TB_BASE + 0x65)
#define  REG_CLKGEN_TB_33_L       (REG_CLKGEN_TB_BASE + 0x66)
#define  REG_CLKGEN_TB_33_H       (REG_CLKGEN_TB_BASE + 0x67)
#define  REG_CLKGEN_TB_34_L       (REG_CLKGEN_TB_BASE + 0x68)
#define  REG_CLKGEN_TB_34_H       (REG_CLKGEN_TB_BASE + 0x69)
#define  REG_CLKGEN_TB_35_L       (REG_CLKGEN_TB_BASE + 0x6A)
#define  REG_CLKGEN_TB_35_H       (REG_CLKGEN_TB_BASE + 0x6B)
#define  REG_CLKGEN_TB_36_L       (REG_CLKGEN_TB_BASE + 0x6C)
#define  REG_CLKGEN_TB_36_H       (REG_CLKGEN_TB_BASE + 0x6D)
#define  REG_CLKGEN_TB_37_L       (REG_CLKGEN_TB_BASE + 0x6E)
#define  REG_CLKGEN_TB_37_H       (REG_CLKGEN_TB_BASE + 0x6F)
#define  REG_CLKGEN_TB_38_L       (REG_CLKGEN_TB_BASE + 0x70)
#define  REG_CLKGEN_TB_38_H       (REG_CLKGEN_TB_BASE + 0x71)
#define  REG_CLKGEN_TB_39_L       (REG_CLKGEN_TB_BASE + 0x72)
#define  REG_CLKGEN_TB_39_H       (REG_CLKGEN_TB_BASE + 0x73)
#define  REG_CLKGEN_TB_3A_L       (REG_CLKGEN_TB_BASE + 0x74)
#define  REG_CLKGEN_TB_3A_H       (REG_CLKGEN_TB_BASE + 0x75)
#define  REG_CLKGEN_TB_3B_L       (REG_CLKGEN_TB_BASE + 0x76)
#define  REG_CLKGEN_TB_3B_H       (REG_CLKGEN_TB_BASE + 0x77)
#define  REG_CLKGEN_TB_3C_L       (REG_CLKGEN_TB_BASE + 0x78)
#define  REG_CLKGEN_TB_3C_H       (REG_CLKGEN_TB_BASE + 0x79)
#define  REG_CLKGEN_TB_3D_L       (REG_CLKGEN_TB_BASE + 0x7A)
#define  REG_CLKGEN_TB_3D_H       (REG_CLKGEN_TB_BASE + 0x7B)
#define  REG_CLKGEN_TB_3E_L       (REG_CLKGEN_TB_BASE + 0x7C)
#define  REG_CLKGEN_TB_3E_H       (REG_CLKGEN_TB_BASE + 0x7D)
#define  REG_CLKGEN_TB_3F_L       (REG_CLKGEN_TB_BASE + 0x7E)
#define  REG_CLKGEN_TB_3F_H       (REG_CLKGEN_TB_BASE + 0x7F)
#define  REG_CLKGEN_TB_40_L       (REG_CLKGEN_TB_BASE + 0x80)
#define  REG_CLKGEN_TB_40_H       (REG_CLKGEN_TB_BASE + 0x81)
#define  REG_CLKGEN_TB_41_L       (REG_CLKGEN_TB_BASE + 0x82)
#define  REG_CLKGEN_TB_41_H       (REG_CLKGEN_TB_BASE + 0x83)
#define  REG_CLKGEN_TB_42_L       (REG_CLKGEN_TB_BASE + 0x84)
#define  REG_CLKGEN_TB_42_H       (REG_CLKGEN_TB_BASE + 0x85)
#define  REG_CLKGEN_TB_43_L       (REG_CLKGEN_TB_BASE + 0x86)
#define  REG_CLKGEN_TB_43_H       (REG_CLKGEN_TB_BASE + 0x87)
#define  REG_CLKGEN_TB_44_L       (REG_CLKGEN_TB_BASE + 0x88)
#define  REG_CLKGEN_TB_44_H       (REG_CLKGEN_TB_BASE + 0x89)
#define  REG_CLKGEN_TB_45_L       (REG_CLKGEN_TB_BASE + 0x8A)
#define  REG_CLKGEN_TB_45_H       (REG_CLKGEN_TB_BASE + 0x8B)
#define  REG_CLKGEN_TB_46_L       (REG_CLKGEN_TB_BASE + 0x8C)
#define  REG_CLKGEN_TB_46_H       (REG_CLKGEN_TB_BASE + 0x8D)
#define  REG_CLKGEN_TB_47_L       (REG_CLKGEN_TB_BASE + 0x8E)
#define  REG_CLKGEN_TB_47_H       (REG_CLKGEN_TB_BASE + 0x8F)
#define  REG_CLKGEN_TB_48_L       (REG_CLKGEN_TB_BASE + 0x90)
#define  REG_CLKGEN_TB_48_H       (REG_CLKGEN_TB_BASE + 0x91)
#define  REG_CLKGEN_TB_49_L       (REG_CLKGEN_TB_BASE + 0x92)
#define  REG_CLKGEN_TB_49_H       (REG_CLKGEN_TB_BASE + 0x93)
#define  REG_CLKGEN_TB_4A_L       (REG_CLKGEN_TB_BASE + 0x94)
#define  REG_CLKGEN_TB_4A_H       (REG_CLKGEN_TB_BASE + 0x95)
#define  REG_CLKGEN_TB_4B_L       (REG_CLKGEN_TB_BASE + 0x96)
#define  REG_CLKGEN_TB_4B_H       (REG_CLKGEN_TB_BASE + 0x97)
#define  REG_CLKGEN_TB_4C_L       (REG_CLKGEN_TB_BASE + 0x98)
#define  REG_CLKGEN_TB_4C_H       (REG_CLKGEN_TB_BASE + 0x99)
#define  REG_CLKGEN_TB_4D_L       (REG_CLKGEN_TB_BASE + 0x9A)
#define  REG_CLKGEN_TB_4D_H       (REG_CLKGEN_TB_BASE + 0x9B)
#define  REG_CLKGEN_TB_4E_L       (REG_CLKGEN_TB_BASE + 0x9C)
#define  REG_CLKGEN_TB_4E_H       (REG_CLKGEN_TB_BASE + 0x9D)
#define  REG_CLKGEN_TB_4F_L       (REG_CLKGEN_TB_BASE + 0x9E)
#define  REG_CLKGEN_TB_4F_H       (REG_CLKGEN_TB_BASE + 0x9F)
#define  REG_CLKGEN_TB_50_L       (REG_CLKGEN_TB_BASE + 0xA0)
#define  REG_CLKGEN_TB_50_H       (REG_CLKGEN_TB_BASE + 0xA1)
#define  REG_CLKGEN_TB_51_L       (REG_CLKGEN_TB_BASE + 0xA2)
#define  REG_CLKGEN_TB_51_H       (REG_CLKGEN_TB_BASE + 0xA3)
#define  REG_CLKGEN_TB_52_L       (REG_CLKGEN_TB_BASE + 0xA4)
#define  REG_CLKGEN_TB_52_H       (REG_CLKGEN_TB_BASE + 0xA5)
#define  REG_CLKGEN_TB_53_L       (REG_CLKGEN_TB_BASE + 0xA6)
#define  REG_CLKGEN_TB_53_H       (REG_CLKGEN_TB_BASE + 0xA7)
#define  REG_CLKGEN_TB_54_L       (REG_CLKGEN_TB_BASE + 0xA8)
#define  REG_CLKGEN_TB_54_H       (REG_CLKGEN_TB_BASE + 0xA9)
#define  REG_CLKGEN_TB_55_L       (REG_CLKGEN_TB_BASE + 0xAA)
#define  REG_CLKGEN_TB_55_H       (REG_CLKGEN_TB_BASE + 0xAB)
#define  REG_CLKGEN_TB_56_L       (REG_CLKGEN_TB_BASE + 0xAC)
#define  REG_CLKGEN_TB_56_H       (REG_CLKGEN_TB_BASE + 0xAD)
#define  REG_CLKGEN_TB_57_L       (REG_CLKGEN_TB_BASE + 0xAE)
#define  REG_CLKGEN_TB_57_H       (REG_CLKGEN_TB_BASE + 0xAF)
#define  REG_CLKGEN_TB_58_L       (REG_CLKGEN_TB_BASE + 0xB0)
#define  REG_CLKGEN_TB_58_H       (REG_CLKGEN_TB_BASE + 0xB1)
#define  REG_CLKGEN_TB_59_L       (REG_CLKGEN_TB_BASE + 0xB2)
#define  REG_CLKGEN_TB_59_H       (REG_CLKGEN_TB_BASE + 0xB3)
#define  REG_CLKGEN_TB_5A_L       (REG_CLKGEN_TB_BASE + 0xB4)
#define  REG_CLKGEN_TB_5A_H       (REG_CLKGEN_TB_BASE + 0xB5)
#define  REG_CLKGEN_TB_5B_L       (REG_CLKGEN_TB_BASE + 0xB6)
#define  REG_CLKGEN_TB_5B_H       (REG_CLKGEN_TB_BASE + 0xB7)
#define  REG_CLKGEN_TB_5C_L       (REG_CLKGEN_TB_BASE + 0xB8)
#define  REG_CLKGEN_TB_5C_H       (REG_CLKGEN_TB_BASE + 0xB9)
#define  REG_CLKGEN_TB_5D_L       (REG_CLKGEN_TB_BASE + 0xBA)
#define  REG_CLKGEN_TB_5D_H       (REG_CLKGEN_TB_BASE + 0xBB)
#define  REG_CLKGEN_TB_5E_L       (REG_CLKGEN_TB_BASE + 0xBC)
#define  REG_CLKGEN_TB_5E_H       (REG_CLKGEN_TB_BASE + 0xBD)
#define  REG_CLKGEN_TB_5F_L       (REG_CLKGEN_TB_BASE + 0xBE)
#define  REG_CLKGEN_TB_5F_H       (REG_CLKGEN_TB_BASE + 0xBF)
#define  REG_CLKGEN_TB_60_L       (REG_CLKGEN_TB_BASE + 0xC0)
#define  REG_CLKGEN_TB_60_H       (REG_CLKGEN_TB_BASE + 0xC1)
#define  REG_CLKGEN_TB_61_L       (REG_CLKGEN_TB_BASE + 0xC2)
#define  REG_CLKGEN_TB_61_H       (REG_CLKGEN_TB_BASE + 0xC3)
#define  REG_CLKGEN_TB_62_L       (REG_CLKGEN_TB_BASE + 0xC4)
#define  REG_CLKGEN_TB_62_H       (REG_CLKGEN_TB_BASE + 0xC5)
#define  REG_CLKGEN_TB_63_L       (REG_CLKGEN_TB_BASE + 0xC6)
#define  REG_CLKGEN_TB_63_H       (REG_CLKGEN_TB_BASE + 0xC7)
#define  REG_CLKGEN_TB_64_L       (REG_CLKGEN_TB_BASE + 0xC8)
#define  REG_CLKGEN_TB_64_H       (REG_CLKGEN_TB_BASE + 0xC9)
#define  REG_CLKGEN_TB_65_L       (REG_CLKGEN_TB_BASE + 0xCA)
#define  REG_CLKGEN_TB_65_H       (REG_CLKGEN_TB_BASE + 0xCB)
#define  REG_CLKGEN_TB_66_L       (REG_CLKGEN_TB_BASE + 0xCC)
#define  REG_CLKGEN_TB_66_H       (REG_CLKGEN_TB_BASE + 0xCD)
#define  REG_CLKGEN_TB_67_L       (REG_CLKGEN_TB_BASE + 0xCE)
#define  REG_CLKGEN_TB_67_H       (REG_CLKGEN_TB_BASE + 0xCF)
#define  REG_CLKGEN_TB_68_L       (REG_CLKGEN_TB_BASE + 0xD0)
#define  REG_CLKGEN_TB_68_H       (REG_CLKGEN_TB_BASE + 0xD1)
#define  REG_CLKGEN_TB_69_L       (REG_CLKGEN_TB_BASE + 0xD2)
#define  REG_CLKGEN_TB_69_H       (REG_CLKGEN_TB_BASE + 0xD3)
#define  REG_CLKGEN_TB_6A_L       (REG_CLKGEN_TB_BASE + 0xD4)
#define  REG_CLKGEN_TB_6A_H       (REG_CLKGEN_TB_BASE + 0xD5)
#define  REG_CLKGEN_TB_6B_L       (REG_CLKGEN_TB_BASE + 0xD6)
#define  REG_CLKGEN_TB_6B_H       (REG_CLKGEN_TB_BASE + 0xD7)
#define  REG_CLKGEN_TB_6C_L       (REG_CLKGEN_TB_BASE + 0xD8)
#define  REG_CLKGEN_TB_6C_H       (REG_CLKGEN_TB_BASE + 0xD9)
#define  REG_CLKGEN_TB_6D_L       (REG_CLKGEN_TB_BASE + 0xDA)
#define  REG_CLKGEN_TB_6D_H       (REG_CLKGEN_TB_BASE + 0xDB)
#define  REG_CLKGEN_TB_6E_L       (REG_CLKGEN_TB_BASE + 0xDC)
#define  REG_CLKGEN_TB_6E_H       (REG_CLKGEN_TB_BASE + 0xDD)
#define  REG_CLKGEN_TB_6F_L       (REG_CLKGEN_TB_BASE + 0xDE)
#define  REG_CLKGEN_TB_6F_H       (REG_CLKGEN_TB_BASE + 0xDF)
#define  REG_CLKGEN_TB_70_L       (REG_CLKGEN_TB_BASE + 0xE0)
#define  REG_CLKGEN_TB_70_H       (REG_CLKGEN_TB_BASE + 0xE1)
#define  REG_CLKGEN_TB_71_L       (REG_CLKGEN_TB_BASE + 0xE2)
#define  REG_CLKGEN_TB_71_H       (REG_CLKGEN_TB_BASE + 0xE3)
#define  REG_CLKGEN_TB_72_L       (REG_CLKGEN_TB_BASE + 0xE4)
#define  REG_CLKGEN_TB_72_H       (REG_CLKGEN_TB_BASE + 0xE5)
#define  REG_CLKGEN_TB_73_L       (REG_CLKGEN_TB_BASE + 0xE6)
#define  REG_CLKGEN_TB_73_H       (REG_CLKGEN_TB_BASE + 0xE7)
#define  REG_CLKGEN_TB_74_L       (REG_CLKGEN_TB_BASE + 0xE8)
#define  REG_CLKGEN_TB_74_H       (REG_CLKGEN_TB_BASE + 0xE9)
#define  REG_CLKGEN_TB_75_L       (REG_CLKGEN_TB_BASE + 0xEA)
#define  REG_CLKGEN_TB_75_H       (REG_CLKGEN_TB_BASE + 0xEB)
#define  REG_CLKGEN_TB_76_L       (REG_CLKGEN_TB_BASE + 0xEC)
#define  REG_CLKGEN_TB_76_H       (REG_CLKGEN_TB_BASE + 0xED)
#define  REG_CLKGEN_TB_77_L       (REG_CLKGEN_TB_BASE + 0xEE)
#define  REG_CLKGEN_TB_77_H       (REG_CLKGEN_TB_BASE + 0xEF)
#define  REG_CLKGEN_TB_78_L       (REG_CLKGEN_TB_BASE + 0xF0)
#define  REG_CLKGEN_TB_78_H       (REG_CLKGEN_TB_BASE + 0xF1)
#define  REG_CLKGEN_TB_79_L       (REG_CLKGEN_TB_BASE + 0xF2)
#define  REG_CLKGEN_TB_79_H       (REG_CLKGEN_TB_BASE + 0xF3)
#define  REG_CLKGEN_TB_7A_L       (REG_CLKGEN_TB_BASE + 0xF4)
#define  REG_CLKGEN_TB_7A_H       (REG_CLKGEN_TB_BASE + 0xF5)
#define  REG_CLKGEN_TB_7B_L       (REG_CLKGEN_TB_BASE + 0xF6)
#define  REG_CLKGEN_TB_7B_H       (REG_CLKGEN_TB_BASE + 0xF7)
#define  REG_CLKGEN_TB_7C_L       (REG_CLKGEN_TB_BASE + 0xF8)
#define  REG_CLKGEN_TB_7C_H       (REG_CLKGEN_TB_BASE + 0xF9)
#define  REG_CLKGEN_TB_7D_L       (REG_CLKGEN_TB_BASE + 0xFA)
#define  REG_CLKGEN_TB_7D_H       (REG_CLKGEN_TB_BASE + 0xFB)
#define  REG_CLKGEN_TB_7E_L       (REG_CLKGEN_TB_BASE + 0xFC)
#define  REG_CLKGEN_TB_7E_H       (REG_CLKGEN_TB_BASE + 0xFD)
#define  REG_CLKGEN_TB_7F_L       (REG_CLKGEN_TB_BASE + 0xFE)
#define  REG_CLKGEN_TB_7F_H       (REG_CLKGEN_TB_BASE + 0xFF)

#define  REG_DISP_TOP_OP2_TB_00_L       (REG_DISP_TOP_OP2_TB_BASE + 0x00)
#define  REG_DISP_TOP_OP2_TB_00_H       (REG_DISP_TOP_OP2_TB_BASE + 0x01)
#define  REG_DISP_TOP_OP2_TB_01_L       (REG_DISP_TOP_OP2_TB_BASE + 0x02)
#define  REG_DISP_TOP_OP2_TB_01_H       (REG_DISP_TOP_OP2_TB_BASE + 0x03)
#define  REG_DISP_TOP_OP2_TB_02_L       (REG_DISP_TOP_OP2_TB_BASE + 0x04)
#define  REG_DISP_TOP_OP2_TB_02_H       (REG_DISP_TOP_OP2_TB_BASE + 0x05)
#define  REG_DISP_TOP_OP2_TB_03_L       (REG_DISP_TOP_OP2_TB_BASE + 0x06)
#define  REG_DISP_TOP_OP2_TB_03_H       (REG_DISP_TOP_OP2_TB_BASE + 0x07)
#define  REG_DISP_TOP_OP2_TB_04_L       (REG_DISP_TOP_OP2_TB_BASE + 0x08)
#define  REG_DISP_TOP_OP2_TB_04_H       (REG_DISP_TOP_OP2_TB_BASE + 0x09)
#define  REG_DISP_TOP_OP2_TB_05_L       (REG_DISP_TOP_OP2_TB_BASE + 0x0A)
#define  REG_DISP_TOP_OP2_TB_05_H       (REG_DISP_TOP_OP2_TB_BASE + 0x0B)
#define  REG_DISP_TOP_OP2_TB_06_L       (REG_DISP_TOP_OP2_TB_BASE + 0x0C)
#define  REG_DISP_TOP_OP2_TB_06_H       (REG_DISP_TOP_OP2_TB_BASE + 0x0D)
#define  REG_DISP_TOP_OP2_TB_07_L       (REG_DISP_TOP_OP2_TB_BASE + 0x0E)
#define  REG_DISP_TOP_OP2_TB_07_H       (REG_DISP_TOP_OP2_TB_BASE + 0x0F)
#define  REG_DISP_TOP_OP2_TB_08_L       (REG_DISP_TOP_OP2_TB_BASE + 0x10)
#define  REG_DISP_TOP_OP2_TB_08_H       (REG_DISP_TOP_OP2_TB_BASE + 0x11)
#define  REG_DISP_TOP_OP2_TB_09_L       (REG_DISP_TOP_OP2_TB_BASE + 0x12)
#define  REG_DISP_TOP_OP2_TB_09_H       (REG_DISP_TOP_OP2_TB_BASE + 0x13)
#define  REG_DISP_TOP_OP2_TB_0A_L       (REG_DISP_TOP_OP2_TB_BASE + 0x14)
#define  REG_DISP_TOP_OP2_TB_0A_H       (REG_DISP_TOP_OP2_TB_BASE + 0x15)
#define  REG_DISP_TOP_OP2_TB_0B_L       (REG_DISP_TOP_OP2_TB_BASE + 0x16)
#define  REG_DISP_TOP_OP2_TB_0B_H       (REG_DISP_TOP_OP2_TB_BASE + 0x17)
#define  REG_DISP_TOP_OP2_TB_0C_L       (REG_DISP_TOP_OP2_TB_BASE + 0x18)
#define  REG_DISP_TOP_OP2_TB_0C_H       (REG_DISP_TOP_OP2_TB_BASE + 0x19)
#define  REG_DISP_TOP_OP2_TB_0D_L       (REG_DISP_TOP_OP2_TB_BASE + 0x1A)
#define  REG_DISP_TOP_OP2_TB_0D_H       (REG_DISP_TOP_OP2_TB_BASE + 0x1B)
#define  REG_DISP_TOP_OP2_TB_0E_L       (REG_DISP_TOP_OP2_TB_BASE + 0x1C)
#define  REG_DISP_TOP_OP2_TB_0E_H       (REG_DISP_TOP_OP2_TB_BASE + 0x1D)
#define  REG_DISP_TOP_OP2_TB_0F_L       (REG_DISP_TOP_OP2_TB_BASE + 0x1E)
#define  REG_DISP_TOP_OP2_TB_0F_H       (REG_DISP_TOP_OP2_TB_BASE + 0x1F)
#define  REG_DISP_TOP_OP2_TB_10_L       (REG_DISP_TOP_OP2_TB_BASE + 0x20)
#define  REG_DISP_TOP_OP2_TB_10_H       (REG_DISP_TOP_OP2_TB_BASE + 0x21)
#define  REG_DISP_TOP_OP2_TB_11_L       (REG_DISP_TOP_OP2_TB_BASE + 0x22)
#define  REG_DISP_TOP_OP2_TB_11_H       (REG_DISP_TOP_OP2_TB_BASE + 0x23)
#define  REG_DISP_TOP_OP2_TB_12_L       (REG_DISP_TOP_OP2_TB_BASE + 0x24)
#define  REG_DISP_TOP_OP2_TB_12_H       (REG_DISP_TOP_OP2_TB_BASE + 0x25)
#define  REG_DISP_TOP_OP2_TB_13_L       (REG_DISP_TOP_OP2_TB_BASE + 0x26)
#define  REG_DISP_TOP_OP2_TB_13_H       (REG_DISP_TOP_OP2_TB_BASE + 0x27)
#define  REG_DISP_TOP_OP2_TB_14_L       (REG_DISP_TOP_OP2_TB_BASE + 0x28)
#define  REG_DISP_TOP_OP2_TB_14_H       (REG_DISP_TOP_OP2_TB_BASE + 0x29)
#define  REG_DISP_TOP_OP2_TB_15_L       (REG_DISP_TOP_OP2_TB_BASE + 0x2A)
#define  REG_DISP_TOP_OP2_TB_15_H       (REG_DISP_TOP_OP2_TB_BASE + 0x2B)
#define  REG_DISP_TOP_OP2_TB_16_L       (REG_DISP_TOP_OP2_TB_BASE + 0x2C)
#define  REG_DISP_TOP_OP2_TB_16_H       (REG_DISP_TOP_OP2_TB_BASE + 0x2D)
#define  REG_DISP_TOP_OP2_TB_17_L       (REG_DISP_TOP_OP2_TB_BASE + 0x2E)
#define  REG_DISP_TOP_OP2_TB_17_H       (REG_DISP_TOP_OP2_TB_BASE + 0x2F)
#define  REG_DISP_TOP_OP2_TB_18_L       (REG_DISP_TOP_OP2_TB_BASE + 0x30)
#define  REG_DISP_TOP_OP2_TB_18_H       (REG_DISP_TOP_OP2_TB_BASE + 0x31)
#define  REG_DISP_TOP_OP2_TB_19_L       (REG_DISP_TOP_OP2_TB_BASE + 0x32)
#define  REG_DISP_TOP_OP2_TB_19_H       (REG_DISP_TOP_OP2_TB_BASE + 0x33)
#define  REG_DISP_TOP_OP2_TB_1A_L       (REG_DISP_TOP_OP2_TB_BASE + 0x34)
#define  REG_DISP_TOP_OP2_TB_1A_H       (REG_DISP_TOP_OP2_TB_BASE + 0x35)
#define  REG_DISP_TOP_OP2_TB_1B_L       (REG_DISP_TOP_OP2_TB_BASE + 0x36)
#define  REG_DISP_TOP_OP2_TB_1B_H       (REG_DISP_TOP_OP2_TB_BASE + 0x37)
#define  REG_DISP_TOP_OP2_TB_1C_L       (REG_DISP_TOP_OP2_TB_BASE + 0x38)
#define  REG_DISP_TOP_OP2_TB_1C_H       (REG_DISP_TOP_OP2_TB_BASE + 0x39)
#define  REG_DISP_TOP_OP2_TB_1D_L       (REG_DISP_TOP_OP2_TB_BASE + 0x3A)
#define  REG_DISP_TOP_OP2_TB_1D_H       (REG_DISP_TOP_OP2_TB_BASE + 0x3B)
#define  REG_DISP_TOP_OP2_TB_1E_L       (REG_DISP_TOP_OP2_TB_BASE + 0x3C)
#define  REG_DISP_TOP_OP2_TB_1E_H       (REG_DISP_TOP_OP2_TB_BASE + 0x3D)
#define  REG_DISP_TOP_OP2_TB_1F_L       (REG_DISP_TOP_OP2_TB_BASE + 0x3E)
#define  REG_DISP_TOP_OP2_TB_1F_H       (REG_DISP_TOP_OP2_TB_BASE + 0x3F)
#define  REG_DISP_TOP_OP2_TB_20_L       (REG_DISP_TOP_OP2_TB_BASE + 0x40)
#define  REG_DISP_TOP_OP2_TB_20_H       (REG_DISP_TOP_OP2_TB_BASE + 0x41)
#define  REG_DISP_TOP_OP2_TB_21_L       (REG_DISP_TOP_OP2_TB_BASE + 0x42)
#define  REG_DISP_TOP_OP2_TB_21_H       (REG_DISP_TOP_OP2_TB_BASE + 0x43)
#define  REG_DISP_TOP_OP2_TB_22_L       (REG_DISP_TOP_OP2_TB_BASE + 0x44)
#define  REG_DISP_TOP_OP2_TB_22_H       (REG_DISP_TOP_OP2_TB_BASE + 0x45)
#define  REG_DISP_TOP_OP2_TB_23_L       (REG_DISP_TOP_OP2_TB_BASE + 0x46)
#define  REG_DISP_TOP_OP2_TB_23_H       (REG_DISP_TOP_OP2_TB_BASE + 0x47)
#define  REG_DISP_TOP_OP2_TB_24_L       (REG_DISP_TOP_OP2_TB_BASE + 0x48)
#define  REG_DISP_TOP_OP2_TB_24_H       (REG_DISP_TOP_OP2_TB_BASE + 0x49)
#define  REG_DISP_TOP_OP2_TB_25_L       (REG_DISP_TOP_OP2_TB_BASE + 0x4A)
#define  REG_DISP_TOP_OP2_TB_25_H       (REG_DISP_TOP_OP2_TB_BASE + 0x4B)
#define  REG_DISP_TOP_OP2_TB_26_L       (REG_DISP_TOP_OP2_TB_BASE + 0x4C)
#define  REG_DISP_TOP_OP2_TB_26_H       (REG_DISP_TOP_OP2_TB_BASE + 0x4D)
#define  REG_DISP_TOP_OP2_TB_27_L       (REG_DISP_TOP_OP2_TB_BASE + 0x4E)
#define  REG_DISP_TOP_OP2_TB_27_H       (REG_DISP_TOP_OP2_TB_BASE + 0x4F)
#define  REG_DISP_TOP_OP2_TB_28_L       (REG_DISP_TOP_OP2_TB_BASE + 0x50)
#define  REG_DISP_TOP_OP2_TB_28_H       (REG_DISP_TOP_OP2_TB_BASE + 0x51)
#define  REG_DISP_TOP_OP2_TB_29_L       (REG_DISP_TOP_OP2_TB_BASE + 0x52)
#define  REG_DISP_TOP_OP2_TB_29_H       (REG_DISP_TOP_OP2_TB_BASE + 0x53)
#define  REG_DISP_TOP_OP2_TB_2A_L       (REG_DISP_TOP_OP2_TB_BASE + 0x54)
#define  REG_DISP_TOP_OP2_TB_2A_H       (REG_DISP_TOP_OP2_TB_BASE + 0x55)
#define  REG_DISP_TOP_OP2_TB_2B_L       (REG_DISP_TOP_OP2_TB_BASE + 0x56)
#define  REG_DISP_TOP_OP2_TB_2B_H       (REG_DISP_TOP_OP2_TB_BASE + 0x57)
#define  REG_DISP_TOP_OP2_TB_2C_L       (REG_DISP_TOP_OP2_TB_BASE + 0x58)
#define  REG_DISP_TOP_OP2_TB_2C_H       (REG_DISP_TOP_OP2_TB_BASE + 0x59)
#define  REG_DISP_TOP_OP2_TB_2D_L       (REG_DISP_TOP_OP2_TB_BASE + 0x5A)
#define  REG_DISP_TOP_OP2_TB_2D_H       (REG_DISP_TOP_OP2_TB_BASE + 0x5B)
#define  REG_DISP_TOP_OP2_TB_2E_L       (REG_DISP_TOP_OP2_TB_BASE + 0x5C)
#define  REG_DISP_TOP_OP2_TB_2E_H       (REG_DISP_TOP_OP2_TB_BASE + 0x5D)
#define  REG_DISP_TOP_OP2_TB_2F_L       (REG_DISP_TOP_OP2_TB_BASE + 0x5E)
#define  REG_DISP_TOP_OP2_TB_2F_H       (REG_DISP_TOP_OP2_TB_BASE + 0x5F)
#define  REG_DISP_TOP_OP2_TB_30_L       (REG_DISP_TOP_OP2_TB_BASE + 0x60)
#define  REG_DISP_TOP_OP2_TB_30_H       (REG_DISP_TOP_OP2_TB_BASE + 0x61)
#define  REG_DISP_TOP_OP2_TB_31_L       (REG_DISP_TOP_OP2_TB_BASE + 0x62)
#define  REG_DISP_TOP_OP2_TB_31_H       (REG_DISP_TOP_OP2_TB_BASE + 0x63)
#define  REG_DISP_TOP_OP2_TB_32_L       (REG_DISP_TOP_OP2_TB_BASE + 0x64)
#define  REG_DISP_TOP_OP2_TB_32_H       (REG_DISP_TOP_OP2_TB_BASE + 0x65)
#define  REG_DISP_TOP_OP2_TB_33_L       (REG_DISP_TOP_OP2_TB_BASE + 0x66)
#define  REG_DISP_TOP_OP2_TB_33_H       (REG_DISP_TOP_OP2_TB_BASE + 0x67)
#define  REG_DISP_TOP_OP2_TB_34_L       (REG_DISP_TOP_OP2_TB_BASE + 0x68)
#define  REG_DISP_TOP_OP2_TB_34_H       (REG_DISP_TOP_OP2_TB_BASE + 0x69)
#define  REG_DISP_TOP_OP2_TB_35_L       (REG_DISP_TOP_OP2_TB_BASE + 0x6A)
#define  REG_DISP_TOP_OP2_TB_35_H       (REG_DISP_TOP_OP2_TB_BASE + 0x6B)
#define  REG_DISP_TOP_OP2_TB_36_L       (REG_DISP_TOP_OP2_TB_BASE + 0x6C)
#define  REG_DISP_TOP_OP2_TB_36_H       (REG_DISP_TOP_OP2_TB_BASE + 0x6D)
#define  REG_DISP_TOP_OP2_TB_37_L       (REG_DISP_TOP_OP2_TB_BASE + 0x6E)
#define  REG_DISP_TOP_OP2_TB_37_H       (REG_DISP_TOP_OP2_TB_BASE + 0x6F)
#define  REG_DISP_TOP_OP2_TB_38_L       (REG_DISP_TOP_OP2_TB_BASE + 0x70)
#define  REG_DISP_TOP_OP2_TB_38_H       (REG_DISP_TOP_OP2_TB_BASE + 0x71)
#define  REG_DISP_TOP_OP2_TB_39_L       (REG_DISP_TOP_OP2_TB_BASE + 0x72)
#define  REG_DISP_TOP_OP2_TB_39_H       (REG_DISP_TOP_OP2_TB_BASE + 0x73)
#define  REG_DISP_TOP_OP2_TB_3A_L       (REG_DISP_TOP_OP2_TB_BASE + 0x74)
#define  REG_DISP_TOP_OP2_TB_3A_H       (REG_DISP_TOP_OP2_TB_BASE + 0x75)
#define  REG_DISP_TOP_OP2_TB_3B_L       (REG_DISP_TOP_OP2_TB_BASE + 0x76)
#define  REG_DISP_TOP_OP2_TB_3B_H       (REG_DISP_TOP_OP2_TB_BASE + 0x77)
#define  REG_DISP_TOP_OP2_TB_3C_L       (REG_DISP_TOP_OP2_TB_BASE + 0x78)
#define  REG_DISP_TOP_OP2_TB_3C_H       (REG_DISP_TOP_OP2_TB_BASE + 0x79)
#define  REG_DISP_TOP_OP2_TB_3D_L       (REG_DISP_TOP_OP2_TB_BASE + 0x7A)
#define  REG_DISP_TOP_OP2_TB_3D_H       (REG_DISP_TOP_OP2_TB_BASE + 0x7B)
#define  REG_DISP_TOP_OP2_TB_3E_L       (REG_DISP_TOP_OP2_TB_BASE + 0x7C)
#define  REG_DISP_TOP_OP2_TB_3E_H       (REG_DISP_TOP_OP2_TB_BASE + 0x7D)
#define  REG_DISP_TOP_OP2_TB_3F_L       (REG_DISP_TOP_OP2_TB_BASE + 0x7E)
#define  REG_DISP_TOP_OP2_TB_3F_H       (REG_DISP_TOP_OP2_TB_BASE + 0x7F)
#define  REG_DISP_TOP_OP2_TB_40_L       (REG_DISP_TOP_OP2_TB_BASE + 0x80)
#define  REG_DISP_TOP_OP2_TB_40_H       (REG_DISP_TOP_OP2_TB_BASE + 0x81)
#define  REG_DISP_TOP_OP2_TB_41_L       (REG_DISP_TOP_OP2_TB_BASE + 0x82)
#define  REG_DISP_TOP_OP2_TB_41_H       (REG_DISP_TOP_OP2_TB_BASE + 0x83)
#define  REG_DISP_TOP_OP2_TB_42_L       (REG_DISP_TOP_OP2_TB_BASE + 0x84)
#define  REG_DISP_TOP_OP2_TB_42_H       (REG_DISP_TOP_OP2_TB_BASE + 0x85)
#define  REG_DISP_TOP_OP2_TB_43_L       (REG_DISP_TOP_OP2_TB_BASE + 0x86)
#define  REG_DISP_TOP_OP2_TB_43_H       (REG_DISP_TOP_OP2_TB_BASE + 0x87)
#define  REG_DISP_TOP_OP2_TB_44_L       (REG_DISP_TOP_OP2_TB_BASE + 0x88)
#define  REG_DISP_TOP_OP2_TB_44_H       (REG_DISP_TOP_OP2_TB_BASE + 0x89)
#define  REG_DISP_TOP_OP2_TB_45_L       (REG_DISP_TOP_OP2_TB_BASE + 0x8A)
#define  REG_DISP_TOP_OP2_TB_45_H       (REG_DISP_TOP_OP2_TB_BASE + 0x8B)
#define  REG_DISP_TOP_OP2_TB_46_L       (REG_DISP_TOP_OP2_TB_BASE + 0x8C)
#define  REG_DISP_TOP_OP2_TB_46_H       (REG_DISP_TOP_OP2_TB_BASE + 0x8D)
#define  REG_DISP_TOP_OP2_TB_47_L       (REG_DISP_TOP_OP2_TB_BASE + 0x8E)
#define  REG_DISP_TOP_OP2_TB_47_H       (REG_DISP_TOP_OP2_TB_BASE + 0x8F)
#define  REG_DISP_TOP_OP2_TB_48_L       (REG_DISP_TOP_OP2_TB_BASE + 0x90)
#define  REG_DISP_TOP_OP2_TB_48_H       (REG_DISP_TOP_OP2_TB_BASE + 0x91)
#define  REG_DISP_TOP_OP2_TB_49_L       (REG_DISP_TOP_OP2_TB_BASE + 0x92)
#define  REG_DISP_TOP_OP2_TB_49_H       (REG_DISP_TOP_OP2_TB_BASE + 0x93)
#define  REG_DISP_TOP_OP2_TB_4A_L       (REG_DISP_TOP_OP2_TB_BASE + 0x94)
#define  REG_DISP_TOP_OP2_TB_4A_H       (REG_DISP_TOP_OP2_TB_BASE + 0x95)
#define  REG_DISP_TOP_OP2_TB_4B_L       (REG_DISP_TOP_OP2_TB_BASE + 0x96)
#define  REG_DISP_TOP_OP2_TB_4B_H       (REG_DISP_TOP_OP2_TB_BASE + 0x97)
#define  REG_DISP_TOP_OP2_TB_4C_L       (REG_DISP_TOP_OP2_TB_BASE + 0x98)
#define  REG_DISP_TOP_OP2_TB_4C_H       (REG_DISP_TOP_OP2_TB_BASE + 0x99)
#define  REG_DISP_TOP_OP2_TB_4D_L       (REG_DISP_TOP_OP2_TB_BASE + 0x9A)
#define  REG_DISP_TOP_OP2_TB_4D_H       (REG_DISP_TOP_OP2_TB_BASE + 0x9B)
#define  REG_DISP_TOP_OP2_TB_4E_L       (REG_DISP_TOP_OP2_TB_BASE + 0x9C)
#define  REG_DISP_TOP_OP2_TB_4E_H       (REG_DISP_TOP_OP2_TB_BASE + 0x9D)
#define  REG_DISP_TOP_OP2_TB_4F_L       (REG_DISP_TOP_OP2_TB_BASE + 0x9E)
#define  REG_DISP_TOP_OP2_TB_4F_H       (REG_DISP_TOP_OP2_TB_BASE + 0x9F)
#define  REG_DISP_TOP_OP2_TB_50_L       (REG_DISP_TOP_OP2_TB_BASE + 0xA0)
#define  REG_DISP_TOP_OP2_TB_50_H       (REG_DISP_TOP_OP2_TB_BASE + 0xA1)
#define  REG_DISP_TOP_OP2_TB_51_L       (REG_DISP_TOP_OP2_TB_BASE + 0xA2)
#define  REG_DISP_TOP_OP2_TB_51_H       (REG_DISP_TOP_OP2_TB_BASE + 0xA3)
#define  REG_DISP_TOP_OP2_TB_52_L       (REG_DISP_TOP_OP2_TB_BASE + 0xA4)
#define  REG_DISP_TOP_OP2_TB_52_H       (REG_DISP_TOP_OP2_TB_BASE + 0xA5)
#define  REG_DISP_TOP_OP2_TB_53_L       (REG_DISP_TOP_OP2_TB_BASE + 0xA6)
#define  REG_DISP_TOP_OP2_TB_53_H       (REG_DISP_TOP_OP2_TB_BASE + 0xA7)
#define  REG_DISP_TOP_OP2_TB_54_L       (REG_DISP_TOP_OP2_TB_BASE + 0xA8)
#define  REG_DISP_TOP_OP2_TB_54_H       (REG_DISP_TOP_OP2_TB_BASE + 0xA9)
#define  REG_DISP_TOP_OP2_TB_55_L       (REG_DISP_TOP_OP2_TB_BASE + 0xAA)
#define  REG_DISP_TOP_OP2_TB_55_H       (REG_DISP_TOP_OP2_TB_BASE + 0xAB)
#define  REG_DISP_TOP_OP2_TB_56_L       (REG_DISP_TOP_OP2_TB_BASE + 0xAC)
#define  REG_DISP_TOP_OP2_TB_56_H       (REG_DISP_TOP_OP2_TB_BASE + 0xAD)
#define  REG_DISP_TOP_OP2_TB_57_L       (REG_DISP_TOP_OP2_TB_BASE + 0xAE)
#define  REG_DISP_TOP_OP2_TB_57_H       (REG_DISP_TOP_OP2_TB_BASE + 0xAF)
#define  REG_DISP_TOP_OP2_TB_58_L       (REG_DISP_TOP_OP2_TB_BASE + 0xB0)
#define  REG_DISP_TOP_OP2_TB_58_H       (REG_DISP_TOP_OP2_TB_BASE + 0xB1)
#define  REG_DISP_TOP_OP2_TB_59_L       (REG_DISP_TOP_OP2_TB_BASE + 0xB2)
#define  REG_DISP_TOP_OP2_TB_59_H       (REG_DISP_TOP_OP2_TB_BASE + 0xB3)
#define  REG_DISP_TOP_OP2_TB_5A_L       (REG_DISP_TOP_OP2_TB_BASE + 0xB4)
#define  REG_DISP_TOP_OP2_TB_5A_H       (REG_DISP_TOP_OP2_TB_BASE + 0xB5)
#define  REG_DISP_TOP_OP2_TB_5B_L       (REG_DISP_TOP_OP2_TB_BASE + 0xB6)
#define  REG_DISP_TOP_OP2_TB_5B_H       (REG_DISP_TOP_OP2_TB_BASE + 0xB7)
#define  REG_DISP_TOP_OP2_TB_5C_L       (REG_DISP_TOP_OP2_TB_BASE + 0xB8)
#define  REG_DISP_TOP_OP2_TB_5C_H       (REG_DISP_TOP_OP2_TB_BASE + 0xB9)
#define  REG_DISP_TOP_OP2_TB_5D_L       (REG_DISP_TOP_OP2_TB_BASE + 0xBA)
#define  REG_DISP_TOP_OP2_TB_5D_H       (REG_DISP_TOP_OP2_TB_BASE + 0xBB)
#define  REG_DISP_TOP_OP2_TB_5E_L       (REG_DISP_TOP_OP2_TB_BASE + 0xBC)
#define  REG_DISP_TOP_OP2_TB_5E_H       (REG_DISP_TOP_OP2_TB_BASE + 0xBD)
#define  REG_DISP_TOP_OP2_TB_5F_L       (REG_DISP_TOP_OP2_TB_BASE + 0xBE)
#define  REG_DISP_TOP_OP2_TB_5F_H       (REG_DISP_TOP_OP2_TB_BASE + 0xBF)
#define  REG_DISP_TOP_OP2_TB_60_L       (REG_DISP_TOP_OP2_TB_BASE + 0xC0)
#define  REG_DISP_TOP_OP2_TB_60_H       (REG_DISP_TOP_OP2_TB_BASE + 0xC1)
#define  REG_DISP_TOP_OP2_TB_61_L       (REG_DISP_TOP_OP2_TB_BASE + 0xC2)
#define  REG_DISP_TOP_OP2_TB_61_H       (REG_DISP_TOP_OP2_TB_BASE + 0xC3)
#define  REG_DISP_TOP_OP2_TB_62_L       (REG_DISP_TOP_OP2_TB_BASE + 0xC4)
#define  REG_DISP_TOP_OP2_TB_62_H       (REG_DISP_TOP_OP2_TB_BASE + 0xC5)
#define  REG_DISP_TOP_OP2_TB_63_L       (REG_DISP_TOP_OP2_TB_BASE + 0xC6)
#define  REG_DISP_TOP_OP2_TB_63_H       (REG_DISP_TOP_OP2_TB_BASE + 0xC7)
#define  REG_DISP_TOP_OP2_TB_64_L       (REG_DISP_TOP_OP2_TB_BASE + 0xC8)
#define  REG_DISP_TOP_OP2_TB_64_H       (REG_DISP_TOP_OP2_TB_BASE + 0xC9)
#define  REG_DISP_TOP_OP2_TB_65_L       (REG_DISP_TOP_OP2_TB_BASE + 0xCA)
#define  REG_DISP_TOP_OP2_TB_65_H       (REG_DISP_TOP_OP2_TB_BASE + 0xCB)
#define  REG_DISP_TOP_OP2_TB_66_L       (REG_DISP_TOP_OP2_TB_BASE + 0xCC)
#define  REG_DISP_TOP_OP2_TB_66_H       (REG_DISP_TOP_OP2_TB_BASE + 0xCD)
#define  REG_DISP_TOP_OP2_TB_67_L       (REG_DISP_TOP_OP2_TB_BASE + 0xCE)
#define  REG_DISP_TOP_OP2_TB_67_H       (REG_DISP_TOP_OP2_TB_BASE + 0xCF)
#define  REG_DISP_TOP_OP2_TB_68_L       (REG_DISP_TOP_OP2_TB_BASE + 0xD0)
#define  REG_DISP_TOP_OP2_TB_68_H       (REG_DISP_TOP_OP2_TB_BASE + 0xD1)
#define  REG_DISP_TOP_OP2_TB_69_L       (REG_DISP_TOP_OP2_TB_BASE + 0xD2)
#define  REG_DISP_TOP_OP2_TB_69_H       (REG_DISP_TOP_OP2_TB_BASE + 0xD3)
#define  REG_DISP_TOP_OP2_TB_6A_L       (REG_DISP_TOP_OP2_TB_BASE + 0xD4)
#define  REG_DISP_TOP_OP2_TB_6A_H       (REG_DISP_TOP_OP2_TB_BASE + 0xD5)
#define  REG_DISP_TOP_OP2_TB_6B_L       (REG_DISP_TOP_OP2_TB_BASE + 0xD6)
#define  REG_DISP_TOP_OP2_TB_6B_H       (REG_DISP_TOP_OP2_TB_BASE + 0xD7)
#define  REG_DISP_TOP_OP2_TB_6C_L       (REG_DISP_TOP_OP2_TB_BASE + 0xD8)
#define  REG_DISP_TOP_OP2_TB_6C_H       (REG_DISP_TOP_OP2_TB_BASE + 0xD9)
#define  REG_DISP_TOP_OP2_TB_6D_L       (REG_DISP_TOP_OP2_TB_BASE + 0xDA)
#define  REG_DISP_TOP_OP2_TB_6D_H       (REG_DISP_TOP_OP2_TB_BASE + 0xDB)
#define  REG_DISP_TOP_OP2_TB_6E_L       (REG_DISP_TOP_OP2_TB_BASE + 0xDC)
#define  REG_DISP_TOP_OP2_TB_6E_H       (REG_DISP_TOP_OP2_TB_BASE + 0xDD)
#define  REG_DISP_TOP_OP2_TB_6F_L       (REG_DISP_TOP_OP2_TB_BASE + 0xDE)
#define  REG_DISP_TOP_OP2_TB_6F_H       (REG_DISP_TOP_OP2_TB_BASE + 0xDF)
#define  REG_DISP_TOP_OP2_TB_70_L       (REG_DISP_TOP_OP2_TB_BASE + 0xE0)
#define  REG_DISP_TOP_OP2_TB_70_H       (REG_DISP_TOP_OP2_TB_BASE + 0xE1)
#define  REG_DISP_TOP_OP2_TB_71_L       (REG_DISP_TOP_OP2_TB_BASE + 0xE2)
#define  REG_DISP_TOP_OP2_TB_71_H       (REG_DISP_TOP_OP2_TB_BASE + 0xE3)
#define  REG_DISP_TOP_OP2_TB_72_L       (REG_DISP_TOP_OP2_TB_BASE + 0xE4)
#define  REG_DISP_TOP_OP2_TB_72_H       (REG_DISP_TOP_OP2_TB_BASE + 0xE5)
#define  REG_DISP_TOP_OP2_TB_73_L       (REG_DISP_TOP_OP2_TB_BASE + 0xE6)
#define  REG_DISP_TOP_OP2_TB_73_H       (REG_DISP_TOP_OP2_TB_BASE + 0xE7)
#define  REG_DISP_TOP_OP2_TB_74_L       (REG_DISP_TOP_OP2_TB_BASE + 0xE8)
#define  REG_DISP_TOP_OP2_TB_74_H       (REG_DISP_TOP_OP2_TB_BASE + 0xE9)
#define  REG_DISP_TOP_OP2_TB_75_L       (REG_DISP_TOP_OP2_TB_BASE + 0xEA)
#define  REG_DISP_TOP_OP2_TB_75_H       (REG_DISP_TOP_OP2_TB_BASE + 0xEB)
#define  REG_DISP_TOP_OP2_TB_76_L       (REG_DISP_TOP_OP2_TB_BASE + 0xEC)
#define  REG_DISP_TOP_OP2_TB_76_H       (REG_DISP_TOP_OP2_TB_BASE + 0xED)
#define  REG_DISP_TOP_OP2_TB_77_L       (REG_DISP_TOP_OP2_TB_BASE + 0xEE)
#define  REG_DISP_TOP_OP2_TB_77_H       (REG_DISP_TOP_OP2_TB_BASE + 0xEF)
#define  REG_DISP_TOP_OP2_TB_78_L       (REG_DISP_TOP_OP2_TB_BASE + 0xF0)
#define  REG_DISP_TOP_OP2_TB_78_H       (REG_DISP_TOP_OP2_TB_BASE + 0xF1)
#define  REG_DISP_TOP_OP2_TB_79_L       (REG_DISP_TOP_OP2_TB_BASE + 0xF2)
#define  REG_DISP_TOP_OP2_TB_79_H       (REG_DISP_TOP_OP2_TB_BASE + 0xF3)
#define  REG_DISP_TOP_OP2_TB_7A_L       (REG_DISP_TOP_OP2_TB_BASE + 0xF4)
#define  REG_DISP_TOP_OP2_TB_7A_H       (REG_DISP_TOP_OP2_TB_BASE + 0xF5)
#define  REG_DISP_TOP_OP2_TB_7B_L       (REG_DISP_TOP_OP2_TB_BASE + 0xF6)
#define  REG_DISP_TOP_OP2_TB_7B_H       (REG_DISP_TOP_OP2_TB_BASE + 0xF7)
#define  REG_DISP_TOP_OP2_TB_7C_L       (REG_DISP_TOP_OP2_TB_BASE + 0xF8)
#define  REG_DISP_TOP_OP2_TB_7C_H       (REG_DISP_TOP_OP2_TB_BASE + 0xF9)
#define  REG_DISP_TOP_OP2_TB_7D_L       (REG_DISP_TOP_OP2_TB_BASE + 0xFA)
#define  REG_DISP_TOP_OP2_TB_7D_H       (REG_DISP_TOP_OP2_TB_BASE + 0xFB)
#define  REG_DISP_TOP_OP2_TB_7E_L       (REG_DISP_TOP_OP2_TB_BASE + 0xFC)
#define  REG_DISP_TOP_OP2_TB_7E_H       (REG_DISP_TOP_OP2_TB_BASE + 0xFD)
#define  REG_DISP_TOP_OP2_TB_7F_L       (REG_DISP_TOP_OP2_TB_BASE + 0xFE)
#define  REG_DISP_TOP_OP2_TB_7F_H       (REG_DISP_TOP_OP2_TB_BASE + 0xFF)

#define  REG_CHIP_TOP_TB_00_L       (REG_CHIP_TOP_TB_BASE + 0x00)
#define  REG_CHIP_TOP_TB_00_H       (REG_CHIP_TOP_TB_BASE + 0x01)
#define  REG_CHIP_TOP_TB_01_L       (REG_CHIP_TOP_TB_BASE + 0x02)
#define  REG_CHIP_TOP_TB_01_H       (REG_CHIP_TOP_TB_BASE + 0x03)
#define  REG_CHIP_TOP_TB_02_L       (REG_CHIP_TOP_TB_BASE + 0x04)
#define  REG_CHIP_TOP_TB_02_H       (REG_CHIP_TOP_TB_BASE + 0x05)
#define  REG_CHIP_TOP_TB_03_L       (REG_CHIP_TOP_TB_BASE + 0x06)
#define  REG_CHIP_TOP_TB_03_H       (REG_CHIP_TOP_TB_BASE + 0x07)
#define  REG_CHIP_TOP_TB_04_L       (REG_CHIP_TOP_TB_BASE + 0x08)
#define  REG_CHIP_TOP_TB_04_H       (REG_CHIP_TOP_TB_BASE + 0x09)
#define  REG_CHIP_TOP_TB_05_L       (REG_CHIP_TOP_TB_BASE + 0x0A)
#define  REG_CHIP_TOP_TB_05_H       (REG_CHIP_TOP_TB_BASE + 0x0B)
#define  REG_CHIP_TOP_TB_06_L       (REG_CHIP_TOP_TB_BASE + 0x0C)
#define  REG_CHIP_TOP_TB_06_H       (REG_CHIP_TOP_TB_BASE + 0x0D)
#define  REG_CHIP_TOP_TB_07_L       (REG_CHIP_TOP_TB_BASE + 0x0E)
#define  REG_CHIP_TOP_TB_07_H       (REG_CHIP_TOP_TB_BASE + 0x0F)
#define  REG_CHIP_TOP_TB_08_L       (REG_CHIP_TOP_TB_BASE + 0x10)
#define  REG_CHIP_TOP_TB_08_H       (REG_CHIP_TOP_TB_BASE + 0x11)
#define  REG_CHIP_TOP_TB_09_L       (REG_CHIP_TOP_TB_BASE + 0x12)
#define  REG_CHIP_TOP_TB_09_H       (REG_CHIP_TOP_TB_BASE + 0x13)
#define  REG_CHIP_TOP_TB_0A_L       (REG_CHIP_TOP_TB_BASE + 0x14)
#define  REG_CHIP_TOP_TB_0A_H       (REG_CHIP_TOP_TB_BASE + 0x15)
#define  REG_CHIP_TOP_TB_0B_L       (REG_CHIP_TOP_TB_BASE + 0x16)
#define  REG_CHIP_TOP_TB_0B_H       (REG_CHIP_TOP_TB_BASE + 0x17)
#define  REG_CHIP_TOP_TB_0C_L       (REG_CHIP_TOP_TB_BASE + 0x18)
#define  REG_CHIP_TOP_TB_0C_H       (REG_CHIP_TOP_TB_BASE + 0x19)
#define  REG_CHIP_TOP_TB_0D_L       (REG_CHIP_TOP_TB_BASE + 0x1A)
#define  REG_CHIP_TOP_TB_0D_H       (REG_CHIP_TOP_TB_BASE + 0x1B)
#define  REG_CHIP_TOP_TB_0E_L       (REG_CHIP_TOP_TB_BASE + 0x1C)
#define  REG_CHIP_TOP_TB_0E_H       (REG_CHIP_TOP_TB_BASE + 0x1D)
#define  REG_CHIP_TOP_TB_0F_L       (REG_CHIP_TOP_TB_BASE + 0x1E)
#define  REG_CHIP_TOP_TB_0F_H       (REG_CHIP_TOP_TB_BASE + 0x1F)
#define  REG_CHIP_TOP_TB_10_L       (REG_CHIP_TOP_TB_BASE + 0x20)
#define  REG_CHIP_TOP_TB_10_H       (REG_CHIP_TOP_TB_BASE + 0x21)
#define  REG_CHIP_TOP_TB_11_L       (REG_CHIP_TOP_TB_BASE + 0x22)
#define  REG_CHIP_TOP_TB_11_H       (REG_CHIP_TOP_TB_BASE + 0x23)
#define  REG_CHIP_TOP_TB_12_L       (REG_CHIP_TOP_TB_BASE + 0x24)
#define  REG_CHIP_TOP_TB_12_H       (REG_CHIP_TOP_TB_BASE + 0x25)
#define  REG_CHIP_TOP_TB_13_L       (REG_CHIP_TOP_TB_BASE + 0x26)
#define  REG_CHIP_TOP_TB_13_H       (REG_CHIP_TOP_TB_BASE + 0x27)
#define  REG_CHIP_TOP_TB_14_L       (REG_CHIP_TOP_TB_BASE + 0x28)
#define  REG_CHIP_TOP_TB_14_H       (REG_CHIP_TOP_TB_BASE + 0x29)
#define  REG_CHIP_TOP_TB_15_L       (REG_CHIP_TOP_TB_BASE + 0x2A)
#define  REG_CHIP_TOP_TB_15_H       (REG_CHIP_TOP_TB_BASE + 0x2B)
#define  REG_CHIP_TOP_TB_16_L       (REG_CHIP_TOP_TB_BASE + 0x2C)
#define  REG_CHIP_TOP_TB_16_H       (REG_CHIP_TOP_TB_BASE + 0x2D)
#define  REG_CHIP_TOP_TB_17_L       (REG_CHIP_TOP_TB_BASE + 0x2E)
#define  REG_CHIP_TOP_TB_17_H       (REG_CHIP_TOP_TB_BASE + 0x2F)
#define  REG_CHIP_TOP_TB_18_L       (REG_CHIP_TOP_TB_BASE + 0x30)
#define  REG_CHIP_TOP_TB_18_H       (REG_CHIP_TOP_TB_BASE + 0x31)
#define  REG_CHIP_TOP_TB_19_L       (REG_CHIP_TOP_TB_BASE + 0x32)
#define  REG_CHIP_TOP_TB_19_H       (REG_CHIP_TOP_TB_BASE + 0x33)
#define  REG_CHIP_TOP_TB_1A_L       (REG_CHIP_TOP_TB_BASE + 0x34)
#define  REG_CHIP_TOP_TB_1A_H       (REG_CHIP_TOP_TB_BASE + 0x35)
#define  REG_CHIP_TOP_TB_1B_L       (REG_CHIP_TOP_TB_BASE + 0x36)
#define  REG_CHIP_TOP_TB_1B_H       (REG_CHIP_TOP_TB_BASE + 0x37)
#define  REG_CHIP_TOP_TB_1C_L       (REG_CHIP_TOP_TB_BASE + 0x38)
#define  REG_CHIP_TOP_TB_1C_H       (REG_CHIP_TOP_TB_BASE + 0x39)
#define  REG_CHIP_TOP_TB_1D_L       (REG_CHIP_TOP_TB_BASE + 0x3A)
#define  REG_CHIP_TOP_TB_1D_H       (REG_CHIP_TOP_TB_BASE + 0x3B)
#define  REG_CHIP_TOP_TB_1E_L       (REG_CHIP_TOP_TB_BASE + 0x3C)
#define  REG_CHIP_TOP_TB_1E_H       (REG_CHIP_TOP_TB_BASE + 0x3D)
#define  REG_CHIP_TOP_TB_1F_L       (REG_CHIP_TOP_TB_BASE + 0x3E)
#define  REG_CHIP_TOP_TB_1F_H       (REG_CHIP_TOP_TB_BASE + 0x3F)
#define  REG_CHIP_TOP_TB_20_L       (REG_CHIP_TOP_TB_BASE + 0x40)
#define  REG_CHIP_TOP_TB_20_H       (REG_CHIP_TOP_TB_BASE + 0x41)
#define  REG_CHIP_TOP_TB_21_L       (REG_CHIP_TOP_TB_BASE + 0x42)
#define  REG_CHIP_TOP_TB_21_H       (REG_CHIP_TOP_TB_BASE + 0x43)
#define  REG_CHIP_TOP_TB_22_L       (REG_CHIP_TOP_TB_BASE + 0x44)
#define  REG_CHIP_TOP_TB_22_H       (REG_CHIP_TOP_TB_BASE + 0x45)
#define  REG_CHIP_TOP_TB_23_L       (REG_CHIP_TOP_TB_BASE + 0x46)
#define  REG_CHIP_TOP_TB_23_H       (REG_CHIP_TOP_TB_BASE + 0x47)
#define  REG_CHIP_TOP_TB_24_L       (REG_CHIP_TOP_TB_BASE + 0x48)
#define  REG_CHIP_TOP_TB_24_H       (REG_CHIP_TOP_TB_BASE + 0x49)
#define  REG_CHIP_TOP_TB_25_L       (REG_CHIP_TOP_TB_BASE + 0x4A)
#define  REG_CHIP_TOP_TB_25_H       (REG_CHIP_TOP_TB_BASE + 0x4B)
#define  REG_CHIP_TOP_TB_26_L       (REG_CHIP_TOP_TB_BASE + 0x4C)
#define  REG_CHIP_TOP_TB_26_H       (REG_CHIP_TOP_TB_BASE + 0x4D)
#define  REG_CHIP_TOP_TB_27_L       (REG_CHIP_TOP_TB_BASE + 0x4E)
#define  REG_CHIP_TOP_TB_27_H       (REG_CHIP_TOP_TB_BASE + 0x4F)
#define  REG_CHIP_TOP_TB_28_L       (REG_CHIP_TOP_TB_BASE + 0x50)
#define  REG_CHIP_TOP_TB_28_H       (REG_CHIP_TOP_TB_BASE + 0x51)
#define  REG_CHIP_TOP_TB_29_L       (REG_CHIP_TOP_TB_BASE + 0x52)
#define  REG_CHIP_TOP_TB_29_H       (REG_CHIP_TOP_TB_BASE + 0x53)
#define  REG_CHIP_TOP_TB_2A_L       (REG_CHIP_TOP_TB_BASE + 0x54)
#define  REG_CHIP_TOP_TB_2A_H       (REG_CHIP_TOP_TB_BASE + 0x55)
#define  REG_CHIP_TOP_TB_2B_L       (REG_CHIP_TOP_TB_BASE + 0x56)
#define  REG_CHIP_TOP_TB_2B_H       (REG_CHIP_TOP_TB_BASE + 0x57)
#define  REG_CHIP_TOP_TB_2C_L       (REG_CHIP_TOP_TB_BASE + 0x58)
#define  REG_CHIP_TOP_TB_2C_H       (REG_CHIP_TOP_TB_BASE + 0x59)
#define  REG_CHIP_TOP_TB_2D_L       (REG_CHIP_TOP_TB_BASE + 0x5A)
#define  REG_CHIP_TOP_TB_2D_H       (REG_CHIP_TOP_TB_BASE + 0x5B)
#define  REG_CHIP_TOP_TB_2E_L       (REG_CHIP_TOP_TB_BASE + 0x5C)
#define  REG_CHIP_TOP_TB_2E_H       (REG_CHIP_TOP_TB_BASE + 0x5D)
#define  REG_CHIP_TOP_TB_2F_L       (REG_CHIP_TOP_TB_BASE + 0x5E)
#define  REG_CHIP_TOP_TB_2F_H       (REG_CHIP_TOP_TB_BASE + 0x5F)
#define  REG_CHIP_TOP_TB_30_L       (REG_CHIP_TOP_TB_BASE + 0x60)
#define  REG_CHIP_TOP_TB_30_H       (REG_CHIP_TOP_TB_BASE + 0x61)
#define  REG_CHIP_TOP_TB_31_L       (REG_CHIP_TOP_TB_BASE + 0x62)
#define  REG_CHIP_TOP_TB_31_H       (REG_CHIP_TOP_TB_BASE + 0x63)
#define  REG_CHIP_TOP_TB_32_L       (REG_CHIP_TOP_TB_BASE + 0x64)
#define  REG_CHIP_TOP_TB_32_H       (REG_CHIP_TOP_TB_BASE + 0x65)
#define  REG_CHIP_TOP_TB_33_L       (REG_CHIP_TOP_TB_BASE + 0x66)
#define  REG_CHIP_TOP_TB_33_H       (REG_CHIP_TOP_TB_BASE + 0x67)
#define  REG_CHIP_TOP_TB_34_L       (REG_CHIP_TOP_TB_BASE + 0x68)
#define  REG_CHIP_TOP_TB_34_H       (REG_CHIP_TOP_TB_BASE + 0x69)
#define  REG_CHIP_TOP_TB_35_L       (REG_CHIP_TOP_TB_BASE + 0x6A)
#define  REG_CHIP_TOP_TB_35_H       (REG_CHIP_TOP_TB_BASE + 0x6B)
#define  REG_CHIP_TOP_TB_36_L       (REG_CHIP_TOP_TB_BASE + 0x6C)
#define  REG_CHIP_TOP_TB_36_H       (REG_CHIP_TOP_TB_BASE + 0x6D)
#define  REG_CHIP_TOP_TB_37_L       (REG_CHIP_TOP_TB_BASE + 0x6E)
#define  REG_CHIP_TOP_TB_37_H       (REG_CHIP_TOP_TB_BASE + 0x6F)
#define  REG_CHIP_TOP_TB_38_L       (REG_CHIP_TOP_TB_BASE + 0x70)
#define  REG_CHIP_TOP_TB_38_H       (REG_CHIP_TOP_TB_BASE + 0x71)
#define  REG_CHIP_TOP_TB_39_L       (REG_CHIP_TOP_TB_BASE + 0x72)
#define  REG_CHIP_TOP_TB_39_H       (REG_CHIP_TOP_TB_BASE + 0x73)
#define  REG_CHIP_TOP_TB_3A_L       (REG_CHIP_TOP_TB_BASE + 0x74)
#define  REG_CHIP_TOP_TB_3A_H       (REG_CHIP_TOP_TB_BASE + 0x75)
#define  REG_CHIP_TOP_TB_3B_L       (REG_CHIP_TOP_TB_BASE + 0x76)
#define  REG_CHIP_TOP_TB_3B_H       (REG_CHIP_TOP_TB_BASE + 0x77)
#define  REG_CHIP_TOP_TB_3C_L       (REG_CHIP_TOP_TB_BASE + 0x78)
#define  REG_CHIP_TOP_TB_3C_H       (REG_CHIP_TOP_TB_BASE + 0x79)
#define  REG_CHIP_TOP_TB_3D_L       (REG_CHIP_TOP_TB_BASE + 0x7A)
#define  REG_CHIP_TOP_TB_3D_H       (REG_CHIP_TOP_TB_BASE + 0x7B)
#define  REG_CHIP_TOP_TB_3E_L       (REG_CHIP_TOP_TB_BASE + 0x7C)
#define  REG_CHIP_TOP_TB_3E_H       (REG_CHIP_TOP_TB_BASE + 0x7D)
#define  REG_CHIP_TOP_TB_3F_L       (REG_CHIP_TOP_TB_BASE + 0x7E)
#define  REG_CHIP_TOP_TB_3F_H       (REG_CHIP_TOP_TB_BASE + 0x7F)
#define  REG_CHIP_TOP_TB_40_L       (REG_CHIP_TOP_TB_BASE + 0x80)
#define  REG_CHIP_TOP_TB_40_H       (REG_CHIP_TOP_TB_BASE + 0x81)
#define  REG_CHIP_TOP_TB_41_L       (REG_CHIP_TOP_TB_BASE + 0x82)
#define  REG_CHIP_TOP_TB_41_H       (REG_CHIP_TOP_TB_BASE + 0x83)
#define  REG_CHIP_TOP_TB_42_L       (REG_CHIP_TOP_TB_BASE + 0x84)
#define  REG_CHIP_TOP_TB_42_H       (REG_CHIP_TOP_TB_BASE + 0x85)
#define  REG_CHIP_TOP_TB_43_L       (REG_CHIP_TOP_TB_BASE + 0x86)
#define  REG_CHIP_TOP_TB_43_H       (REG_CHIP_TOP_TB_BASE + 0x87)
#define  REG_CHIP_TOP_TB_44_L       (REG_CHIP_TOP_TB_BASE + 0x88)
#define  REG_CHIP_TOP_TB_44_H       (REG_CHIP_TOP_TB_BASE + 0x89)
#define  REG_CHIP_TOP_TB_45_L       (REG_CHIP_TOP_TB_BASE + 0x8A)
#define  REG_CHIP_TOP_TB_45_H       (REG_CHIP_TOP_TB_BASE + 0x8B)
#define  REG_CHIP_TOP_TB_46_L       (REG_CHIP_TOP_TB_BASE + 0x8C)
#define  REG_CHIP_TOP_TB_46_H       (REG_CHIP_TOP_TB_BASE + 0x8D)
#define  REG_CHIP_TOP_TB_47_L       (REG_CHIP_TOP_TB_BASE + 0x8E)
#define  REG_CHIP_TOP_TB_47_H       (REG_CHIP_TOP_TB_BASE + 0x8F)
#define  REG_CHIP_TOP_TB_48_L       (REG_CHIP_TOP_TB_BASE + 0x90)
#define  REG_CHIP_TOP_TB_48_H       (REG_CHIP_TOP_TB_BASE + 0x91)
#define  REG_CHIP_TOP_TB_49_L       (REG_CHIP_TOP_TB_BASE + 0x92)
#define  REG_CHIP_TOP_TB_49_H       (REG_CHIP_TOP_TB_BASE + 0x93)
#define  REG_CHIP_TOP_TB_4A_L       (REG_CHIP_TOP_TB_BASE + 0x94)
#define  REG_CHIP_TOP_TB_4A_H       (REG_CHIP_TOP_TB_BASE + 0x95)
#define  REG_CHIP_TOP_TB_4B_L       (REG_CHIP_TOP_TB_BASE + 0x96)
#define  REG_CHIP_TOP_TB_4B_H       (REG_CHIP_TOP_TB_BASE + 0x97)
#define  REG_CHIP_TOP_TB_4C_L       (REG_CHIP_TOP_TB_BASE + 0x98)
#define  REG_CHIP_TOP_TB_4C_H       (REG_CHIP_TOP_TB_BASE + 0x99)
#define  REG_CHIP_TOP_TB_4D_L       (REG_CHIP_TOP_TB_BASE + 0x9A)
#define  REG_CHIP_TOP_TB_4D_H       (REG_CHIP_TOP_TB_BASE + 0x9B)
#define  REG_CHIP_TOP_TB_4E_L       (REG_CHIP_TOP_TB_BASE + 0x9C)
#define  REG_CHIP_TOP_TB_4E_H       (REG_CHIP_TOP_TB_BASE + 0x9D)
#define  REG_CHIP_TOP_TB_4F_L       (REG_CHIP_TOP_TB_BASE + 0x9E)
#define  REG_CHIP_TOP_TB_4F_H       (REG_CHIP_TOP_TB_BASE + 0x9F)
#define  REG_CHIP_TOP_TB_50_L       (REG_CHIP_TOP_TB_BASE + 0xA0)
#define  REG_CHIP_TOP_TB_50_H       (REG_CHIP_TOP_TB_BASE + 0xA1)
#define  REG_CHIP_TOP_TB_51_L       (REG_CHIP_TOP_TB_BASE + 0xA2)
#define  REG_CHIP_TOP_TB_51_H       (REG_CHIP_TOP_TB_BASE + 0xA3)
#define  REG_CHIP_TOP_TB_52_L       (REG_CHIP_TOP_TB_BASE + 0xA4)
#define  REG_CHIP_TOP_TB_52_H       (REG_CHIP_TOP_TB_BASE + 0xA5)
#define  REG_CHIP_TOP_TB_53_L       (REG_CHIP_TOP_TB_BASE + 0xA6)
#define  REG_CHIP_TOP_TB_53_H       (REG_CHIP_TOP_TB_BASE + 0xA7)
#define  REG_CHIP_TOP_TB_54_L       (REG_CHIP_TOP_TB_BASE + 0xA8)
#define  REG_CHIP_TOP_TB_54_H       (REG_CHIP_TOP_TB_BASE + 0xA9)
#define  REG_CHIP_TOP_TB_55_L       (REG_CHIP_TOP_TB_BASE + 0xAA)
#define  REG_CHIP_TOP_TB_55_H       (REG_CHIP_TOP_TB_BASE + 0xAB)
#define  REG_CHIP_TOP_TB_56_L       (REG_CHIP_TOP_TB_BASE + 0xAC)
#define  REG_CHIP_TOP_TB_56_H       (REG_CHIP_TOP_TB_BASE + 0xAD)
#define  REG_CHIP_TOP_TB_57_L       (REG_CHIP_TOP_TB_BASE + 0xAE)
#define  REG_CHIP_TOP_TB_57_H       (REG_CHIP_TOP_TB_BASE + 0xAF)
#define  REG_CHIP_TOP_TB_58_L       (REG_CHIP_TOP_TB_BASE + 0xB0)
#define  REG_CHIP_TOP_TB_58_H       (REG_CHIP_TOP_TB_BASE + 0xB1)
#define  REG_CHIP_TOP_TB_59_L       (REG_CHIP_TOP_TB_BASE + 0xB2)
#define  REG_CHIP_TOP_TB_59_H       (REG_CHIP_TOP_TB_BASE + 0xB3)
#define  REG_CHIP_TOP_TB_5A_L       (REG_CHIP_TOP_TB_BASE + 0xB4)
#define  REG_CHIP_TOP_TB_5A_H       (REG_CHIP_TOP_TB_BASE + 0xB5)
#define  REG_CHIP_TOP_TB_5B_L       (REG_CHIP_TOP_TB_BASE + 0xB6)
#define  REG_CHIP_TOP_TB_5B_H       (REG_CHIP_TOP_TB_BASE + 0xB7)
#define  REG_CHIP_TOP_TB_5C_L       (REG_CHIP_TOP_TB_BASE + 0xB8)
#define  REG_CHIP_TOP_TB_5C_H       (REG_CHIP_TOP_TB_BASE + 0xB9)
#define  REG_CHIP_TOP_TB_5D_L       (REG_CHIP_TOP_TB_BASE + 0xBA)
#define  REG_CHIP_TOP_TB_5D_H       (REG_CHIP_TOP_TB_BASE + 0xBB)
#define  REG_CHIP_TOP_TB_5E_L       (REG_CHIP_TOP_TB_BASE + 0xBC)
#define  REG_CHIP_TOP_TB_5E_H       (REG_CHIP_TOP_TB_BASE + 0xBD)
#define  REG_CHIP_TOP_TB_5F_L       (REG_CHIP_TOP_TB_BASE + 0xBE)
#define  REG_CHIP_TOP_TB_5F_H       (REG_CHIP_TOP_TB_BASE + 0xBF)
#define  REG_CHIP_TOP_TB_60_L       (REG_CHIP_TOP_TB_BASE + 0xC0)
#define  REG_CHIP_TOP_TB_60_H       (REG_CHIP_TOP_TB_BASE + 0xC1)
#define  REG_CHIP_TOP_TB_61_L       (REG_CHIP_TOP_TB_BASE + 0xC2)
#define  REG_CHIP_TOP_TB_61_H       (REG_CHIP_TOP_TB_BASE + 0xC3)
#define  REG_CHIP_TOP_TB_62_L       (REG_CHIP_TOP_TB_BASE + 0xC4)
#define  REG_CHIP_TOP_TB_62_H       (REG_CHIP_TOP_TB_BASE + 0xC5)
#define  REG_CHIP_TOP_TB_63_L       (REG_CHIP_TOP_TB_BASE + 0xC6)
#define  REG_CHIP_TOP_TB_63_H       (REG_CHIP_TOP_TB_BASE + 0xC7)
#define  REG_CHIP_TOP_TB_64_L       (REG_CHIP_TOP_TB_BASE + 0xC8)
#define  REG_CHIP_TOP_TB_64_H       (REG_CHIP_TOP_TB_BASE + 0xC9)
#define  REG_CHIP_TOP_TB_65_L       (REG_CHIP_TOP_TB_BASE + 0xCA)
#define  REG_CHIP_TOP_TB_65_H       (REG_CHIP_TOP_TB_BASE + 0xCB)
#define  REG_CHIP_TOP_TB_66_L       (REG_CHIP_TOP_TB_BASE + 0xCC)
#define  REG_CHIP_TOP_TB_66_H       (REG_CHIP_TOP_TB_BASE + 0xCD)
#define  REG_CHIP_TOP_TB_67_L       (REG_CHIP_TOP_TB_BASE + 0xCE)
#define  REG_CHIP_TOP_TB_67_H       (REG_CHIP_TOP_TB_BASE + 0xCF)
#define  REG_CHIP_TOP_TB_68_L       (REG_CHIP_TOP_TB_BASE + 0xD0)
#define  REG_CHIP_TOP_TB_68_H       (REG_CHIP_TOP_TB_BASE + 0xD1)
#define  REG_CHIP_TOP_TB_69_L       (REG_CHIP_TOP_TB_BASE + 0xD2)
#define  REG_CHIP_TOP_TB_69_H       (REG_CHIP_TOP_TB_BASE + 0xD3)
#define  REG_CHIP_TOP_TB_6A_L       (REG_CHIP_TOP_TB_BASE + 0xD4)
#define  REG_CHIP_TOP_TB_6A_H       (REG_CHIP_TOP_TB_BASE + 0xD5)
#define  REG_CHIP_TOP_TB_6B_L       (REG_CHIP_TOP_TB_BASE + 0xD6)
#define  REG_CHIP_TOP_TB_6B_H       (REG_CHIP_TOP_TB_BASE + 0xD7)
#define  REG_CHIP_TOP_TB_6C_L       (REG_CHIP_TOP_TB_BASE + 0xD8)
#define  REG_CHIP_TOP_TB_6C_H       (REG_CHIP_TOP_TB_BASE + 0xD9)
#define  REG_CHIP_TOP_TB_6D_L       (REG_CHIP_TOP_TB_BASE + 0xDA)
#define  REG_CHIP_TOP_TB_6D_H       (REG_CHIP_TOP_TB_BASE + 0xDB)
#define  REG_CHIP_TOP_TB_6E_L       (REG_CHIP_TOP_TB_BASE + 0xDC)
#define  REG_CHIP_TOP_TB_6E_H       (REG_CHIP_TOP_TB_BASE + 0xDD)
#define  REG_CHIP_TOP_TB_6F_L       (REG_CHIP_TOP_TB_BASE + 0xDE)
#define  REG_CHIP_TOP_TB_6F_H       (REG_CHIP_TOP_TB_BASE + 0xDF)
#define  REG_CHIP_TOP_TB_70_L       (REG_CHIP_TOP_TB_BASE + 0xE0)
#define  REG_CHIP_TOP_TB_70_H       (REG_CHIP_TOP_TB_BASE + 0xE1)
#define  REG_CHIP_TOP_TB_71_L       (REG_CHIP_TOP_TB_BASE + 0xE2)
#define  REG_CHIP_TOP_TB_71_H       (REG_CHIP_TOP_TB_BASE + 0xE3)
#define  REG_CHIP_TOP_TB_72_L       (REG_CHIP_TOP_TB_BASE + 0xE4)
#define  REG_CHIP_TOP_TB_72_H       (REG_CHIP_TOP_TB_BASE + 0xE5)
#define  REG_CHIP_TOP_TB_73_L       (REG_CHIP_TOP_TB_BASE + 0xE6)
#define  REG_CHIP_TOP_TB_73_H       (REG_CHIP_TOP_TB_BASE + 0xE7)
#define  REG_CHIP_TOP_TB_74_L       (REG_CHIP_TOP_TB_BASE + 0xE8)
#define  REG_CHIP_TOP_TB_74_H       (REG_CHIP_TOP_TB_BASE + 0xE9)
#define  REG_CHIP_TOP_TB_75_L       (REG_CHIP_TOP_TB_BASE + 0xEA)
#define  REG_CHIP_TOP_TB_75_H       (REG_CHIP_TOP_TB_BASE + 0xEB)
#define  REG_CHIP_TOP_TB_76_L       (REG_CHIP_TOP_TB_BASE + 0xEC)
#define  REG_CHIP_TOP_TB_76_H       (REG_CHIP_TOP_TB_BASE + 0xED)
#define  REG_CHIP_TOP_TB_77_L       (REG_CHIP_TOP_TB_BASE + 0xEE)
#define  REG_CHIP_TOP_TB_77_H       (REG_CHIP_TOP_TB_BASE + 0xEF)
#define  REG_CHIP_TOP_TB_78_L       (REG_CHIP_TOP_TB_BASE + 0xF0)
#define  REG_CHIP_TOP_TB_78_H       (REG_CHIP_TOP_TB_BASE + 0xF1)
#define  REG_CHIP_TOP_TB_79_L       (REG_CHIP_TOP_TB_BASE + 0xF2)
#define  REG_CHIP_TOP_TB_79_H       (REG_CHIP_TOP_TB_BASE + 0xF3)
#define  REG_CHIP_TOP_TB_7A_L       (REG_CHIP_TOP_TB_BASE + 0xF4)
#define  REG_CHIP_TOP_TB_7A_H       (REG_CHIP_TOP_TB_BASE + 0xF5)
#define  REG_CHIP_TOP_TB_7B_L       (REG_CHIP_TOP_TB_BASE + 0xF6)
#define  REG_CHIP_TOP_TB_7B_H       (REG_CHIP_TOP_TB_BASE + 0xF7)
#define  REG_CHIP_TOP_TB_7C_L       (REG_CHIP_TOP_TB_BASE + 0xF8)
#define  REG_CHIP_TOP_TB_7C_H       (REG_CHIP_TOP_TB_BASE + 0xF9)
#define  REG_CHIP_TOP_TB_7D_L       (REG_CHIP_TOP_TB_BASE + 0xFA)
#define  REG_CHIP_TOP_TB_7D_H       (REG_CHIP_TOP_TB_BASE + 0xFB)
#define  REG_CHIP_TOP_TB_7E_L       (REG_CHIP_TOP_TB_BASE + 0xFC)
#define  REG_CHIP_TOP_TB_7E_H       (REG_CHIP_TOP_TB_BASE + 0xFD)
#define  REG_CHIP_TOP_TB_7F_L       (REG_CHIP_TOP_TB_BASE + 0xFE)
#define  REG_CHIP_TOP_TB_7F_H       (REG_CHIP_TOP_TB_BASE + 0xFF)

#ifdef __cplusplus
}
#endif

#endif
